/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.dialect;

import java.sql.JDBCType;
import java.util.List;
import java.util.StringJoiner;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.ezorm.rdb.meta.parser.PGSqlTableMetaParser;
import org.hswebframework.ezorm.rdb.meta.parser.TableMetaParser;
import org.hswebframework.ezorm.rdb.render.dialect.DefaultDialect;
import org.hswebframework.ezorm.rdb.render.dialect.term.BoostTermTypeMapper;
import org.hswebframework.utils.StringUtils;

public class PGSqlDialect
extends DefaultDialect {
    public PGSqlDialect() {
        this.defaultDataTypeMapper = meta -> meta.getJdbcType().getName().toLowerCase();
        this.setDataTypeMapper(JDBCType.CHAR, meta -> StringUtils.concat((Object[])new Object[]{"char(", meta.getLength(), ")"}));
        this.setDataTypeMapper(JDBCType.VARCHAR, meta -> StringUtils.concat((Object[])new Object[]{"varchar(", meta.getLength(), ")"}));
        this.setDataTypeMapper(JDBCType.TIMESTAMP, meta -> "timestamp");
        this.setDataTypeMapper(JDBCType.TIME, meta -> "time");
        this.setDataTypeMapper(JDBCType.DATE, meta -> "date");
        this.setDataTypeMapper(JDBCType.CLOB, meta -> "text");
        this.setDataTypeMapper(JDBCType.LONGVARBINARY, meta -> "bytea");
        this.setDataTypeMapper(JDBCType.LONGVARCHAR, meta -> "text");
        this.setDataTypeMapper(JDBCType.BLOB, meta -> "bytea");
        this.setDataTypeMapper(JDBCType.BIGINT, meta -> "bigint");
        this.setDataTypeMapper(JDBCType.DOUBLE, meta -> "double");
        this.setDataTypeMapper(JDBCType.INTEGER, meta -> "integer");
        this.setDataTypeMapper(JDBCType.NUMERIC, meta -> StringUtils.concat((Object[])new Object[]{"numeric(", meta.getPrecision(), ",", meta.getScale(), ")"}));
        this.setDataTypeMapper(JDBCType.DECIMAL, meta -> StringUtils.concat((Object[])new Object[]{"decimal(", meta.getPrecision(), ",", meta.getScale(), ")"}));
        this.setDataTypeMapper(JDBCType.TINYINT, meta -> "smallint");
        this.setDataTypeMapper(JDBCType.BIGINT, meta -> "bigint");
        this.setDataTypeMapper(JDBCType.OTHER, meta -> "other");
        this.setJdbcTypeMapping("int", JDBCType.INTEGER);
        this.setJdbcTypeMapping("int2", JDBCType.INTEGER);
        this.setJdbcTypeMapping("int4", JDBCType.INTEGER);
        this.setJdbcTypeMapping("float8", JDBCType.DOUBLE);
        this.setJdbcTypeMapping("money", JDBCType.DOUBLE);
        this.setJdbcTypeMapping("bool", JDBCType.BOOLEAN);
        this.setJdbcTypeMapping("character", JDBCType.VARCHAR);
        this.setJdbcTypeMapping("xml", JDBCType.VARCHAR);
        this.setJdbcTypeMapping("year", JDBCType.TIME);
        this.setJdbcTypeMapping("datetime", JDBCType.TIMESTAMP);
        this.setJdbcTypeMapping("text", JDBCType.CLOB);
        this.installFunction("concat", param -> {
            List<Object> listParam = BoostTermTypeMapper.convertList(param.getParam());
            StringJoiner joiner = new StringJoiner("||");
            listParam.stream().map(String::valueOf).forEach(joiner::add);
            return joiner.toString();
        });
        this.installFunction("bitand", param -> {
            List<Object> listParam = BoostTermTypeMapper.convertList(param.getParam());
            if (listParam.isEmpty()) {
                throw new IllegalArgumentException("[BITAND]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            StringJoiner joiner = new StringJoiner("&");
            listParam.stream().map(String::valueOf).forEach(joiner::add);
            return joiner.toString();
        });
    }

    @Override
    public String getQuoteStart() {
        return "\"";
    }

    @Override
    public String getQuoteEnd() {
        return "\"";
    }

    @Override
    public String doPaging(String sql, int pageIndex, int pageSize, boolean prepare) {
        if (prepare) {
            return sql + " limit #{pageSize} offset #{pageSize}*#{pageIndex}";
        }
        return sql + " limit " + pageSize + " offset " + pageSize * pageIndex;
    }

    @Override
    public boolean columnToUpperCase() {
        return false;
    }

    @Override
    public TableMetaParser getDefaultParser(SqlExecutor sqlExecutor) {
        return new PGSqlTableMetaParser(sqlExecutor);
    }
}

