/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.support.oracle;

import java.util.ArrayList;
import java.util.List;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.support.simple.AbstractMetaAlterRender;

public class OracleMetaAlterRender
extends AbstractMetaAlterRender {
    public OracleMetaAlterRender(RDBDatabaseMetaData databaseMetaData) {
        super(databaseMetaData);
    }

    @Override
    protected List<SqlAppender> buildAdd(RDBColumnMetaData column) {
        SqlAppender alter = new SqlAppender();
        SqlAppender comments = new SqlAppender();
        ArrayList<SqlAppender> all = new ArrayList<SqlAppender>();
        alter.add("ALTER TABLE ", column.getTableMetaData().getFullName(), " ADD ", column.getName(), " ");
        if (column.getColumnDefinition() != null) {
            alter.add(column.getColumnDefinition());
        } else {
            alter.add(column.getDataType());
            if (column.isNotNull() || column.isPrimaryKey()) {
                alter.add(" NOT NULL");
            }
            if (column.getComment() != null) {
                comments.add(String.format("COMMENT ON COLUMN %s.\"%s\" is '%s'", column.getTableMetaData().getFullName(), column.getName().toUpperCase(), column.getComment()));
            }
        }
        all.add(alter);
        all.add(comments);
        return all;
    }

    @Override
    protected List<SqlAppender> buildAlter(RDBColumnMetaData column) {
        SqlAppender alter = new SqlAppender();
        SqlAppender comments = new SqlAppender();
        ArrayList<SqlAppender> all = new ArrayList<SqlAppender>();
        alter.add("ALTER TABLE ", column.getTableMetaData().getName(), " MODIFY ", column.getName(), " ");
        if (column.getColumnDefinition() != null) {
            alter.add(column.getColumnDefinition());
        } else {
            alter.add(column.getDataType());
            if (column.isNotNull() || column.isPrimaryKey()) {
                alter.add(" NOT NULL");
            }
            if (column.getComment() != null) {
                comments.add(String.format("COMMENT ON COLUMN %s.\"%s\" is '%s'", column.getTableMetaData().getFullName(), column.getName().toUpperCase(), column.getComment()));
            }
        }
        all.add(alter);
        all.add(comments);
        return all;
    }
}

