/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.support.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hswebframework.ezorm.core.param.Param;
import org.hswebframework.ezorm.rdb.meta.Correlation;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.render.SqlRender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonSqlRender<R extends Param>
implements SqlRender<R> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public List<OperationColumn> parseOperationField(RDBTableMetaData metaData, R param) {
        Set includes = param.getIncludes();
        Set excludes = param.getExcludes();
        boolean includesIsEmpty = includes.isEmpty();
        boolean excludesIsEmpty = excludes.isEmpty();
        ArrayList<OperationColumn> tmp = new ArrayList<OperationColumn>();
        if (includesIsEmpty && excludesIsEmpty) {
            metaData.getColumns().forEach(column -> tmp.add(new OperationColumn(null, (RDBColumnMetaData)column)));
            return tmp;
        }
        if (includesIsEmpty) {
            boolean hasSelf = false;
            for (String exclude : excludes) {
                if (exclude.contains(".")) {
                    includes.add(exclude.split("[.]")[0] + ".*");
                    continue;
                }
                hasSelf = true;
            }
            if (hasSelf) {
                includes.add("*");
            }
        }
        includes.forEach(include -> {
            if (excludes.contains(include)) {
                return;
            }
            if ("*".equals(include)) {
                metaData.getColumns().forEach(column -> {
                    if (excludes.contains(column.getAlias()) || excludes.contains(column.getName())) {
                        return;
                    }
                    tmp.add(new OperationColumn(null, (RDBColumnMetaData)column));
                });
                return;
            }
            RDBColumnMetaData column2 = metaData.findColumn((String)include);
            if (null != column2) {
                if (excludes.contains(column2.getAlias()) || excludes.contains(column2.getName())) {
                    return;
                }
                if (!column2.getTableMetaData().getName().equals(metaData.getName())) {
                    Correlation correlation = metaData.getCorrelation(column2.getTableMetaData().getName());
                    if (null != correlation) {
                        tmp.add(new OperationColumn(correlation.getAlias(), column2));
                    } else {
                        tmp.add(new OperationColumn(column2.getTableMetaData().getAlias(), column2));
                    }
                } else {
                    tmp.add(new OperationColumn(column2.getTableMetaData().getAlias(), column2));
                }
            } else if (include.contains(".")) {
                String[] columnInfo = include.split("[.]");
                RDBTableMetaData table = metaData.getDatabaseMetaData().getTableMetaData(columnInfo[0]);
                String tname = null;
                if (null == table) {
                    Correlation correlation = metaData.getCorrelation(columnInfo[0]);
                    if (correlation != null) {
                        table = metaData.getDatabaseMetaData().getTableMetaData(correlation.getTargetTable());
                        tname = correlation.getAlias();
                    }
                } else {
                    tname = table.getAlias();
                }
                if (null == table) {
                    return;
                }
                if (columnInfo[1].equals("*")) {
                    String finalName = tname;
                    table.getColumns().forEach(nestColumn -> {
                        if (excludes.contains(nestColumn.getFullAliasName()) || excludes.contains(nestColumn.getFullName()) || excludes.contains(finalName + "." + nestColumn.getName()) || excludes.contains(finalName + "." + nestColumn.getAlias())) {
                            return;
                        }
                        tmp.add(new OperationColumn(finalName, (RDBColumnMetaData)nestColumn));
                    });
                    return;
                }
                column2 = metaData.findColumn((String)include);
                if (null != column2) {
                    if (excludes.contains(column2.getFullAliasName()) || excludes.contains(column2.getFullName())) {
                        return;
                    }
                    tmp.add(new OperationColumn(tname, column2));
                }
            }
        });
        if (tmp.isEmpty()) {
            throw new UnsupportedOperationException("\u672a\u627e\u5230\u4efb\u4f55\u67e5\u8be2\u5b57\u6bb5!");
        }
        return tmp;
    }

    public class OperationColumn {
        private String tableName;
        private RDBColumnMetaData RDBColumnMetaData;

        public OperationColumn(String tableName, RDBColumnMetaData RDBColumnMetaData2) {
            this.tableName = tableName;
            this.RDBColumnMetaData = RDBColumnMetaData2;
            if (tableName == null) {
                this.tableName = RDBColumnMetaData2.getTableMetaData().getAlias();
            }
        }

        public String getTableName() {
            return this.tableName;
        }

        public RDBColumnMetaData getRDBColumnMetaData() {
            return this.RDBColumnMetaData;
        }
    }
}

