/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.support.simple;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.hswebframework.ezorm.core.param.UpdateParam;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.render.Sql;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.dialect.Dialect;
import org.hswebframework.ezorm.rdb.render.support.simple.CommonSqlRender;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleSQL;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleWhereSqlBuilder;
import org.hswebframework.ezorm.rdb.utils.PropertiesUtils;

public class SimpleUpdateSqlRender
extends CommonSqlRender<UpdateParam> {
    private Dialect dialect;

    protected SqlAppender getParamString(String paramName, RDBColumnMetaData rdbColumnMetaData) {
        return new SqlAppender().add("#{", paramName, "}");
    }

    @Override
    public SQL render(RDBTableMetaData metaData, UpdateParam param) {
        return new SimpleUpdateSqlRenderProcess(metaData, param).process();
    }

    public SimpleUpdateSqlRender(Dialect dialect) {
        this.dialect = dialect;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    class SimpleUpdateSqlRenderProcess
    extends SimpleWhereSqlBuilder {
        private RDBTableMetaData metaData;
        private UpdateParam param;
        private List<CommonSqlRender.OperationColumn> updateField;
        private SqlAppender whereSql = new SqlAppender();
        private Set<String> conditionTable = new LinkedHashSet<String>();
        PropertyUtilsBean propertyUtils = BeanUtilsBean.getInstance().getPropertyUtils();

        public SimpleUpdateSqlRenderProcess(RDBTableMetaData metaData, UpdateParam param) {
            this.metaData = metaData;
            this.param = param;
            List terms = param.getTerms();
            terms = terms.stream().filter(term -> term.getColumn() == null || !term.getColumn().contains(".")).collect(Collectors.toList());
            param.setTerms(terms);
            this.updateField = SimpleUpdateSqlRender.this.parseOperationField(metaData, param);
            this.buildWhere(metaData, "", param.getTerms(), this.whereSql, this.conditionTable);
            if (!this.whereSql.isEmpty()) {
                this.whereSql.removeFirst();
            }
        }

        public SQL process() {
            SqlAppender appender = new SqlAppender();
            appender.add("UPDATE ", this.metaData.getFullName(), " ", this.metaData.getAlias(), " SET ");
            byte[] bytes = new byte[1];
            HashMap valueProxy = new HashMap();
            this.updateField.forEach(operationColumn -> {
                RDBColumnMetaData column = operationColumn.getRDBColumnMetaData();
                if (column.getProperty("read-only").isTrue()) {
                    return;
                }
                String dataProperty = null;
                dataProperty = column.getAlias();
                Object value = PropertiesUtils.getProperty(this.param.getData(), dataProperty).orElse(null);
                if (value == null && !column.getAlias().equals(column.getName())) {
                    dataProperty = column.getName();
                    value = PropertiesUtils.getProperty(this.param.getData(), dataProperty).orElse(null);
                }
                boolean alwaysUpdate = column.getProperty("update-always", false).isTrue();
                if (value == null) {
                    if (alwaysUpdate && column.getDefaultValue() != null) {
                        value = column.getDefaultValue().get();
                    }
                    if (value == null) {
                        if (SimpleUpdateSqlRender.this.logger.isInfoEnabled()) {
                            SimpleUpdateSqlRender.this.logger.info("\u8df3\u8fc7\u4fee\u6539\u5217:[{}], \u5c5e\u6027[{}]\u4e3anull!", (Object)column.getName(), (Object)column.getAlias());
                        }
                        return;
                    }
                }
                if (!(value instanceof Sql) && column.getValueConverter() != null) {
                    Object newValue = column.getValueConverter().getData(value);
                    if (column.getOptionConverter() != null) {
                        newValue = column.getOptionConverter().converterData(newValue);
                    }
                    if (value != newValue && !value.equals(newValue)) {
                        value = newValue;
                    }
                }
                valueProxy.put(dataProperty, value);
                appender.add(SimpleUpdateSqlRender.this.dialect.buildColumnName(null, column.getName()), "=");
                if (value instanceof Sql) {
                    appender.add(((Sql)value).getSql());
                } else {
                    appender.addAll(SimpleUpdateSqlRender.this.getParamString("data.".concat(dataProperty), column));
                }
                appender.add(",");
                bytes[0] = (byte)(bytes[0] + 1);
            });
            if (bytes[0] == 0) {
                throw new IndexOutOfBoundsException("\u6ca1\u6709\u5217\u88ab\u4fee\u6539!");
            }
            appender.removeLast();
            if (this.whereSql.isEmpty()) {
                throw new UnsupportedOperationException("\u7981\u6b62\u6267\u884c\u672a\u8bbe\u7f6e\u4efb\u4f55\u6761\u4ef6\u7684\u4fee\u6539\u64cd\u4f5c!");
            }
            appender.add(" WHERE ", "").addAll(this.whereSql);
            String sql = appender.toString();
            this.param.setData(valueProxy);
            SimpleSQL simpleSQL = new SimpleSQL(sql, this.param);
            return simpleSQL;
        }

        @Override
        public Dialect getDialect() {
            return SimpleUpdateSqlRender.this.dialect;
        }
    }
}

