/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.support.sqlserver;

import java.util.HashMap;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleSQL;

public abstract class CommentSupportRender {
    private static final String dropTableCommentSql = "IF exists(SELECT 1 FROM fn_listextendedproperty('MS_Description', 'SCHEMA', 'dbo', 'TABLE', #{table}, NULL, NULL) WHERE name = 'MS_Description') EXEC sp_dropextendedproperty 'MS_Description', 'SCHEMA', 'dbo', 'TABLE', #{table}";
    private static final String tableCommentSql = "EXEC sp_addextendedproperty 'MS_Description', #{comment}, 'SCHEMA', 'dbo', 'TABLE', #{table}";
    private static final String dropAndCreateTableComment = "IF exists(SELECT 1 FROM fn_listextendedproperty('MS_Description', 'SCHEMA', 'dbo', 'TABLE', #{table}, NULL, NULL) WHERE name = 'MS_Description') EXEC sp_dropextendedproperty 'MS_Description', 'SCHEMA', 'dbo', 'TABLE', #{table}".concat(";").concat("EXEC sp_addextendedproperty 'MS_Description', #{comment}, 'SCHEMA', 'dbo', 'TABLE', #{table}");
    private static final String dropColumnCommentSql = "IF exists(SELECT 1 FROM fn_listextendedproperty('MS_Description', 'SCHEMA', 'dbo', 'TABLE', #{table}, 'column', #{column}) WHERE name = 'MS_Description') EXEC sp_dropextendedproperty 'MS_Description', 'SCHEMA', 'dbo', 'TABLE', #{table}, 'column', #{column}";
    private static final String columnCommentSql = "EXEC sp_addextendedproperty 'MS_Description', #{comment}, 'SCHEMA', 'dbo', 'TABLE', #{table}, 'column', #{column}";
    private static final String dropAndCreateColumnComment = "IF exists(SELECT 1 FROM fn_listextendedproperty('MS_Description', 'SCHEMA', 'dbo', 'TABLE', #{table}, NULL, NULL) WHERE name = 'MS_Description') EXEC sp_dropextendedproperty 'MS_Description', 'SCHEMA', 'dbo', 'TABLE', #{table}".concat(";").concat("EXEC sp_addextendedproperty 'MS_Description', #{comment}, 'SCHEMA', 'dbo', 'TABLE', #{table}");

    protected abstract boolean isDropCommentBefore();

    public SQL buildDropTableCommentSql(String tableName, String comment) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("table", tableName);
        param.put("comment", comment);
        return new SimpleSQL(dropTableCommentSql, param);
    }

    public SQL buildTableCommentSql(String tableName, String comment) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("table", tableName);
        param.put("comment", comment);
        return new SimpleSQL(this.isDropCommentBefore() ? dropAndCreateTableComment : tableCommentSql, param);
    }

    public SQL buildColumnCommentSql(String tableName, String column, String comment) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("table", tableName);
        param.put("comment", comment);
        param.put("column", column);
        return new SimpleSQL(this.isDropCommentBefore() ? dropAndCreateColumnComment : columnCommentSql, param);
    }

    public SQL buildDropColumnCommentSql(String tableName, String column, String comment) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("table", tableName);
        param.put("comment", comment);
        param.put("column", column);
        return new SimpleSQL(dropColumnCommentSql, param);
    }
}

