/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.simple.wrapper;

import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.hswebframework.ezorm.core.ObjectWrapper;
import org.hswebframework.ezorm.core.ValueConverter;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanWrapper<T>
implements ObjectWrapper<T> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private InstanceCreator<T> creator;
    private RDBTableMetaData tableMetaData;
    private Class<T> type;
    private static final PropertyUtilsBean propertyUtil = BeanUtilsBean.getInstance().getPropertyUtils();

    public BeanWrapper(InstanceCreator<T> creator, RDBTableMetaData tableMetaData) {
        this.creator = creator;
        this.tableMetaData = tableMetaData;
        this.type = creator.newInstance().getClass();
    }

    public Class<T> getType() {
        return this.type;
    }

    public T newInstance() {
        return this.creator.newInstance();
    }

    public void wrapper(T instance, int index, String attr, Object value) {
        RDBColumnMetaData metaData = this.tableMetaData.findColumn(attr);
        if (metaData != null) {
            try {
                ValueConverter valueConverter = metaData.getValueConverter();
                propertyUtil.setProperty(instance, attr, valueConverter.getValue(value));
            }
            catch (NoSuchMethodException valueConverter) {
            }
            catch (Throwable e) {
                this.logger.warn("{}.setProperty('{}',{});error ", new Object[]{instance.getClass().getName(), attr, value, e});
            }
        }
    }

    public boolean done(T instance) {
        return true;
    }

    public static interface InstanceCreator<T> {
        public T newInstance();
    }
}

