/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.concurrent.lock.starter;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.hswebframework.web.ExpressionUtils;
import org.hswebframework.web.boost.aop.context.MethodInterceptorHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class LockProcessor<A extends Annotation, L> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private A lockAnn;
    private MethodInterceptorHolder interceptorHolder;
    private Function<A, String[]> lockNameGetter;
    private Function<String, L> lockGetter;
    private LockAccepter<L> lockAccepter;
    private LockAccepter<L> unlockAccepter;
    private Map<String, L> lockStore = new HashMap<String, L>();
    private List<L> successLock = new ArrayList<L>();

    private LockProcessor() {
    }

    public static <A extends Annotation, L> LockProcessor<A, L> build(A annotation, MethodInterceptorHolder holder) {
        LockProcessor<A, L> alLockProcessor = new LockProcessor<A, L>();
        alLockProcessor.lockAnn = annotation;
        alLockProcessor.interceptorHolder = holder;
        return alLockProcessor;
    }

    public LockProcessor<A, L> lockNameIs(Function<A, String[]> lockNameGetter) {
        this.lockNameGetter = lockNameGetter;
        return this;
    }

    public LockProcessor<A, L> lockIs(Function<String, L> lockGetter) {
        this.lockGetter = lockGetter;
        return this;
    }

    public LockProcessor<A, L> lock(LockAccepter<L> lockAccepter) {
        this.lockAccepter = lockAccepter;
        return this;
    }

    public LockProcessor<A, L> unlock(LockAccepter<L> unlockAccepter) {
        this.unlockAccepter = unlockAccepter;
        return this;
    }

    public LockProcessor<A, L> init() {
        Objects.requireNonNull(this.lockAnn);
        Objects.requireNonNull(this.interceptorHolder);
        Objects.requireNonNull(this.lockNameGetter);
        String[] lockNameArr = this.lockNameGetter.apply(this.lockAnn);
        if (lockNameArr.length == 0) {
            String name = this.createLockName(null);
            this.lockStore.put(name, this.lockGetter.apply(name));
        } else {
            for (String expression : lockNameArr) {
                String name = this.createLockName(expression);
                this.lockStore.put(name, this.lockGetter.apply(name));
            }
        }
        return this;
    }

    protected String createLockName(String expression) {
        try {
            if (StringUtils.isEmpty((Object)expression)) {
                return this.interceptorHolder.getMethod().getName().concat("_").concat(this.interceptorHolder.getId());
            }
            return ExpressionUtils.analytical((String)expression, (Map)this.interceptorHolder.getArgs(), (String)"spel");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Throwable doLock() {
        Throwable lockError = null;
        for (Map.Entry<String, L> lock : this.lockStore.entrySet()) {
            try {
                boolean success = this.lockAccepter.accept(lock.getValue());
                if (!success) {
                    return new TimeoutException("try lock " + lock.getKey() + " error");
                }
                this.successLock.add(lock.getValue());
            }
            catch (Throwable throwable) {
                lockError = throwable;
            }
        }
        return lockError;
    }

    public void doUnlock() {
        for (L lock : this.successLock) {
            try {
                this.unlockAccepter.accept(lock);
            }
            catch (Throwable error) {
                this.logger.error("unlock {} error", (Object)this.interceptorHolder.getMethod(), (Object)error);
            }
        }
    }

    public static interface LockAccepter<T> {
        public boolean accept(T var1) throws Throwable;
    }
}

