/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.datasource.simple;

import java.io.Closeable;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.hswebframework.web.BusinessException;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.datasource.DataSourceHolder;
import org.hswebframework.web.datasource.DynamicDataSource;
import org.hswebframework.web.datasource.DynamicDataSourceProxy;
import org.hswebframework.web.datasource.config.DynamicDataSourceConfigRepository;
import org.hswebframework.web.datasource.service.AbstractDynamicDataSourceService;
import org.hswebframework.web.datasource.service.DataSourceCache;
import org.hswebframework.web.service.datasource.simple.InDBDynamicDataSourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

@Transactional(propagation=Propagation.NOT_SUPPORTED)
public class InDBDynamicDataSourceService
extends AbstractDynamicDataSourceService<InDBDynamicDataSourceConfig> {
    private static final Logger log = LoggerFactory.getLogger(InDBDynamicDataSourceService.class);
    ExecutorService executorService = Executors.newFixedThreadPool(2);

    public InDBDynamicDataSourceService(DynamicDataSourceConfigRepository<InDBDynamicDataSourceConfig> repository, DynamicDataSource defaultDataSource) {
        super(repository, defaultDataSource);
    }

    public DynamicDataSource getDataSource(String dataSourceId) {
        try {
            DataSourceHolder.switcher().useDefault();
            DynamicDataSource dynamicDataSource = super.getDataSource(dataSourceId);
            return dynamicDataSource;
        }
        finally {
            DataSourceHolder.switcher().useLast();
        }
    }

    protected void closeDataSource(DataSource dataSource) {
        if (null == dataSource) {
            return;
        }
        try {
            if (dataSource instanceof Closeable) {
                ((Closeable)((Object)dataSource)).close();
            } else {
                Method closeMethod = ReflectionUtils.findMethod(dataSource.getClass(), (String)"close");
                if (closeMethod != null) {
                    ReflectionUtils.invokeMethod((Method)closeMethod, (Object)dataSource);
                }
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed\u6570\u636e\u6e90[{}]\u5931\u8d25", (Object)dataSource, (Object)e);
        }
    }

    protected DataSourceCache createCache(InDBDynamicDataSourceConfig config) {
        if (config.getProperties() == null) {
            throw new UnsupportedOperationException("\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        CountDownLatch initCountDownLatch = new CountDownLatch(1);
        DataSourceProperties dataSourceProperties = new DataSourceProperties();
        FastBeanCopier.copy(config.getProperties(), (Object)dataSourceProperties, (String[])new String[0]);
        AtomicReference dataSourceReference = new AtomicReference();
        final AtomicBoolean closed = new AtomicBoolean();
        AtomicBoolean success = new AtomicBoolean();
        int initTimeOut = Integer.parseInt(String.valueOf(config.getProperties().getOrDefault("InitTimeout", "20")));
        this.executorService.submit(() -> {
            try {
                DataSource dataSource = dataSourceProperties.initializeDataSourceBuilder().build();
                dataSourceReference.set(dataSource);
                FastBeanCopier.copy(config.getProperties(), (Object)dataSource, (String[])new String[0]);
                dataSource.getConnection().close();
                if (closed.get()) {
                    this.closeDataSource(dataSource);
                } else {
                    success.set(true);
                }
            }
            catch (Exception e) {
                log.warn("\u521d\u59cb\u5316\u6570\u636e\u6e90[{}]\u5931\u8d25", (Object)config.getId(), (Object)e);
            }
            finally {
                initCountDownLatch.countDown();
            }
        });
        try {
            boolean bl = initCountDownLatch.await(initTimeOut, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!success.get()) {
            closed.set(true);
            this.closeDataSource((DataSource)dataSourceReference.get());
            throw new BusinessException("\u521d\u59cb\u5316\u6570\u636e\u6e90[" + config.getId() + "]\u5931\u8d25");
        }
        return new DataSourceCache(config.getProperties().hashCode(), (DynamicDataSource)new DynamicDataSourceProxy(config.getId(), (DataSource)dataSourceReference.get()), initCountDownLatch, config){

            public void closeDataSource() {
                super.closeDataSource();
                closed.set(true);
                InDBDynamicDataSourceService.this.closeDataSource(this.getDataSource().getNative());
            }
        };
    }
}

