/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dictionary.simple;

import org.hswebframework.web.dictionary.api.DictionaryParser;
import org.hswebframework.web.dictionary.api.DictionaryParserService;
import org.hswebframework.web.dictionary.api.builder.DictionaryParserBuilder;
import org.hswebframework.web.dictionary.api.entity.DictionaryEntity;
import org.hswebframework.web.dictionary.api.entity.DictionaryParserEntity;
import org.hswebframework.web.dictionary.simple.SimpleDictionaryParser;
import org.hswebframework.web.dictionary.simple.dao.DictionaryParserDao;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.GenericEntityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dictionaryParserService")
public class SimpleDictionaryParserService
extends GenericEntityService<DictionaryParserEntity, String>
implements DictionaryParserService {
    @Autowired
    private DictionaryParserDao dictionaryParserDao;
    @Autowired
    private DictionaryParserBuilder dictionaryParserBuilder;

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public DictionaryParserDao getDao() {
        return this.dictionaryParserDao;
    }

    public <V> DictionaryParser<V> getParser(DictionaryEntity dict, String parserId) {
        DictionaryParserEntity entity = (DictionaryParserEntity)this.selectByPk(parserId);
        SimpleDictionaryParserService.assertNotNull((Object)entity);
        SimpleDictionaryParser parser = new SimpleDictionaryParser();
        parser.setToValueParser(this.dictionaryParserBuilder.build(entity.getTextToValueParser()));
        parser.setToTextParser(this.dictionaryParserBuilder.build(entity.getValueToTextParser()));
        return parser;
    }
}

