/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dictionary.simple;

import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.dictionary.api.DictionaryService;
import org.hswebframework.web.dictionary.api.entity.DictionaryEntity;
import org.hswebframework.web.dictionary.api.events.ClearDictionaryCacheEvent;
import org.hswebframework.web.dictionary.simple.dao.DictionaryDao;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.GenericEntityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service(value="dictionaryService")
@CacheConfig(cacheNames={"dictionary"})
public class SimpleDictionaryService
extends GenericEntityService<DictionaryEntity, String>
implements DictionaryService {
    @Autowired
    private DictionaryDao dictionaryDao;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public DictionaryDao getDao() {
        return this.dictionaryDao;
    }

    public String insert(DictionaryEntity entity) {
        String id = (String)super.insert((GenericEntity)entity);
        this.eventPublisher.publishEvent((Object)new ClearDictionaryCacheEvent(id));
        return id;
    }

    public int updateByPk(String id, DictionaryEntity entity) {
        this.eventPublisher.publishEvent((Object)new ClearDictionaryCacheEvent(id));
        return super.updateByPk((Object)id, (GenericEntity)entity);
    }

    public DictionaryEntity deleteByPk(String id) {
        this.eventPublisher.publishEvent((Object)new ClearDictionaryCacheEvent(id));
        return (DictionaryEntity)super.deleteByPk((Object)id);
    }
}

