/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.oauth2.server.simple;

import org.hswebframework.ezorm.core.dsl.Delete;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.web.authorization.oauth2.server.support.code.AuthorizationCode;
import org.hswebframework.web.authorization.oauth2.server.support.code.AuthorizationCodeRequest;
import org.hswebframework.web.authorization.oauth2.server.support.code.AuthorizationCodeService;
import org.hswebframework.web.commons.entity.factory.EntityFactory;
import org.hswebframework.web.dao.dynamic.DeleteByEntityDao;
import org.hswebframework.web.dao.dynamic.QueryByEntityDao;
import org.hswebframework.web.dao.oauth2.server.AuthorizationCodeDao;
import org.hswebframework.web.entity.oauth2.server.AuthorizationCodeEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.DefaultDSLDeleteService;
import org.hswebframework.web.service.DefaultDSLQueryService;
import org.hswebframework.web.service.oauth2.server.simple.CodeGenerator;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class SimpleAuthorizationCodeService
implements AuthorizationCodeService {
    private AuthorizationCodeDao authorizationCodeDao;
    private EntityFactory entityFactory;
    private CodeGenerator codeGenerator = () -> ((IDGenerator)IDGenerator.MD5).generate();

    public SimpleAuthorizationCodeService(AuthorizationCodeDao authorizationCodeDao, EntityFactory entityFactory) {
        this.authorizationCodeDao = authorizationCodeDao;
        this.entityFactory = entityFactory;
    }

    public SimpleAuthorizationCodeService setCodeGenerator(CodeGenerator codeGenerator) {
        if (codeGenerator != null) {
            this.codeGenerator = codeGenerator;
        }
        return this;
    }

    public String createAuthorizationCode(AuthorizationCodeRequest request) {
        AuthorizationCodeEntity codeEntity = (AuthorizationCodeEntity)this.entityFactory.newInstance(AuthorizationCodeEntity.class);
        codeEntity.setClientId(request.getClientId());
        codeEntity.setRedirectUri(request.getRedirectUri());
        codeEntity.setCreateTime(System.currentTimeMillis());
        codeEntity.setUserId(request.getUserId());
        codeEntity.setScope(request.getScope());
        codeEntity.setCode(this.codeGenerator.generate());
        this.authorizationCodeDao.insert(codeEntity);
        return codeEntity.getCode();
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public AuthorizationCode consumeAuthorizationCode(String code) {
        AuthorizationCodeEntity codeEntity = (AuthorizationCodeEntity)((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.authorizationCodeDao).where("code", (Object)code)).single();
        ((Delete)DefaultDSLDeleteService.createDelete((DeleteByEntityDao)this.authorizationCodeDao).where("code", (Object)code)).exec();
        return codeEntity;
    }
}

