/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.app.mgt.ui;

import java.rmi.RemoteException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.jaggery.app.mgt.stub.JaggeryAppAdminStub;
import org.jaggeryjs.jaggery.app.mgt.stub.types.carbon.WebappUploadData;

public class JaggeryAdminClient {
    private static final String CANNOT_EXPIRE_ALL_SESSIONS_IN_WEBAPPS = "cannot.expire.all.sessions.in.webapps";
    private static final String CANNOT_DELETE_WEBAPPS = "cannot.delete.webapps";
    public static final String BUNDLE = "org.jaggeryjs.jaggery.app.mgt.ui.i18n.Resources";
    private static final Log log = LogFactory.getLog(JaggeryAdminClient.class);
    private ResourceBundle bundle;
    private JaggeryAppAdminStub stub;

    public JaggeryAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "JaggeryAppAdmin";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new JaggeryAppAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
        option.setProperty("enableMTOM", (Object)"true");
    }

    public void uploadWebapp(WebappUploadData[] webappUploadDataList) throws AxisFault {
        try {
            this.stub.uploadWebapp(webappUploadDataList);
        }
        catch (RemoteException e) {
            this.handleException("cannot.upload.webapps", e);
        }
    }

    private void handleException(String msgKey, Exception e) throws AxisFault {
        String msg = this.bundle.getString(msgKey);
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

