/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CodeGeneratorService;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public abstract class PJConverter
implements Serializable {
    private static HashMap jpmap = new HashMap();

    public static SequenceType getEquivalentItemType(Class clazz) {
        return (SequenceType)jpmap.get(clazz);
    }

    public abstract Object convert(ValueRepresentation var1, Class var2, XPathContext var3) throws XPathException;

    public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
        throw new UnsupportedOperationException("Cannot generate Java code to support argument conversion for " + this.getClass());
    }

    public static PJConverter allocate(Configuration configuration, ItemType itemType, int n, Class clazz) throws XPathException {
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        if (clazz == SequenceIterator.class) {
            return ToSequenceIterator.INSTANCE;
        }
        if (clazz == ValueRepresentation.class || clazz == Item.class) {
            return Identity.INSTANCE;
        }
        if (clazz == Value.class | clazz == SequenceExtent.class) {
            return ToSequenceExtent.INSTANCE;
        }
        List list = configuration.getExternalObjectModels();
        for (int i = 0; i < list.size(); ++i) {
            ExternalObjectModel externalObjectModel = (ExternalObjectModel)list.get(i);
            PJConverter pJConverter = externalObjectModel.getPJConverter(clazz);
            if (pJConverter == null) continue;
            return pJConverter;
        }
        if (NodeInfo.class.isAssignableFrom(clazz)) {
            return Identity.INSTANCE;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return ToCollection.INSTANCE;
        }
        if (clazz.isArray()) {
            PJConverter pJConverter = PJConverter.allocate(configuration, itemType, 16384, clazz.getComponentType());
            return new ToArray(pJConverter);
        }
        if (!Cardinality.allowsMany(n)) {
            if (itemType.isAtomicType()) {
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.STRING)) {
                    if (clazz == Object.class || clazz == String.class || clazz == CharSequence.class) {
                        return StringValueToString.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(StringValue.class)) {
                        return Identity.INSTANCE;
                    }
                    if (clazz == Character.TYPE || clazz == Character.class) {
                        return StringValueToChar.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (itemType == BuiltInAtomicType.UNTYPED_ATOMIC) {
                    if (clazz == Object.class || clazz == String.class || clazz == CharSequence.class) {
                        return StringValueToString.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(UntypedAtomicValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.BOOLEAN)) {
                    if (clazz == Object.class || clazz == Boolean.class || clazz == Boolean.TYPE) {
                        return BooleanValueToBoolean.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(BooleanValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.INTEGER)) {
                    if (clazz == Object.class || clazz == BigInteger.class) {
                        return IntegerValueToBigInteger.INSTANCE;
                    }
                    if (clazz == Long.TYPE || clazz == Long.class) {
                        return IntegerValueToLong.INSTANCE;
                    }
                    if (clazz == Integer.TYPE || clazz == Integer.class) {
                        return IntegerValueToInt.INSTANCE;
                    }
                    if (clazz == Short.TYPE || clazz == Short.class) {
                        return IntegerValueToShort.INSTANCE;
                    }
                    if (clazz == Byte.TYPE || clazz == Byte.class) {
                        return IntegerValueToByte.INSTANCE;
                    }
                    if (clazz == Character.TYPE || clazz == Character.class) {
                        return IntegerValueToChar.INSTANCE;
                    }
                    if (clazz == Double.TYPE || clazz == Double.class) {
                        return NumericValueToDouble.INSTANCE;
                    }
                    if (clazz == Float.TYPE || clazz == Float.class) {
                        return NumericValueToFloat.INSTANCE;
                    }
                    if (clazz == BigDecimal.class) {
                        return NumericValueToBigDecimal.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(IntegerValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.DECIMAL)) {
                    if (clazz == Object.class || clazz == BigDecimal.class) {
                        return NumericValueToBigDecimal.INSTANCE;
                    }
                    if (clazz == Double.TYPE || clazz == Double.class) {
                        return NumericValueToDouble.INSTANCE;
                    }
                    if (clazz == Float.TYPE || clazz == Float.class) {
                        return NumericValueToFloat.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(DecimalValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.FLOAT)) {
                    if (clazz == Object.class || clazz == Float.class || clazz == Float.TYPE) {
                        return NumericValueToFloat.INSTANCE;
                    }
                    if (clazz == Double.TYPE || clazz == Double.class) {
                        return NumericValueToDouble.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(FloatValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.DOUBLE)) {
                    if (clazz == Object.class || clazz == Double.class || clazz == Double.TYPE) {
                        return NumericValueToDouble.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(DoubleValue.class)) {
                        return Identity.INSTANCE;
                    }
                    return Atomic.INSTANCE;
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.ANY_URI)) {
                    if (clazz == Object.class || URI.class.isAssignableFrom(clazz)) {
                        return AnyURIValueToURI.INSTANCE;
                    }
                    if (URL.class.isAssignableFrom(clazz)) {
                        return AnyURIValueToURL.INSTANCE;
                    }
                    if (clazz == String.class || clazz == CharSequence.class) {
                        return StringValueToString.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(AnyURIValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.QNAME)) {
                    if (clazz == Object.class || clazz.getName().equals("javax.xml.namespace.QName")) {
                        return QualifiedNameValueToQName.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(QNameValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.NOTATION)) {
                    if (clazz == Object.class || clazz.getName().equals("javax.xml.namespace.QName")) {
                        return QualifiedNameValueToQName.INSTANCE;
                    }
                    if (clazz.isAssignableFrom(NotationValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.DURATION)) {
                    if (clazz.isAssignableFrom(DurationValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.DATE_TIME)) {
                    if (clazz.isAssignableFrom(DateTimeValue.class)) {
                        return Identity.INSTANCE;
                    }
                    if (clazz == Date.class) {
                        return CalendarValueToDate.INSTANCE;
                    }
                    if (clazz == Calendar.class) {
                        return CalendarValueToCalendar.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.DATE)) {
                    if (clazz.isAssignableFrom(DateValue.class)) {
                        return Identity.INSTANCE;
                    }
                    if (clazz == Date.class) {
                        return CalendarValueToDate.INSTANCE;
                    }
                    if (clazz == Calendar.class) {
                        return CalendarValueToCalendar.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.TIME)) {
                    if (clazz.isAssignableFrom(TimeValue.class)) {
                        return Identity.INSTANCE;
                    }
                    if (clazz == Date.class) {
                        return CalendarValueToDate.INSTANCE;
                    }
                    if (clazz == Calendar.class) {
                        return CalendarValueToCalendar.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.G_YEAR)) {
                    if (clazz.isAssignableFrom(GYearValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.G_YEAR_MONTH)) {
                    if (clazz.isAssignableFrom(GYearMonthValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.G_MONTH)) {
                    if (clazz.isAssignableFrom(GMonthValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.G_MONTH_DAY)) {
                    if (clazz.isAssignableFrom(GMonthDayValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.G_DAY)) {
                    if (clazz.isAssignableFrom(GDayValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.BASE64_BINARY)) {
                    if (clazz.isAssignableFrom(Base64BinaryValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (typeHierarchy.isSubType(itemType, BuiltInAtomicType.HEX_BINARY)) {
                    if (clazz.isAssignableFrom(HexBinaryValue.class)) {
                        return Identity.INSTANCE;
                    }
                    throw PJConverter.cannotConvert(itemType, clazz, configuration);
                }
                if (itemType instanceof ExternalObjectType) {
                    return UnwrapExternalObject.INSTANCE;
                }
                return Atomic.INSTANCE;
            }
            if (itemType instanceof EmptySequenceTest) {
                return ToNull.INSTANCE;
            }
            if (itemType instanceof NodeTest) {
                if (NodeInfo.class.isAssignableFrom(clazz)) {
                    return Identity.INSTANCE;
                }
                return General.INSTANCE;
            }
            return General.INSTANCE;
        }
        return General.INSTANCE;
    }

    private static XPathException cannotConvert(ItemType itemType, Class clazz, Configuration configuration) {
        return new XPathException("Cannot convert from " + itemType.toString(configuration.getNamePool()) + " to " + clazz.getName());
    }

    public static PJConverter allocateNodeListCreator(Configuration configuration, Object object) {
        List list = configuration.getExternalObjectModels();
        for (int i = 0; i < list.size(); ++i) {
            ExternalObjectModel externalObjectModel = (ExternalObjectModel)list.get(i);
            PJConverter pJConverter = externalObjectModel.getNodeListCreator(object);
            if (pJConverter == null) continue;
            return pJConverter;
        }
        return ToCollection.INSTANCE;
    }

    static {
        jpmap.put(Boolean.TYPE, SequenceType.SINGLE_BOOLEAN);
        jpmap.put(Boolean.class, SequenceType.OPTIONAL_BOOLEAN);
        jpmap.put(String.class, SequenceType.OPTIONAL_STRING);
        jpmap.put(CharSequence.class, SequenceType.OPTIONAL_STRING);
        jpmap.put(Long.TYPE, SequenceType.SINGLE_INTEGER);
        jpmap.put(Long.class, SequenceType.OPTIONAL_INTEGER);
        jpmap.put(Integer.TYPE, SequenceType.SINGLE_INTEGER);
        jpmap.put(Integer.class, SequenceType.OPTIONAL_INTEGER);
        jpmap.put(Short.TYPE, SequenceType.SINGLE_SHORT);
        jpmap.put(Short.class, SequenceType.OPTIONAL_SHORT);
        jpmap.put(Byte.TYPE, SequenceType.SINGLE_BYTE);
        jpmap.put(Byte.class, SequenceType.OPTIONAL_BYTE);
        jpmap.put(Float.TYPE, SequenceType.SINGLE_FLOAT);
        jpmap.put(Float.class, SequenceType.OPTIONAL_FLOAT);
        jpmap.put(Double.TYPE, SequenceType.SINGLE_DOUBLE);
        jpmap.put(Double.class, SequenceType.OPTIONAL_DOUBLE);
        jpmap.put(URI.class, SequenceType.OPTIONAL_ANY_URI);
        jpmap.put(URL.class, SequenceType.OPTIONAL_ANY_URI);
        jpmap.put(BigInteger.class, SequenceType.OPTIONAL_INTEGER);
        jpmap.put(BigDecimal.class, SequenceType.OPTIONAL_DECIMAL);
    }

    public static class General
    extends PJConverter {
        public static General INSTANCE = new General();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            Value value = Value.asValue(valueRepresentation).reduce();
            Configuration configuration = xPathContext.getConfiguration();
            PJConverter pJConverter = General.allocate(configuration, value.getItemType(configuration.getTypeHierarchy()), value.getCardinality(), clazz);
            if (pJConverter instanceof General) {
                pJConverter = Identity.INSTANCE;
            }
            return pJConverter.convert(value, clazz, xPathContext);
        }
    }

    public static class Atomic
    extends PJConverter {
        public static Atomic INSTANCE = new Atomic();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)Value.asValue(valueRepresentation);
            if (atomicValue == null) {
                return null;
            }
            Configuration configuration = xPathContext.getConfiguration();
            PJConverter pJConverter = Atomic.allocate(configuration, atomicValue.getItemType(configuration.getTypeHierarchy()), 16384, clazz);
            return pJConverter.convert(atomicValue, clazz, xPathContext);
        }
    }

    public static class CalendarValueToCalendar
    extends PJConverter {
        public static CalendarValueToCalendar INSTANCE = new CalendarValueToCalendar();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            return ((CalendarValue)valueRepresentation).getCalendar();
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return codeGeneratorService.cast(string, CalendarValue.class) + ".getCalendar()";
        }
    }

    public static class CalendarValueToDate
    extends PJConverter {
        public static CalendarValueToDate INSTANCE = new CalendarValueToDate();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            return ((CalendarValue)valueRepresentation).getCalendar().getTime();
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return codeGeneratorService.cast(string, CalendarValue.class) + ".getCalendar().getTime()";
        }
    }

    public static class QualifiedNameValueToQName
    extends PJConverter {
        public static QualifiedNameValueToQName INSTANCE = new QualifiedNameValueToQName();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            return ((QualifiedNameValue)valueRepresentation).makeQName(xPathContext.getConfiguration());
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return codeGeneratorService.cast(string, QualifiedNameValue.class) + ".makeQName(config)";
        }
    }

    public static class AnyURIValueToURL
    extends PJConverter {
        public static AnyURIValueToURL INSTANCE = new AnyURIValueToURL();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            try {
                return new URL(valueRepresentation.getStringValue());
            }
            catch (MalformedURLException malformedURLException) {
                throw new XPathException("The anyURI value '" + valueRepresentation + "' is not an acceptable Java URL");
            }
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return "new java.net.URL(" + string + ".getStringValue())";
        }
    }

    public static class AnyURIValueToURI
    extends PJConverter {
        public static AnyURIValueToURI INSTANCE = new AnyURIValueToURI();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            try {
                return new URI(valueRepresentation.getStringValue());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new XPathException("The anyURI value '" + valueRepresentation + "' is not an acceptable Java URI");
            }
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return "new java.net.URI(" + string + ")";
        }
    }

    public static class NumericValueToFloat
    extends PJConverter {
        public static NumericValueToFloat INSTANCE = new NumericValueToFloat();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) {
            return new Float(((NumericValue)valueRepresentation).getFloatValue());
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return codeGeneratorService.cast(string, NumericValue.class) + ".getFloatValue()";
        }
    }

    public static class NumericValueToDouble
    extends PJConverter {
        public static NumericValueToDouble INSTANCE = new NumericValueToDouble();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) {
            return new Double(((NumericValue)valueRepresentation).getDoubleValue());
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return codeGeneratorService.cast(string, NumericValue.class) + ".getDoubleValue()";
        }
    }

    public static class NumericValueToBigDecimal
    extends PJConverter {
        public static NumericValueToBigDecimal INSTANCE = new NumericValueToBigDecimal();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            return ((NumericValue)valueRepresentation).getDecimalValue();
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return codeGeneratorService.cast(string, NumericValue.class) + ".getDecimalValue()";
        }
    }

    public static class IntegerValueToChar
    extends PJConverter {
        public static IntegerValueToChar INSTANCE = new IntegerValueToChar();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            return new Character((char)((IntegerValue)valueRepresentation).longValue());
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return "(char)" + codeGeneratorService.cast(string, IntegerValue.class) + ".longValue()";
        }
    }

    public static class IntegerValueToByte
    extends PJConverter {
        public static IntegerValueToByte INSTANCE = new IntegerValueToByte();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            return new Byte((byte)((IntegerValue)valueRepresentation).longValue());
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return "(byte)" + codeGeneratorService.cast(string, IntegerValue.class) + ".longValue()";
        }
    }

    public static class IntegerValueToShort
    extends PJConverter {
        public static IntegerValueToShort INSTANCE = new IntegerValueToShort();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            return new Short((short)((IntegerValue)valueRepresentation).longValue());
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return "(short)" + codeGeneratorService.cast(string, IntegerValue.class) + ".longValue()";
        }
    }

    public static class IntegerValueToInt
    extends PJConverter {
        public static IntegerValueToInt INSTANCE = new IntegerValueToInt();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            return new Integer((int)((IntegerValue)valueRepresentation).longValue());
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return "(int)" + codeGeneratorService.cast(string, IntegerValue.class) + ".longValue()";
        }
    }

    public static class IntegerValueToLong
    extends PJConverter {
        public static IntegerValueToLong INSTANCE = new IntegerValueToLong();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            return new Long(((IntegerValue)valueRepresentation).longValue());
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return codeGeneratorService.cast(string, IntegerValue.class) + ".longValue()";
        }
    }

    public static class IntegerValueToBigInteger
    extends PJConverter {
        public static IntegerValueToBigInteger INSTANCE = new IntegerValueToBigInteger();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            return ((IntegerValue)valueRepresentation).asBigInteger();
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return codeGeneratorService.cast(string, IntegerValue.class) + ".asBigInteger()";
        }
    }

    public static class BooleanValueToBoolean
    extends PJConverter {
        public static BooleanValueToBoolean INSTANCE = new BooleanValueToBoolean();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            return ((BooleanValue)valueRepresentation).getBooleanValue();
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return codeGeneratorService.cast(string, BooleanValue.class) + ".getBooleanValue()";
        }
    }

    public static class StringValueToChar
    extends PJConverter {
        public static StringValueToChar INSTANCE = new StringValueToChar();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            String string = valueRepresentation.getStringValue();
            if (string.length() == 1) {
                return new Character(string.charAt(0));
            }
            XPathException xPathException = new XPathException("Cannot convert xs:string to Java char unless length is 1");
            xPathException.setXPathContext(xPathContext);
            xPathException.setErrorCode("SXJE0005");
            throw xPathException;
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return codeGeneratorService.cast(string, StringValue.class) + ".getStringValue().charAt(0)";
        }
    }

    public static class StringValueToString
    extends PJConverter {
        public static StringValueToString INSTANCE = new StringValueToString();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            return valueRepresentation.getStringValue();
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return codeGeneratorService.cast(string, StringValue.class) + ".getStringValue()";
        }
    }

    public static class UnwrapExternalObject
    extends PJConverter {
        public static UnwrapExternalObject INSTANCE = new UnwrapExternalObject();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            Value value = Value.asValue(valueRepresentation).reduce();
            if (!(value instanceof ObjectValue)) {
                throw new XPathException("Expected external object of class " + clazz + ", got " + value.getClass());
            }
            Object object = ((ObjectValue)value).getObject();
            if (!clazz.isAssignableFrom(object.getClass())) {
                throw new XPathException("External object has wrong class (is " + object.getClass() + ", expected " + clazz);
            }
            return object;
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return "(" + clazz.getName() + ")" + codeGeneratorService.cast(string, ObjectValue.class) + ".getObject()";
        }
    }

    public static class Identity
    extends PJConverter {
        public static Identity INSTANCE = new Identity();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            Object object;
            if (valueRepresentation instanceof SingletonNode) {
                valueRepresentation = ((SingletonNode)valueRepresentation).getNode();
            }
            if (valueRepresentation instanceof VirtualNode && clazz.isAssignableFrom((object = ((VirtualNode)valueRepresentation).getUnderlyingNode()).getClass())) {
                return object;
            }
            if (clazz.isAssignableFrom(valueRepresentation.getClass())) {
                return valueRepresentation;
            }
            object = Value.asValue(valueRepresentation).reduce();
            if (object instanceof SingletonNode) {
                object = ((SingletonNode)object).getNode();
            }
            if (clazz.isAssignableFrom(object.getClass())) {
                return object;
            }
            if (object instanceof EmptySequence) {
                return null;
            }
            throw new XPathException("Cannot convert value " + object.getClass() + " of type " + Value.asValue(valueRepresentation).getItemType(xPathContext.getConfiguration().getTypeHierarchy()) + " to class " + clazz.getName());
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return "(" + clazz.getName() + ")" + string;
        }
    }

    public static class ToArray
    extends PJConverter {
        private PJConverter itemConverter;

        public ToArray(PJConverter pJConverter) {
            this.itemConverter = pJConverter;
        }

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            Object object;
            Class<?> clazz2 = clazz.getComponentType();
            ArrayList<Object> arrayList = new ArrayList<Object>(20);
            SequenceIterator sequenceIterator = Value.asIterator(valueRepresentation);
            while ((object = sequenceIterator.next()) != null) {
                Object object2 = this.itemConverter.convert((ValueRepresentation)object, clazz2, xPathContext);
                if (object2 == null) continue;
                arrayList.add(object2);
            }
            object = Array.newInstance(clazz2, arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                Array.set(object, i, arrayList.get(i));
            }
            return object;
        }
    }

    public static class ToCollection
    extends PJConverter {
        public static ToCollection INSTANCE = new ToCollection();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            Collection<Object> collection;
            if (clazz.isAssignableFrom(ArrayList.class)) {
                collection = new ArrayList(100);
            } else {
                try {
                    collection = (Collection)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    XPathException xPathException = new XPathException("Cannot instantiate collection class " + clazz);
                    xPathException.setXPathContext(xPathContext);
                    throw xPathException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    XPathException xPathException = new XPathException("Cannot access collection class " + clazz);
                    xPathException.setXPathContext(xPathContext);
                    throw xPathException;
                }
            }
            Configuration configuration = xPathContext.getConfiguration();
            TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
            SequenceIterator sequenceIterator = Value.asIterator(valueRepresentation);
            Item item;
            while ((item = sequenceIterator.next()) != null) {
                if (item instanceof AtomicValue) {
                    PJConverter pJConverter = ToCollection.allocate(configuration, ((AtomicValue)item).getItemType(typeHierarchy), 16384, Object.class);
                    collection.add(pJConverter.convert(item, Object.class, xPathContext));
                    continue;
                }
                if (item instanceof VirtualNode) {
                    collection.add(((VirtualNode)item).getUnderlyingNode());
                    continue;
                }
                collection.add(item);
            }
            return collection;
        }
    }

    public static class ToSequenceExtent
    extends PJConverter {
        public static ToSequenceExtent INSTANCE = new ToSequenceExtent();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            return SequenceExtent.makeSequenceExtent(Value.asIterator(valueRepresentation));
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return "SequenceExtent.makeSequenceExtent(Value.asIterator(" + string + "))";
        }
    }

    public static class ToNull
    extends PJConverter {
        public static ToNull INSTANCE = new ToNull();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            return null;
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return "null";
        }
    }

    public static class ToSequenceIterator
    extends PJConverter {
        public static ToSequenceIterator INSTANCE = new ToSequenceIterator();

        public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
            return Value.asIterator(valueRepresentation);
        }

        public String compile(String string, Class clazz, CodeGeneratorService codeGeneratorService) {
            return "Value.asIterator(" + string + ")";
        }
    }
}

