/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Closure;

public class ParameterSet {
    private int[] keys;
    private ValueRepresentation[] values;
    private int used = 0;
    public static ParameterSet EMPTY_PARAMETER_SET = new ParameterSet(0);

    public ParameterSet() {
        this(10);
    }

    public ParameterSet(int capacity) {
        this.keys = new int[capacity];
        this.values = new ValueRepresentation[capacity];
    }

    public ParameterSet(ParameterSet existing, int extra) {
        this(existing.used + extra);
        for (int i = 0; i < existing.used; ++i) {
            this.put(existing.keys[i], existing.values[i]);
        }
    }

    public void put(int id, ValueRepresentation value) {
        for (int i = 0; i < this.used; ++i) {
            if (this.keys[i] != id) continue;
            this.values[i] = value;
            return;
        }
        if (this.used + 1 > this.keys.length) {
            int newlength = this.used <= 5 ? 10 : this.used * 2;
            int[] newkeys = new int[newlength];
            ValueRepresentation[] newvalues = new ValueRepresentation[newlength];
            System.arraycopy(this.values, 0, newvalues, 0, this.used);
            System.arraycopy(this.keys, 0, newkeys, 0, this.used);
            this.values = newvalues;
            this.keys = newkeys;
        }
        this.keys[this.used] = id;
        this.values[this.used++] = value;
    }

    public ValueRepresentation get(int id) {
        for (int i = 0; i < this.used; ++i) {
            if (this.keys[i] != id) continue;
            return this.values[i];
        }
        return null;
    }

    public void clear() {
        this.used = 0;
    }

    public void materializeValues() throws XPathException {
        for (int i = 0; i < this.used; ++i) {
            if (!(this.values[i] instanceof Closure)) continue;
            this.values[i] = ((Closure)this.values[i]).reduce();
        }
    }
}

