/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLKey
extends StyleElement
implements StylesheetProcedure {
    private Pattern match;
    private Expression use;
    private String collationName;
    private StructuredQName keyName;
    SlotManager stackFrameMap;

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public void prepareAttributes() throws XPathException {
        String nameAtt = null;
        String matchAtt = null;
        String useAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("name")) {
                nameAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("use")) {
                useAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("match")) {
                matchAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("collation")) {
                this.collationName = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (nameAtt == null) {
            this.reportAbsence("name");
            return;
        }
        try {
            this.keyName = this.makeQName(nameAtt);
            this.setObjectName(this.keyName);
        }
        catch (NamespaceException err) {
            this.compileError(err.getMessage(), "XTSE0280");
        }
        catch (XPathException err) {
            this.compileError(err);
        }
        if (matchAtt == null) {
            this.reportAbsence("match");
            matchAtt = "*";
        }
        this.match = this.makePattern(matchAtt);
        if (useAtt != null) {
            this.use = this.makeExpression(useAtt);
        }
    }

    public StructuredQName getKeyName() {
        try {
            String nameAtt;
            if (this.getObjectName() == null && (nameAtt = this.getAttributeValue("name")) != null) {
                this.setObjectName(this.makeQName(nameAtt));
            }
            return this.getObjectName();
        }
        catch (NamespaceException err) {
            return null;
        }
        catch (XPathException err) {
            return null;
        }
    }

    public void validate() throws XPathException {
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        this.checkTopLevel(null);
        if (this.use != null) {
            if (this.hasChildNodes()) {
                this.compileError("An xsl:key element with a @use attribute must be empty", "XTSE1205");
            }
            try {
                RoleLocator role = new RoleLocator(4, (Serializable)((Object)"xsl:key/use"), 0);
                this.use = TypeChecker.staticTypeCheck(this.use, SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, 57344), false, role, this.makeExpressionVisitor());
            }
            catch (XPathException err) {
                this.compileError(err);
            }
        } else if (!this.hasChildNodes()) {
            this.compileError("An xsl:key element must either have a @use attribute or have content", "XTSE1205");
        }
        this.use = this.typeCheck("use", this.use);
        this.match = this.typeCheck("match", this.match);
        if (this.use != null) {
            this.use = this.makeExpressionVisitor().typeCheck(this.use, this.match.getNodeTest());
        }
        if (this.collationName != null) {
            try {
                URI collationURI = new URI(this.collationName);
                if (!collationURI.isAbsolute()) {
                    URI base = new URI(this.getBaseURI());
                    collationURI = base.resolve(collationURI);
                    this.collationName = collationURI.toString();
                }
            }
            catch (URISyntaxException err) {
                this.compileError("Collation name '" + this.collationName + "' is not a valid URI");
            }
        } else {
            this.collationName = this.getDefaultCollationName();
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        StaticContext env = this.getStaticContext();
        Configuration config = env.getConfiguration();
        StringCollator collator = null;
        if (this.collationName != null) {
            collator = this.getPrincipalStylesheet().findCollation(this.collationName);
            if (collator == null) {
                this.compileError("The collation name " + Err.wrap(this.collationName, 7) + " is not recognized", "XTSE1210");
                collator = CodepointCollator.getInstance();
            }
            if (collator instanceof CodepointCollator) {
                collator = null;
                this.collationName = null;
            } else if (!Configuration.getPlatform().canReturnCollationKeys(collator)) {
                this.compileError("The collation used for xsl:key must be capable of generating collation keys", "XTSE1210");
            }
        }
        if (this.use == null) {
            Expression body = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
            try {
                this.use = new Atomizer(this.makeExpressionVisitor().simplify(body), config);
            }
            catch (XPathException e) {
                this.compileError(e);
            }
            try {
                RoleLocator role = new RoleLocator(4, (Serializable)((Object)"xsl:key/use"), 0);
                this.use = TypeChecker.staticTypeCheck(this.use, SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, 57344), false, role, this.makeExpressionVisitor());
                this.use = this.makeExpressionVisitor().typeCheck(this.use, this.match.getNodeTest());
            }
            catch (XPathException err) {
                this.compileError(err);
            }
        }
        TypeHierarchy th = config.getTypeHierarchy();
        BuiltInAtomicType useType = (BuiltInAtomicType)this.use.getItemType(th).getPrimitiveItemType();
        if (this.backwardsCompatibleModeIsEnabled() && !useType.equals(BuiltInAtomicType.STRING) && !useType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            this.use = new AtomicSequenceConverter(this.use, BuiltInAtomicType.STRING);
            useType = BuiltInAtomicType.STRING;
        }
        this.allocateSlots(this.use);
        this.allocatePatternSlots(this.match, this.stackFrameMap);
        KeyManager km = this.getPrincipalStylesheet().getKeyManager();
        KeyDefinition keydef = new KeyDefinition(this.match, this.use, this.collationName, collator);
        keydef.setIndexedItemType(useType);
        keydef.setStackFrameMap(this.stackFrameMap);
        keydef.setLocation(this.getSystemId(), this.getLineNumber());
        keydef.setExecutable(this.getExecutable());
        keydef.setBackwardsCompatible(this.backwardsCompatibleModeIsEnabled());
        try {
            km.addKeyDefinition(this.keyName, keydef, exec.getConfiguration());
        }
        catch (XPathException err) {
            this.compileError(err);
        }
        return null;
    }
}

