/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.XPathException;

public class DynamicError
extends XPathException {
    transient XPathContext context;

    public DynamicError(String message) {
        super(message);
    }

    public DynamicError(Throwable err) {
        super(err);
    }

    public DynamicError(String message, Throwable err) {
        super(message, err);
    }

    public DynamicError(String message, SourceLocator loc) {
        super(message, loc);
    }

    public DynamicError(String message, SourceLocator loc, Throwable err) {
        super(message, loc, err);
    }

    public DynamicError(String message, String errorCode) {
        super(message);
        this.setErrorCode(errorCode);
    }

    public DynamicError(String message, String errorCode, XPathContext context) {
        super(message);
        this.setErrorCode(errorCode);
        this.setXPathContext(context);
    }

    public void setXPathContext(XPathContext context) {
        this.context = context;
    }

    public XPathContext getXPathContext() {
        return this.context;
    }

    public static DynamicError makeDynamicError(TransformerException err) {
        if (err instanceof DynamicError) {
            return (DynamicError)err;
        }
        if (err instanceof XPathException) {
            DynamicError de = new DynamicError(err);
            de.setErrorCode(((XPathException)err).getErrorCodeLocalPart());
            de.setLocator(err.getLocator());
            return de;
        }
        return new DynamicError(err);
    }

    public void maybeSetLocation(SourceLocator locator, XPathContext context) {
        if ((this.getLocator() == null || this.getLocator().getLineNumber() == -1) && locator != null) {
            this.setLocator(locator);
        }
        if (this.getXPathContext() == null && context != null) {
            this.setXPathContext(context);
        }
    }
}

