/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.xquery.XQDataFactory;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQSequence;
import javax.xml.xquery.XQSequenceType;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMObjectModel;
import net.sf.saxon.evpull.PullEventSource;
import net.sf.saxon.evpull.StaxToEventBridge;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.IntToIntHashMap;
import net.sf.saxon.sort.IntToIntMap;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xqj.Closable;
import net.sf.saxon.xqj.ObjectConverter;
import net.sf.saxon.xqj.SaxonXQDataSource;
import net.sf.saxon.xqj.SaxonXQForwardSequence;
import net.sf.saxon.xqj.SaxonXQItem;
import net.sf.saxon.xqj.SaxonXQItemType;
import net.sf.saxon.xqj.SaxonXQSequence;
import net.sf.saxon.xqj.SaxonXQSequenceType;
import net.sf.saxon.xqj.StandardObjectConverter;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public abstract class SaxonXQDataFactory
extends Closable
implements XQDataFactory {
    private ObjectConverter objectConverter;
    private static IntToIntMap XQJtoSaxonTypeTranslation = new IntToIntHashMap(80);
    private static IntToIntMap saxonToXQJTypeTranslation = new IntToIntHashMap(80);

    abstract Configuration getConfiguration();

    private static void map(int x, int y) {
        XQJtoSaxonTypeTranslation.put(x, y);
        saxonToXQJTypeTranslation.put(y, x);
    }

    static int mapSaxonTypeToXQJ(int type) {
        return saxonToXQJTypeTranslation.get(type);
    }

    protected void init() {
        this.objectConverter = new StandardObjectConverter(this);
    }

    public void setObjectConverter(ObjectConverter converter) {
        this.objectConverter = converter;
    }

    public ObjectConverter getObjectConverter() {
        return this.objectConverter;
    }

    public XQItemType createAtomicType(int baseType) throws XQException {
        this.checkNotClosed();
        int saxonType = XQJtoSaxonTypeTranslation.get(baseType);
        if (saxonType == XQJtoSaxonTypeTranslation.getDefaultValue()) {
            throw new XQException("Unknown base type " + baseType);
        }
        SchemaType st = BuiltInType.getSchemaType(saxonType);
        if (st instanceof AtomicType) {
            return new SaxonXQItemType((AtomicType)st, this.getConfiguration());
        }
        throw new XQException("baseType " + baseType + " is not atomic");
    }

    public XQItemType createAtomicType(int baseType, QName typename, URI schemaURI) throws XQException {
        this.checkNotClosed();
        if (typename == null) {
            return this.createAtomicType(baseType);
        }
        SchemaType st = this.getConfiguration().getSchemaType(this.getFingerprint(typename));
        if (st == null) {
            this.loadSchema(schemaURI);
            st = this.getConfiguration().getSchemaType(this.getFingerprint(typename));
        }
        if (st == null) {
            throw new XQException("Type " + typename + " not found in schema");
        }
        if (st instanceof AtomicType) {
            return new SaxonXQItemType((AtomicType)st, this.getConfiguration());
        }
        throw new XQException("Type " + typename + " is not atomic");
    }

    public XQItemType createAttributeType(QName nodename, int basetype) throws XQException {
        this.checkNotClosed();
        Configuration config = this.getConfiguration();
        int saxonType = XQJtoSaxonTypeTranslation.get(basetype);
        if (saxonType == XQJtoSaxonTypeTranslation.getDefaultValue()) {
            throw new XQException("Unknown base type " + basetype);
        }
        SchemaType st = BuiltInType.getSchemaType(saxonType);
        if (!st.isSimpleType()) {
            throw new XQException("baseType " + basetype + " is not a simple type");
        }
        ContentTypeTest contentTest = new ContentTypeTest(2, st, config);
        if (nodename == null) {
            return new SaxonXQItemType(contentTest, config);
        }
        NameTest nameTest = new NameTest(2, nodename.getNamespaceURI(), nodename.getLocalPart(), config.getNamePool());
        CombinedNodeTest combined = new CombinedNodeTest(nameTest, 23, contentTest);
        return new SaxonXQItemType(combined, config);
    }

    public XQItemType createAttributeType(QName nodename, int basetype, QName typename, URI schemaURI) throws XQException {
        this.checkNotClosed();
        if (typename == null) {
            return this.createAttributeType(nodename, basetype);
        }
        Configuration config = this.getConfiguration();
        SchemaType st = BuiltInType.getSchemaType(this.getFingerprint(typename));
        if (st == null) {
            this.loadSchema(schemaURI);
            st = this.getConfiguration().getSchemaType(this.getFingerprint(typename));
        }
        if (st == null) {
            throw new XQException("Type " + typename + " not found in schema");
        }
        if (!st.isSimpleType()) {
            throw new XQException("Type " + typename + " is not a simple type");
        }
        ContentTypeTest contentTest = new ContentTypeTest(2, st, config);
        if (nodename == null) {
            return new SaxonXQItemType(contentTest, config);
        }
        NameTest nameTest = new NameTest(2, nodename.getNamespaceURI(), nodename.getLocalPart(), config.getNamePool());
        CombinedNodeTest combined = new CombinedNodeTest(nameTest, 23, contentTest);
        return new SaxonXQItemType(combined, config);
    }

    public XQItemType createCommentType() throws XQException {
        this.checkNotClosed();
        return new SaxonXQItemType(NodeKindTest.COMMENT, this.getConfiguration());
    }

    public XQItemType createDocumentElementType(XQItemType elementType) throws XQException {
        this.checkNotClosed();
        SaxonXQDataSource.checkNotNull(elementType, "elementType");
        ItemType itemType = ((SaxonXQItemType)elementType).getSaxonItemType();
        if (itemType instanceof NodeTest && (((NodeTest)itemType).getNodeKindMask() & 2) != 0) {
            return new SaxonXQItemType(new DocumentNodeTest((NodeTest)itemType), this.getConfiguration());
        }
        throw new XQException("elementType is of wrong kind");
    }

    public XQItemType createDocumentSchemaElementType(XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDataSource.checkNotNull(type, "type");
        ItemType itemType = ((SaxonXQItemType)type).getSaxonItemType();
        if (itemType instanceof NodeTest && (((NodeTest)itemType).getNodeKindMask() & 2) != 0) {
            return new SaxonXQItemType(new DocumentNodeTest((NodeTest)itemType), this.getConfiguration());
        }
        throw new XQException("elementType is of wrong kind");
    }

    public XQItemType createDocumentType() throws XQException {
        this.checkNotClosed();
        return new SaxonXQItemType(NodeKindTest.DOCUMENT, this.getConfiguration());
    }

    public XQItemType createElementType(QName nodename, int basetype) throws XQException {
        this.checkNotClosed();
        Configuration config = this.getConfiguration();
        if (basetype == 2) {
            if (nodename == null) {
                return new SaxonXQItemType(NodeKindTest.ELEMENT, config);
            }
            return new SaxonXQItemType(new NameTest(1, this.getFingerprint(nodename), config.getNamePool()), config);
        }
        int saxonType = XQJtoSaxonTypeTranslation.get(basetype);
        if (saxonType == XQJtoSaxonTypeTranslation.getDefaultValue()) {
            throw new XQException("Unknown base type " + basetype);
        }
        SchemaType st = BuiltInType.getSchemaType(saxonType);
        ContentTypeTest contentTest = new ContentTypeTest(1, st, config);
        if (nodename == null) {
            return new SaxonXQItemType(contentTest, config);
        }
        NameTest nameTest = new NameTest(1, nodename.getNamespaceURI(), nodename.getLocalPart(), config.getNamePool());
        CombinedNodeTest combined = new CombinedNodeTest(nameTest, 23, contentTest);
        return new SaxonXQItemType(combined, config);
    }

    public XQItemType createElementType(QName nodename, int basetype, QName typename, URI schemaURI, boolean allowNill) throws XQException {
        this.checkNotClosed();
        if (typename == null) {
            return this.createElementType(nodename, basetype);
        }
        Configuration config = this.getConfiguration();
        SchemaType st = BuiltInType.getSchemaType(this.getFingerprint(typename));
        if (st == null) {
            this.loadSchema(schemaURI);
            st = this.getConfiguration().getSchemaType(this.getFingerprint(typename));
        }
        if (st == null) {
            throw new XQException("Type " + typename + " not found in schema");
        }
        ContentTypeTest contentTest = new ContentTypeTest(1, st, config);
        contentTest.setNillable(allowNill);
        if (nodename == null) {
            return new SaxonXQItemType(contentTest, config);
        }
        NameTest nameTest = new NameTest(1, nodename.getNamespaceURI(), nodename.getLocalPart(), config.getNamePool());
        CombinedNodeTest combined = new CombinedNodeTest(nameTest, 23, contentTest);
        return new SaxonXQItemType(combined, config);
    }

    public XQItem createItem(XQItem item) throws XQException {
        this.checkNotClosed();
        SaxonXQDataSource.checkNotNull(item, "item");
        return new SaxonXQItem(((SaxonXQItem)item).getSaxonItem(), this);
    }

    public XQItem createItemFromAtomicValue(String value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDataSource.checkNotNull(value, "value");
        SaxonXQDataSource.checkNotNull(type, "type");
        AtomicType at = this.testAtomic(type);
        StringValue sv = new StringValue(value);
        ConversionResult result = sv.convert(at, true, this.getConfiguration().getConversionContext());
        if (result instanceof ValidationFailure) {
            throw new XQException(((ValidationFailure)result).getMessage());
        }
        return new SaxonXQItem((AtomicValue)result, this);
    }

    public XQItem createItemFromBoolean(boolean value, XQItemType type) throws XQException {
        this.checkNotClosed();
        if (type == null) {
            return new SaxonXQItem(BooleanValue.get(value), this);
        }
        AtomicType at = this.testAtomic(type);
        if (at.getPrimitiveType() == 514) {
            try {
                ConversionResult result = BooleanValue.get(value).convert(at, true, this.getConfiguration().getConversionContext());
                if (result instanceof ValidationFailure) {
                    throw new XQException(((ValidationFailure)result).getMessage());
                }
                return new SaxonXQItem((AtomicValue)result, this);
            }
            catch (Exception e) {
                throw new XQException("Failed to convert boolean value to required type: " + e.getMessage());
            }
        }
        throw new XQException("Target type for a boolean must be xs:boolean or a subtype");
    }

    public XQItem createItemFromByte(byte value, XQItemType type) throws XQException {
        this.checkNotClosed();
        if (type == null) {
            try {
                return new SaxonXQItem(new Int64Value(value, BuiltInAtomicType.BYTE, false), this);
            }
            catch (XPathException de) {
                throw SaxonXQDataFactory.newXQException(de);
            }
        }
        return this.createItemFromLong(value, type);
    }

    public XQItem createItemFromDocument(InputStream value, String baseURI, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDataSource.checkNotNull(value, "value");
        try {
            Source ss = new SAXSource(new InputSource(value));
            ss.setSystemId(baseURI);
            ss = this.augmentSource(ss, type);
            DocumentInfo doc = this.getConfiguration().buildDocument(ss);
            this.checkDocumentType(doc, (SaxonXQItemType)type);
            return new SaxonXQItem(doc, this);
        }
        catch (XPathException de) {
            throw SaxonXQDataFactory.newXQException(de);
        }
    }

    public XQItem createItemFromDocument(Reader value, String baseURI, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDataSource.checkNotNull(value, "value");
        try {
            Source ss = new SAXSource(new InputSource(value));
            ss.setSystemId(baseURI);
            ss = this.augmentSource(ss, type);
            DocumentInfo doc = this.getConfiguration().buildDocument(ss);
            this.checkDocumentType(doc, (SaxonXQItemType)type);
            return new SaxonXQItem(doc, this);
        }
        catch (XPathException de) {
            throw SaxonXQDataFactory.newXQException(de);
        }
    }

    public XQItem createItemFromDocument(Source value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDataSource.checkNotNull(value, "value");
        try {
            Source ss = this.augmentSource(value, type);
            DocumentInfo doc = this.getConfiguration().buildDocument(ss);
            this.checkDocumentType(doc, (SaxonXQItemType)type);
            return new SaxonXQItem(doc, this);
        }
        catch (XPathException de) {
            throw SaxonXQDataFactory.newXQException(de);
        }
    }

    public XQItem createItemFromDocument(String value, String baseURI, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDataSource.checkNotNull(value, "value");
        try {
            Source ss = new SAXSource(new InputSource(new StringReader(value)));
            ss.setSystemId(baseURI);
            ss = this.augmentSource(ss, type);
            DocumentInfo doc = this.getConfiguration().buildDocument(ss);
            this.checkDocumentType(doc, (SaxonXQItemType)type);
            return new SaxonXQItem(doc, this);
        }
        catch (XPathException de) {
            throw SaxonXQDataFactory.newXQException(de);
        }
    }

    public XQItem createItemFromDocument(XMLReader value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDataSource.checkNotNull(value, "value");
        try {
            Source ss = new SAXSource(value, new InputSource("dummy"));
            ss = this.augmentSource(ss, type);
            AugmentedSource as = AugmentedSource.makeAugmentedSource(ss);
            as.setSourceIsXQJ(true);
            DocumentInfo doc = this.getConfiguration().buildDocument(as);
            this.checkDocumentType(doc, (SaxonXQItemType)type);
            return new SaxonXQItem(doc, this);
        }
        catch (XPathException de) {
            throw SaxonXQDataFactory.newXQException(de);
        }
    }

    public XQItem createItemFromDocument(XMLStreamReader value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDataSource.checkNotNull(value, "value");
        try {
            StaxToEventBridge bridge = new StaxToEventBridge();
            bridge.setXMLStreamReader(value);
            bridge.setPipelineConfiguration(this.getConfiguration().makePipelineConfiguration());
            Source ss = new PullEventSource(bridge);
            ss = this.augmentSource(ss, type);
            DocumentInfo doc = this.getConfiguration().buildDocument(ss);
            this.checkDocumentType(doc, (SaxonXQItemType)type);
            return new SaxonXQItem(doc, this);
        }
        catch (XPathException de) {
            throw SaxonXQDataFactory.newXQException(de);
        }
    }

    private Source augmentSource(Source in, XQItemType required) throws XQException {
        if (required == null) {
            return in;
        }
        int kind = required.getItemKind();
        switch (kind) {
            case 4: 
            case 8: 
            case 9: {
                return in;
            }
            case 5: {
                ItemType it = ((SaxonXQItemType)required).getSaxonItemType();
                it = ((DocumentNodeTest)it).getElementTest();
                SchemaType contentType = ((NodeTest)it).getContentType();
                int fp = contentType.getFingerprint();
                if (fp != 572 && fp != 630) break;
                return in;
            }
            case 6: {
                break;
            }
            default: {
                throw new XQException("Required item type for document node is incorrect");
            }
        }
        AugmentedSource out = AugmentedSource.makeAugmentedSource(in);
        out.setSchemaValidationMode(1);
        return out;
    }

    private void checkDocumentType(DocumentInfo doc, SaxonXQItemType required) throws XQException {
        this.checkNotClosed();
        if (required != null && !required.getSaxonItemType().matchesItem(doc, false, this.getConfiguration())) {
            throw new XQException("Document was successfully built but has the wrong type");
        }
    }

    public XQItem createItemFromDouble(double value, XQItemType type) throws XQException {
        this.checkNotClosed();
        if (type == null) {
            return new SaxonXQItem(new DoubleValue(value), this);
        }
        AtomicType at = this.testAtomic(type);
        if (at.getPrimitiveType() == 517) {
            try {
                ConversionResult result = new DoubleValue(value).convert(at, true, this.getConfiguration().getConversionContext());
                if (result instanceof ValidationFailure) {
                    throw new XQException(((ValidationFailure)result).getMessage());
                }
                return new SaxonXQItem((AtomicValue)result, this);
            }
            catch (Exception e) {
                throw new XQException("Failed to convert double value to required type: " + e.getMessage());
            }
        }
        throw new XQException("Target type for a double must be xs:double or a subtype");
    }

    public XQItem createItemFromFloat(float value, XQItemType type) throws XQException {
        this.checkNotClosed();
        if (type == null) {
            return new SaxonXQItem(new FloatValue(value), this);
        }
        AtomicType at = this.testAtomic(type);
        if (at.getPrimitiveType() == 516) {
            try {
                ConversionResult result = new FloatValue(value).convert(at, true, this.getConfiguration().getConversionContext());
                if (result instanceof ValidationFailure) {
                    throw new XQException(((ValidationFailure)result).getMessage());
                }
                return new SaxonXQItem((AtomicValue)result, this);
            }
            catch (Exception e) {
                throw new XQException("Failed to convert float value to required type: " + e.getMessage());
            }
        }
        throw new XQException("Target type for a float must be xs:float or a subtype");
    }

    public XQItem createItemFromInt(int value, XQItemType type) throws XQException {
        this.checkNotClosed();
        if (type == null) {
            try {
                return new SaxonXQItem(new Int64Value(value, BuiltInAtomicType.INT, false), this);
            }
            catch (XPathException de) {
                throw SaxonXQDataFactory.newXQException(de);
            }
        }
        return this.createItemFromLong(value, type);
    }

    public XQItem createItemFromLong(long value, XQItemType type) throws XQException {
        this.checkNotClosed();
        if (type == null) {
            try {
                return new SaxonXQItem(new Int64Value(value, BuiltInAtomicType.LONG, false), this);
            }
            catch (XPathException de) {
                throw SaxonXQDataFactory.newXQException(de);
            }
        }
        AtomicType at = this.testAtomic(type);
        int prim = at.getPrimitiveType();
        if (prim == 532 || prim == 515) {
            try {
                ConversionResult result = Int64Value.makeIntegerValue(value).convert(at, true, this.getConfiguration().getConversionContext());
                if (result instanceof ValidationFailure) {
                    throw new XQException(((ValidationFailure)result).getMessage());
                }
                return new SaxonXQItem((AtomicValue)result, this);
            }
            catch (Exception e) {
                throw new XQException("Failed to convert long|int|short|byte value to required type: " + e.getMessage());
            }
        }
        throw new XQException("Target type for a long|int|short|byte must be xs:decimal or a subtype");
    }

    public XQItem createItemFromNode(Node value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDataSource.checkNotNull(value, "value");
        try {
            JPConverter jp = DOMObjectModel.getInstance().getJPConverter(Node.class);
            NodeInfo n = (NodeInfo)jp.convert(value, new EarlyEvaluationContext(this.getConfiguration(), null));
            SaxonXQItem result = new SaxonXQItem(n, this);
            if (type != null && !result.instanceOf(type)) {
                throw new XQException("The node is not a valid instance of the required type");
            }
            return result;
        }
        catch (XPathException de) {
            throw SaxonXQDataFactory.newXQException(de);
        }
    }

    public XQItem createItemFromObject(Object value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDataSource.checkNotNull(value, "value");
        if (type == null) {
            return new SaxonXQItem(this.getObjectConverter().convertToItem(value), this);
        }
        return this.convertToXQItem(value, type);
    }

    public XQItem createItemFromString(String value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDataSource.checkNotNull(value, "value");
        if (type == null) {
            return new SaxonXQItem(new StringValue(value), this);
        }
        AtomicType at = this.testAtomic(type);
        int prim = at.getPrimitiveType();
        if (prim == 513) {
            try {
                ConversionResult result = new StringValue(value).convert(at, true, this.getConfiguration().getConversionContext());
                if (result instanceof ValidationFailure) {
                    throw new XQException(((ValidationFailure)result).getMessage());
                }
                return new SaxonXQItem((AtomicValue)result, this);
            }
            catch (Exception e) {
                throw new XQException("Failed to convert string value to required type: " + e.getMessage());
            }
        }
        throw new XQException("Target type for a string must be xs:string or a subtype");
    }

    public XQItemType createItemType() throws XQException {
        this.checkNotClosed();
        return new SaxonXQItemType(AnyItemType.getInstance(), this.getConfiguration());
    }

    private XQItem convertToXQItem(Object value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDataSource.checkNotNull(value, "value");
        if (value instanceof Boolean) {
            return this.createItemFromBoolean((Boolean)value, type);
        }
        if (value instanceof byte[]) {
            ConversionResult result;
            AtomicType at = this.testAtomic(type);
            int prim = at.getPrimitiveType();
            if (prim == 527) {
                result = new HexBinaryValue((byte[])value).convert(at, true, this.getConfiguration().getConversionContext());
            } else if (prim == 528) {
                result = new Base64BinaryValue((byte[])value).convert(at, true, this.getConfiguration().getConversionContext());
            } else {
                throw new XQException("Target type must be xs:hexBinary, xs:base64Binary, or a subtype");
            }
            if (result instanceof ValidationFailure) {
                throw new XQException(((ValidationFailure)result).getMessage());
            }
            return new SaxonXQItem((AtomicValue)result, this);
        }
        if (value instanceof Byte) {
            return this.createItemFromByte((Byte)value, type);
        }
        if (value instanceof Float) {
            return this.createItemFromFloat(((Float)value).floatValue(), type);
        }
        if (value instanceof Double) {
            return this.createItemFromDouble((Double)value, type);
        }
        if (value instanceof Integer) {
            return this.createItemFromInt((Integer)value, type);
        }
        if (value instanceof Long) {
            return this.createItemFromLong((Long)value, type);
        }
        if (value instanceof Short) {
            return this.createItemFromShort((Short)value, type);
        }
        if (value instanceof String) {
            ConversionResult result;
            AtomicType at = this.testAtomic(type);
            int prim = at.getPrimitiveType();
            if (prim == 631) {
                result = new UntypedAtomicValue((String)value);
            } else if (prim == 513) {
                result = new StringValue((String)value).convert(at, true, this.getConfiguration().getConversionContext());
            } else if (prim == 529) {
                result = new AnyURIValue((String)value).convert(at, true, this.getConfiguration().getConversionContext());
            } else {
                throw new XQException("Target type must be string, untypedAtomic, or anyURI");
            }
            if (result instanceof ValidationFailure) {
                throw new XQException(((ValidationFailure)result).getMessage());
            }
            return new SaxonXQItem((Item)((Object)result), this);
        }
        if (value instanceof BigDecimal) {
            AtomicType at = this.testAtomic(type);
            int prim = at.getPrimitiveType();
            if (prim == 515 || prim == 532) {
                ConversionResult result = new DecimalValue((BigDecimal)value).convert(at, true, this.getConfiguration().getConversionContext());
                if (result instanceof ValidationFailure) {
                    throw new XQException(((ValidationFailure)result).getMessage());
                }
                return new SaxonXQItem((AtomicValue)result, this);
            }
            throw new XQException("Target type must be xs:decimal or a subtype");
        }
        if (value instanceof BigInteger) {
            AtomicType at = this.testAtomic(type);
            int prim = at.getPrimitiveType();
            if (prim == 515 || prim == 532) {
                ConversionResult result = new DecimalValue(new BigDecimal((BigInteger)value)).convert(at, true, this.getConfiguration().getConversionContext());
                if (result instanceof ValidationFailure) {
                    throw new XQException(((ValidationFailure)result).getMessage());
                }
                return new SaxonXQItem((AtomicValue)result, this);
            }
            throw new XQException("Target type must be xs:decimal or a subtype");
        }
        if (value instanceof Duration) {
            AtomicType at = this.testAtomic(type);
            int prim = at.getPrimitiveType();
            if (prim == 518 || prim == 634 || prim == 633) {
                DurationValue dv = (DurationValue)this.getObjectConverter().convertToItem(value);
                ConversionResult result = dv.convert(at, true, this.getConfiguration().getConversionContext());
                if (result instanceof ValidationFailure) {
                    throw new XQException(((ValidationFailure)result).getMessage());
                }
                return new SaxonXQItem((AtomicValue)result, this);
            }
            throw new XQException("Target type must be xs:duration or a subtype");
        }
        if (value instanceof XMLGregorianCalendar) {
            AtomicType at = this.testAtomic(type);
            int prim = at.getPrimitiveType();
            switch (prim) {
                case 519: 
                case 520: 
                case 521: 
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: {
                    AtomicValue dv = (AtomicValue)this.getObjectConverter().convertToItem(value);
                    ConversionResult result = dv.convert(at, true, this.getConfiguration().getConversionContext());
                    if (result instanceof ValidationFailure) {
                        throw new XQException(((ValidationFailure)result).getMessage());
                    }
                    return new SaxonXQItem((AtomicValue)result, this);
                }
            }
            throw new XQException("Target type must be a date/time type");
        }
        if (value instanceof QName) {
            AtomicType at = this.testAtomic(type);
            int prim = at.getPrimitiveType();
            if (prim == 530) {
                QualifiedNameValue dv = (QualifiedNameValue)this.getObjectConverter().convertToItem(value);
                ConversionResult result = dv.convert(at, true, this.getConfiguration().getConversionContext());
                if (result instanceof ValidationFailure) {
                    throw new XQException(((ValidationFailure)result).getMessage());
                }
                return new SaxonXQItem((AtomicValue)result, this);
            }
            throw new XQException("Target type must be xs:QName or a subtype");
        }
        if (value instanceof Node) {
            NodeInfo result = (NodeInfo)this.getObjectConverter().convertToItem(value);
            SaxonXQItem item = new SaxonXQItem(result, this);
            if (!item.instanceOf(type)) {
                throw new XQException("Supplied node does not match the requested XQItemType");
            }
            return item;
        }
        return new SaxonXQItem(this.getObjectConverter().convertToItem(value, type), this);
    }

    public XQItem createItemFromShort(short value, XQItemType type) throws XQException {
        this.checkNotClosed();
        if (type == null) {
            try {
                return new SaxonXQItem(new Int64Value(value, BuiltInAtomicType.SHORT, false), this);
            }
            catch (XPathException de) {
                throw SaxonXQDataFactory.newXQException(de);
            }
        }
        return this.createItemFromLong(value, type);
    }

    public XQItemType createNodeType() throws XQException {
        this.checkNotClosed();
        return new SaxonXQItemType(AnyNodeTest.getInstance(), this.getConfiguration());
    }

    public XQItemType createProcessingInstructionType(String piTarget) throws XQException {
        this.checkNotClosed();
        if (piTarget == null) {
            return new SaxonXQItemType(NodeKindTest.PROCESSING_INSTRUCTION, this.getConfiguration());
        }
        return new SaxonXQItemType(new NameTest(7, "", piTarget, this.getConfiguration().getNamePool()), this.getConfiguration());
    }

    public XQItemType createSchemaAttributeType(QName nodename, int basetype, URI schemaURI) throws XQException {
        this.checkNotClosed();
        Configuration config = this.getConfiguration();
        int fp = this.getFingerprint(nodename);
        SchemaDeclaration attributeDecl = config.getAttributeDeclaration(fp);
        if (attributeDecl == null && schemaURI != null) {
            this.loadSchema(schemaURI);
            attributeDecl = config.getAttributeDeclaration(fp);
        }
        if (attributeDecl == null) {
            throw new XQException("Attribute declaration " + nodename + " not found in schema");
        }
        NameTest nameTest = new NameTest(2, fp, config.getNamePool());
        ContentTypeTest typeTest = new ContentTypeTest(2, attributeDecl.getType(), config);
        CombinedNodeTest combo = new CombinedNodeTest(nameTest, 23, typeTest);
        return new SaxonXQItemType(combo, config);
    }

    public XQItemType createSchemaElementType(QName nodename, int basetype, URI schemaURI) throws XQException {
        this.checkNotClosed();
        Configuration config = this.getConfiguration();
        int fp = this.getFingerprint(nodename);
        SchemaDeclaration elementDecl = config.getElementDeclaration(fp);
        if (elementDecl == null && schemaURI != null) {
            this.loadSchema(schemaURI);
            elementDecl = config.getElementDeclaration(fp);
        }
        if (elementDecl == null) {
            throw new XQException("Element declaration " + nodename + " not found in schema");
        }
        NodeTest nameTest = elementDecl.makeSchemaNodeTest();
        ContentTypeTest typeTest = new ContentTypeTest(1, elementDecl.getType(), config);
        CombinedNodeTest combo = new CombinedNodeTest(nameTest, 23, typeTest);
        return new SaxonXQItemType(combo, config);
    }

    public XQSequence createSequence(Iterator i) throws XQException {
        this.checkNotClosed();
        if (i == null) {
            throw new XQException("createSequence(): argument is null");
        }
        ArrayList<Item> list = new ArrayList<Item>(50);
        while (i.hasNext()) {
            Object object = i.next();
            XQItem item = object instanceof XQItem ? (XQItem)object : this.createItemFromObject(object, null);
            list.add(((SaxonXQItem)item).getSaxonItem());
        }
        SequenceExtent extent = new SequenceExtent(list);
        return new SaxonXQSequence((Value)extent, this);
    }

    public XQSequence createSequence(XQSequence s) throws XQException {
        this.checkNotClosed();
        if (s instanceof SaxonXQSequence) {
            return new SaxonXQSequence(((SaxonXQSequence)s).getValue(), this);
        }
        if (s instanceof SaxonXQForwardSequence) {
            try {
                Value extent = Value.asValue(SequenceExtent.makeSequenceExtent(((SaxonXQForwardSequence)s).getCleanIterator()));
                return new SaxonXQSequence(extent, this);
            }
            catch (XPathException de) {
                throw SaxonXQDataFactory.newXQException(de);
            }
        }
        throw new XQException("Supplied sequence is not a Saxon implementation");
    }

    public XQSequenceType createSequenceType(XQItemType item, int occurrence) throws XQException {
        this.checkNotClosed();
        if (item instanceof SaxonXQItemType) {
            int cardinality;
            ItemType itemType = ((SaxonXQItemType)item).getSaxonItemType();
            switch (occurrence) {
                case 2: {
                    cardinality = 16384;
                    break;
                }
                case 4: {
                    cardinality = 49152;
                    break;
                }
                case 1: {
                    cardinality = 24576;
                    break;
                }
                case 3: {
                    cardinality = 57344;
                    break;
                }
                default: {
                    throw new XQException("Invalid occurrence value");
                }
            }
            SequenceType st = SequenceType.makeSequenceType(itemType, cardinality);
            return new SaxonXQSequenceType(st, this.getConfiguration());
        }
        throw new XQException("Supplied XQItemType is not a Saxon-created object");
    }

    public XQItemType createTextType() throws XQException {
        this.checkNotClosed();
        return new SaxonXQItemType(NodeKindTest.TEXT, this.getConfiguration());
    }

    private AtomicType testAtomic(XQItemType type) throws XQException {
        if (type instanceof SaxonXQItemType) {
            AtomicType at = ((SaxonXQItemType)type).getAtomicType();
            if (at == null) {
                throw new XQException("Requested type is not atomic");
            }
            return at;
        }
        throw new XQException("Supplied XQItemType is not a Saxon-created object");
    }

    private static XQException newXQException(Exception err) {
        XQException e = new XQException(err.getMessage());
        e.initCause(err);
        return e;
    }

    private int getFingerprint(QName name) {
        return this.getConfiguration().getNamePool().allocate(name.getPrefix(), name.getNamespaceURI(), name.getLocalPart());
    }

    private void loadSchema(URI schemaURI) throws XQException {
        if (schemaURI == null) {
            return;
        }
        if (!schemaURI.isAbsolute()) {
            throw new XQException("Schema URI must be an absolute URI");
        }
        try {
            this.getConfiguration().loadSchema(schemaURI.toString());
        }
        catch (SchemaException err) {
            throw SaxonXQDataFactory.newXQException(err);
        }
    }

    static {
        SaxonXQDataFactory.map(3, 573);
        SaxonXQDataFactory.map(2, 572);
        SaxonXQDataFactory.map(8, 529);
        SaxonXQDataFactory.map(9, 528);
        SaxonXQDataFactory.map(10, 514);
        SaxonXQDataFactory.map(31, 538);
        SaxonXQDataFactory.map(11, 521);
        SaxonXQDataFactory.map(16, 519);
        SaxonXQDataFactory.map(17, 515);
        SaxonXQDataFactory.map(18, 517);
        SaxonXQDataFactory.map(19, 518);
        SaxonXQDataFactory.map(50, 564);
        SaxonXQDataFactory.map(48, 563);
        SaxonXQDataFactory.map(20, 516);
        SaxonXQDataFactory.map(21, 525);
        SaxonXQDataFactory.map(22, 526);
        SaxonXQDataFactory.map(23, 524);
        SaxonXQDataFactory.map(24, 523);
        SaxonXQDataFactory.map(25, 522);
        SaxonXQDataFactory.map(26, 527);
        SaxonXQDataFactory.map(46, 560);
        SaxonXQDataFactory.map(47, 561);
        SaxonXQDataFactory.map(49, 562);
        SaxonXQDataFactory.map(12, 536);
        SaxonXQDataFactory.map(13, 532);
        SaxonXQDataFactory.map(42, 555);
        SaxonXQDataFactory.map(15, 535);
        SaxonXQDataFactory.map(43, 558);
        SaxonXQDataFactory.map(44, 559);
        SaxonXQDataFactory.map(34, 534);
        SaxonXQDataFactory.map(45, 556);
        SaxonXQDataFactory.map(51, 557);
        SaxonXQDataFactory.map(33, 539);
        SaxonXQDataFactory.map(32, 533);
        SaxonXQDataFactory.map(40, 553);
        SaxonXQDataFactory.map(27, 531);
        SaxonXQDataFactory.map(35, 540);
        SaxonXQDataFactory.map(28, 530);
        SaxonXQDataFactory.map(14, 537);
        SaxonXQDataFactory.map(29, 513);
        SaxonXQDataFactory.map(30, 520);
        SaxonXQDataFactory.map(41, 554);
        SaxonXQDataFactory.map(39, 544);
        SaxonXQDataFactory.map(37, 542);
        SaxonXQDataFactory.map(36, 541);
        SaxonXQDataFactory.map(38, 543);
        SaxonXQDataFactory.map(4, 632);
        SaxonXQDataFactory.map(6, 634);
        SaxonXQDataFactory.map(1, 630);
        SaxonXQDataFactory.map(5, 631);
        SaxonXQDataFactory.map(7, 633);
    }
}

