/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.tools;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.jaggery.tools.CommandLineExecutor;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;

public class JaggeryShell
extends ScriptableObject {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(JaggeryShell.class);
    private static final String CMD_QUIT = "quit";
    private static final String CMD_HELP = "help";
    private static final String CMD_VERSION = "version";
    private boolean quitting;
    private static PrintStream out = System.out;

    public boolean isQuitting() {
        return this.quitting;
    }

    public void setQuitting(boolean quitting) {
        this.quitting = quitting;
    }

    public String getClassName() {
        return "CommandLineClient";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enterContext(String[] args) {
        Context context = ContextFactory.getGlobal().enterContext();
        try {
            Object[] array;
            JaggeryShell shell = new JaggeryShell();
            context.initStandardObjects((ScriptableObject)shell);
            String[] names = new String[]{CMD_QUIT, CMD_VERSION, CMD_HELP};
            shell.defineFunctionProperties(names, JaggeryShell.class, 2);
            String[] optionArgs = JaggeryShell.processOptions(context, args);
            if (optionArgs.length == 0) {
                array = new Object[]{};
            } else {
                int length = optionArgs.length - 1;
                array = new Object[length];
                System.arraycopy(optionArgs, 1, array, 0, length);
            }
            Scriptable argsObj = context.newArray((Scriptable)shell, array);
            shell.defineProperty("arguments", argsObj, 2);
            shell.processSource(context, optionArgs.length == 0 ? null : optionArgs[0]);
        }
        finally {
            Context.exit();
        }
    }

    public static String[] processOptions(Context context, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                String[] result = new String[args.length - i];
                for (int j = i; j < args.length; ++j) {
                    result[j - i] = args[j];
                }
                return result;
            }
            JaggeryShell.usage(arg);
        }
        return new String[0];
    }

    private static void usage(String passedString) {
        JaggeryShell.printToConsole("Invalid arguments. Cannot recognize \"" + passedString + "\".");
        JaggeryShell.help();
    }

    public static void help() {
        JaggeryShell.printToConsole("");
        JaggeryShell.printToConsole("Command                 Description");
        JaggeryShell.printToConsole("=======                 ===========");
        JaggeryShell.printToConsole("help                \tDisplay Jaggery help messages");
        JaggeryShell.printToConsole("quit\t                Quit Jaggery command line client");
        JaggeryShell.printToConsole("version\t\tGet Jaggery version");
        JaggeryShell.printToConsole("");
    }

    public static void execute(Context context, Scriptable thisObj, Object[] args, Function funObj) {
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                out.print(" ");
            }
            String contextString = Context.toString((Object)args[i]);
            out.print(contextString);
        }
        out.println();
    }

    public void quit() {
        this.quitting = true;
    }

    public static String version() {
        return "Jaggery version is " + JaggeryShell.class.getPackage().getImplementationVersion();
    }

    public static void load(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        JaggeryShell shell = (JaggeryShell)JaggeryShell.getTopLevelScope((Scriptable)thisObj);
        for (int i = 0; i < args.length; ++i) {
            shell.processSource(cx, Context.toString((Object)args[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSource(Context cx, String filename) {
        if (filename == null) {
            this.processSource(cx);
        } else {
            String fileSeparator = System.getProperty("file.separator");
            String fileToProcess = filename.replace("\\", fileSeparator + fileSeparator);
            fileToProcess = fileToProcess.replace("/", fileSeparator + fileSeparator);
            FileReader in = null;
            try {
                in = new FileReader(fileToProcess);
                in.toString();
            }
            catch (FileNotFoundException ex) {
                Context.reportError((String)("Couldn't open file \"" + fileToProcess + "\"."));
                return;
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.error((Object)("Error closing file reader for file " + filename), (Throwable)e);
                }
            }
            CommandLineExecutor.parseJaggeryScript(fileToProcess);
        }
    }

    private void processSource(Context cx) {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        boolean hitEOF = false;
        do {
            out.print("jaggery> ");
            out.flush();
            try {
                StringBuilder sbuilder = new StringBuilder();
                do {
                    String newline;
                    if ((newline = in.readLine()) == null) {
                        hitEOF = true;
                        break;
                    }
                    sbuilder.append(newline);
                    sbuilder.append('\n');
                } while (!cx.stringIsCompilableUnit(sbuilder.toString()));
                String source = sbuilder.toString();
                if (CMD_VERSION.equalsIgnoreCase(source.trim())) {
                    out.println("\n" + JaggeryShell.version() + "\n");
                    this.processSource(cx);
                    return;
                }
                if (CMD_HELP.equalsIgnoreCase(source.trim())) {
                    JaggeryShell.help();
                    this.processSource(cx);
                    return;
                }
                if (CMD_QUIT.equalsIgnoreCase(source.trim())) {
                    this.quit();
                    out.println("\n");
                } else if ("".equals(source.trim())) {
                    this.processSource(cx);
                    return;
                }
                if (this.quitting) break;
                out.println("\n");
                CommandLineExecutor.parseJaggeryExpression(source);
                out.println("\n");
            }
            catch (WrappedException we) {
                out.println(we.getWrappedException().toString());
            }
            catch (EvaluatorException ee) {
                out.println("js: " + ee.getMessage());
            }
            catch (JavaScriptException jse) {
                out.println("js: " + jse.getMessage());
            }
            catch (IOException ioe) {
                out.println(ioe.toString());
            }
        } while (!hitEOF);
        out.println();
    }

    private static void printToConsole(String s) {
        out.println(s);
    }
}

