/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.core.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Stack;
import javax.activation.FileTypeMap;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.hostobjects.file.JavaScriptFile;
import org.jaggeryjs.hostobjects.file.JavaScriptFileManager;
import org.jaggeryjs.jaggery.core.manager.CommonManager;
import org.jaggeryjs.jaggery.core.manager.WebAppManager;
import org.jaggeryjs.scriptengine.engine.JaggeryContext;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;

public class WebAppFile
implements JavaScriptFile {
    private static final Log log = LogFactory.getLog(WebAppFile.class);
    private RandomAccessFile file = null;
    private File f = null;
    private String realPath = null;
    private String path = null;
    private boolean opened = false;
    private JavaScriptFileManager fileManager = null;
    private boolean readable = false;
    private boolean writable = false;

    public WebAppFile(String path, ServletContext context) throws ScriptException {
        this.path = path;
        this.realPath = context.getRealPath(this.getFilePath(path));
    }

    public void construct() throws ScriptException {
        this.f = new File(this.realPath);
    }

    private String getFilePath(String fileURL) throws ScriptException {
        JaggeryContext jaggeryContext = CommonManager.getJaggeryContext();
        Stack<String> includesCallstack = CommonManager.getCallstack(jaggeryContext);
        ServletContext context = (ServletContext)jaggeryContext.getProperty("jaggery.servlet.context");
        String parent = (String)includesCallstack.lastElement();
        try {
            String[] keys = WebAppManager.getKeys(context.getContextPath(), parent, fileURL);
            fileURL = "/".equals(keys[1]) ? keys[2] : keys[1] + keys[2];
        }
        catch (NullPointerException ne) {
            throw new ScriptException("Invalid file path : " + fileURL, (Exception)ne);
        }
        return fileURL;
    }

    public void open(String mode) throws ScriptException {
        if ("r".equals(mode)) {
            try {
                this.file = new RandomAccessFile(this.realPath, "r");
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            this.readable = true;
        } else if ("r+".equals(mode)) {
            try {
                this.file = new RandomAccessFile(this.realPath, "rw");
                this.file.seek(0L);
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            this.readable = true;
            this.writable = true;
        } else if ("w".equals(mode)) {
            try {
                this.file = new RandomAccessFile(this.realPath, "rw");
                this.file.setLength(0L);
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            this.writable = true;
        } else if ("w+".equals(mode)) {
            try {
                this.file = new RandomAccessFile(this.realPath, "rw");
                this.file.setLength(0L);
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            this.readable = true;
            this.writable = true;
        } else if ("a".equals(mode)) {
            try {
                this.file = new RandomAccessFile(this.realPath, "rw");
                this.file.seek(this.file.length());
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            this.writable = true;
        } else if ("a+".equals(mode)) {
            try {
                this.file = new RandomAccessFile(this.realPath, "rw");
                this.file.seek(this.file.length());
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            this.readable = true;
            this.writable = true;
        } else {
            String msg = "Invalid or unsupported file mode, path : " + this.realPath + ", mode : " + mode;
            log.error((Object)msg);
            throw new ScriptException(msg);
        }
        this.opened = true;
    }

    public void close() throws ScriptException {
        if (!this.opened) {
            return;
        }
        try {
            this.file.close();
            this.opened = false;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public String read(long count) throws ScriptException {
        if (!this.opened) {
            log.warn((Object)"You need to open the file for reading");
            return null;
        }
        if (!this.readable) {
            log.warn((Object)"File has not opened in a readable mode.");
            return null;
        }
        try {
            byte[] arr = new byte[(int)Math.min(count, this.file.length())];
            this.file.readFully(arr);
            return new String(arr, "UTF-8");
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public void write(String data) throws ScriptException {
        if (!this.opened) {
            log.warn((Object)"You need to open the file for writing");
            return;
        }
        if (!this.writable) {
            log.warn((Object)"File has not opened in a writable mode.");
            return;
        }
        try {
            this.file.writeBytes(data);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public void write(InputStream data) throws ScriptException {
        if (!this.opened) {
            log.warn((Object)"You need to open the file for writing");
            return;
        }
        if (!this.writable) {
            log.warn((Object)"File has not opened in a writable mode.");
            return;
        }
        try {
            IOUtils.copy((InputStream)data, (OutputStream)new FileOutputStream(this.file.getFD()));
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public String readAll() throws ScriptException {
        if (!this.opened) {
            log.warn((Object)"You need to open the file for reading");
            return null;
        }
        if (!this.readable) {
            log.warn((Object)"File has not opened in a readable mode.");
            return null;
        }
        try {
            long pointer = this.file.getFilePointer();
            this.file.seek(0L);
            String data = this.read(this.file.length());
            this.file.seek(pointer);
            return data;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public boolean move(String dest) throws ScriptException {
        if (this.opened) {
            log.warn((Object)"Please close the file before moving");
            return false;
        }
        return this.f.renameTo(this.fileManager.getFile(dest));
    }

    public boolean del() throws ScriptException {
        if (this.opened) {
            log.warn((Object)"Please close the file before deleting");
            return false;
        }
        return FileUtils.deleteQuietly((File)this.f);
    }

    public long getLength() throws ScriptException {
        return this.f.length();
    }

    public long getLastModified() throws ScriptException {
        return this.f.lastModified();
    }

    public String getName() throws ScriptException {
        return this.f.getName();
    }

    public boolean isExist() throws ScriptException {
        return this.f.exists();
    }

    public InputStream getInputStream() throws ScriptException {
        try {
            this.open("r");
            return new FileInputStream(this.file.getFD());
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public OutputStream getOutputStream() throws ScriptException {
        try {
            this.open("w");
            return new FileOutputStream(this.file.getFD());
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public String getContentType() throws ScriptException {
        return FileTypeMap.getDefaultFileTypeMap().getContentType(this.getName());
    }

    public boolean saveAs(String dest) throws ScriptException {
        return this.move(dest);
    }

    public boolean mkdir() throws ScriptException {
        return this.f.mkdir();
    }

    public boolean isDirectory() throws ScriptException {
        return this.f.isDirectory();
    }

    public String getPath() throws ScriptException {
        return this.path;
    }

    public String getURI() throws ScriptException {
        return this.path;
    }

    public ArrayList<String> listFiles() throws ScriptException {
        File[] fileList = this.f.listFiles();
        ArrayList<String> jsfl = new ArrayList<String>();
        String parentDir = this.getURI();
        if (!parentDir.endsWith("/")) {
            parentDir = parentDir + "/";
        }
        if (fileList != null) {
            for (File fi : fileList) {
                jsfl.add(parentDir + fi.getName());
            }
        }
        return jsfl;
    }

    public void setFileManager(JavaScriptFileManager fileManager) {
        this.fileManager = fileManager;
    }
}

