/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.log;

import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jaggeryjs.scriptengine.engine.JaggeryContext;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

public class LogHostObject
extends ScriptableObject {
    private static final Log log = LogFactory.getLog(LogHostObject.class);
    public static final String LOG_LEVEL = "hostobject.log.loglevel";
    public static final String JAGGERY_INCLUDES_CALLSTACK = "jaggery.includes.callstack";
    private static final String HOSTOBJECT_NAME = "Log";
    private static final String ROOT_LOGGER = "JAGGERY";
    private static final String LOG_LEVEL_INFO = "info";
    private static final String LOG_LEVEL_WARN = "warn";
    private static final String LOG_LEVEL_DEBUG = "debug";
    private static final String LOG_LEVEL_ERROR = "error";
    private static final String LOG_LEVEL_FATAL = "fatal";
    private static final String LOG_LEVEL_TRACE = "trace";
    private static final String RHINO_EXCEPTION_KEY = "rhinoException";
    private static final String JAVA_EXCEPTION_KEY = "javaException";
    private static final String WARN_NON_THROWABLE = "Non throwable Java object has been passed as an argument";
    private Logger logger;

    public String getClassName() {
        return HOSTOBJECT_NAME;
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws ScriptException {
        String loggerName;
        int argsCount = args.length;
        if (argsCount > 1) {
            HostObjectUtil.invalidNumberOfArgs((String)HOSTOBJECT_NAME, (String)HOSTOBJECT_NAME, (int)argsCount, (boolean)true);
        }
        JaggeryContext context = (JaggeryContext)RhinoEngine.getContextProperty((Object)"engine.jaggeryContext");
        if (argsCount == 1 && args[0] instanceof String) {
            loggerName = (String)args[0];
        } else {
            String requestString = (String)((Stack)context.getProperty(JAGGERY_INCLUDES_CALLSTACK)).peek();
            loggerName = ROOT_LOGGER + requestString.replace(".jag", ":jag").replace(".js", ":js").replace("/", ".");
        }
        LogHostObject logObj = new LogHostObject();
        logObj.logger = Logger.getLogger((String)loggerName);
        String logLevel = (String)context.getProperty(LOG_LEVEL);
        if (LOG_LEVEL_FATAL.equalsIgnoreCase(logLevel)) {
            logObj.logger.setLevel(Level.FATAL);
        } else if (LOG_LEVEL_WARN.equalsIgnoreCase(logLevel)) {
            logObj.logger.setLevel(Level.WARN);
        } else if (LOG_LEVEL_DEBUG.equalsIgnoreCase(logLevel)) {
            logObj.logger.setLevel(Level.DEBUG);
        } else if (LOG_LEVEL_ERROR.equalsIgnoreCase(logLevel)) {
            logObj.logger.setLevel(Level.ERROR);
        } else if (LOG_LEVEL_TRACE.equalsIgnoreCase(logLevel)) {
            logObj.logger.setLevel(Level.TRACE);
        } else {
            logObj.logger.setLevel(Level.INFO);
        }
        return logObj;
    }

    public static void jsFunction_debug(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        LogHostObject.log(LOG_LEVEL_DEBUG, thisObj, args);
    }

    public static void jsFunction_trace(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        LogHostObject.log(LOG_LEVEL_TRACE, thisObj, args);
    }

    public static void jsFunction_info(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        LogHostObject.log(LOG_LEVEL_INFO, thisObj, args);
    }

    public static void jsFunction_error(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        LogHostObject.log(LOG_LEVEL_ERROR, thisObj, args);
    }

    public static void jsFunction_warn(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        LogHostObject.log(LOG_LEVEL_WARN, thisObj, args);
    }

    public static void jsFunction_fatal(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        LogHostObject.log(LOG_LEVEL_FATAL, thisObj, args);
    }

    public boolean jsFunction_isDebugEnabled() throws ScriptException {
        return this.logger.isDebugEnabled();
    }

    public boolean jsFunction_isTraceEnabled() throws ScriptException {
        return this.logger.isTraceEnabled();
    }

    private static Throwable getThrowable(Object error) {
        if (error instanceof Throwable) {
            return (Throwable)error;
        }
        if (!(error instanceof Scriptable)) {
            return null;
        }
        Scriptable scriptable = (Scriptable)error;
        if (!"Error".equals(scriptable.getClassName())) {
            return null;
        }
        error = scriptable.get(RHINO_EXCEPTION_KEY, scriptable);
        if (error == null) {
            error = scriptable.get(JAVA_EXCEPTION_KEY, scriptable);
        }
        if (error instanceof Wrapper) {
            error = ((Wrapper)error).unwrap();
        }
        if (!(error instanceof Throwable)) {
            return null;
        }
        return (Throwable)error;
    }

    private static void log(String logLevel, Scriptable thisObj, Object[] args) throws ScriptException {
        int argsCount = args.length;
        if (argsCount == 0) {
            HostObjectUtil.invalidNumberOfArgs((String)HOSTOBJECT_NAME, (String)logLevel, (int)argsCount, (boolean)false);
        }
        LogHostObject logObj = (LogHostObject)thisObj;
        String message = HostObjectUtil.serializeObject((Object)args[0]);
        if (argsCount == 1) {
            LogHostObject.logMessage(logObj.logger, logLevel, message);
            return;
        }
        Throwable exception = LogHostObject.getThrowable(args[1]);
        if (exception == null) {
            LogHostObject.logMessage(logObj.logger, logLevel, message);
            log.warn((Object)WARN_NON_THROWABLE);
            return;
        }
        LogHostObject.logException(logObj.logger, logLevel, message, exception);
    }

    private static void logMessage(Logger log, String logLevel, String message) {
        if (LOG_LEVEL_DEBUG.equals(logLevel)) {
            log.debug((Object)message);
            return;
        }
        if (LOG_LEVEL_ERROR.equals(logLevel)) {
            log.error((Object)message);
            return;
        }
        if (LOG_LEVEL_FATAL.equals(logLevel)) {
            log.fatal((Object)message);
            return;
        }
        if (LOG_LEVEL_INFO.equals(logLevel)) {
            log.info((Object)message);
            return;
        }
        if (LOG_LEVEL_TRACE.equals(logLevel)) {
            log.trace((Object)message);
            return;
        }
        if (LOG_LEVEL_WARN.equals(logLevel)) {
            log.warn((Object)message);
        }
    }

    private static void logException(Logger log, String logLevel, String message, Throwable throwable) {
        if (LOG_LEVEL_DEBUG.equals(logLevel)) {
            log.debug((Object)message, throwable);
            return;
        }
        if (LOG_LEVEL_ERROR.equals(logLevel)) {
            log.error((Object)message, throwable);
            return;
        }
        if (LOG_LEVEL_FATAL.equals(logLevel)) {
            log.fatal((Object)message, throwable);
            return;
        }
        if (LOG_LEVEL_INFO.equals(logLevel)) {
            log.info((Object)message, throwable);
            return;
        }
        if (LOG_LEVEL_TRACE.equals(logLevel)) {
            log.trace((Object)message, throwable);
            return;
        }
        if (LOG_LEVEL_WARN.equals(logLevel)) {
            log.warn((Object)message, throwable);
        }
    }
}

