/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.pac4j.authentication.handler.support;

import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.cas.support.pac4j.authentication.principal.ClientCredential;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.profile.UserProfile;

public final class ClientAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    @NotNull
    private final Clients clients;

    public ClientAuthenticationHandler(Clients theClients) {
        this.clients = theClients;
    }

    public boolean supports(Credential credential) {
        return credential != null && ClientCredential.class.isAssignableFrom(credential.getClass());
    }

    protected HandlerResult doAuthentication(Credential credential) throws GeneralSecurityException, PreventedException {
        ClientCredential clientCredentials = (ClientCredential)credential;
        this.logger.debug("clientCredentials : {}", (Object)clientCredentials);
        String clientName = clientCredentials.getCredentials().getClientName();
        this.logger.debug("clientName : {}", (Object)clientName);
        Client client = this.clients.findClient(clientName);
        this.logger.debug("client : {}", (Object)client);
        UserProfile userProfile = client.getUserProfile(clientCredentials.getCredentials());
        this.logger.debug("userProfile : {}", (Object)userProfile);
        if (userProfile != null && StringUtils.isNotBlank((String)userProfile.getId())) {
            clientCredentials.setUserProfile(userProfile);
            return new HandlerResult((AuthenticationHandler)this, (CredentialMetaData)new BasicCredentialMetaData(credential), (Principal)new SimplePrincipal(userProfile.getId(), userProfile.getAttributes()));
        }
        throw new FailedLoginException("Provider did not produce profile for " + clientCredentials);
    }
}

