/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.authentication;

import java.util.HashMap;
import java.util.Map;
import org.jasig.cas.authentication.AuthenticationBuilder;
import org.jasig.cas.authentication.AuthenticationMetaDataPopulator;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HttpBasedServiceCredential;
import org.jasig.cas.authentication.UsernamePasswordCredential;

public class SamlAuthenticationMetaDataPopulator
implements AuthenticationMetaDataPopulator {
    public static final String ATTRIBUTE_AUTHENTICATION_METHOD = "samlAuthenticationStatementAuthMethod";
    public static final String AUTHN_METHOD_PASSWORD = "urn:oasis:names:tc:SAML:1.0:am:password";
    public static final String AUTHN_METHOD_SSL_TLS_CLIENT = "urn:ietf:rfc:2246";
    public static final String AUTHN_METHOD_X509_PUBLICKEY = "urn:oasis:names:tc:SAML:1.0:am:X509-PKI";
    public static final String AUTHN_METHOD_UNSPECIFIED = "urn:oasis:names:tc:SAML:1.0:am:unspecified";
    private final Map<String, String> authenticationMethods = new HashMap<String, String>();

    public SamlAuthenticationMetaDataPopulator() {
        this.authenticationMethods.put(HttpBasedServiceCredential.class.getName(), AUTHN_METHOD_SSL_TLS_CLIENT);
        this.authenticationMethods.put(UsernamePasswordCredential.class.getName(), AUTHN_METHOD_PASSWORD);
        this.authenticationMethods.put("org.jasig.cas.adaptors.trusted.authentication.principal.PrincipalBearingCredentials", AUTHN_METHOD_UNSPECIFIED);
        this.authenticationMethods.put("org.jasig.cas.adaptors.x509.authentication.principal.X509CertificateCredentials", AUTHN_METHOD_X509_PUBLICKEY);
    }

    public final void populateAttributes(AuthenticationBuilder builder, Credential credential) {
        String credentialsClass = credential.getClass().getName();
        String authenticationMethod = this.authenticationMethods.get(credentialsClass);
        builder.addAttribute(ATTRIBUTE_AUTHENTICATION_METHOD, (Object)authenticationMethod);
    }

    public void setUserDefinedMappings(Map<String, String> userDefinedMappings) {
        this.authenticationMethods.putAll(userDefinedMappings);
    }
}

