/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.x509.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import javax.validation.constraints.NotNull;
import org.jasig.cas.adaptors.x509.authentication.handler.support.DenyRevocationPolicy;
import org.jasig.cas.adaptors.x509.authentication.handler.support.RevocationChecker;
import org.jasig.cas.adaptors.x509.authentication.handler.support.RevocationPolicy;
import org.jasig.cas.adaptors.x509.authentication.handler.support.RevokedCertificateException;
import org.jasig.cas.adaptors.x509.authentication.handler.support.ThresholdExpiredCRLRevocationPolicy;
import org.jasig.cas.adaptors.x509.util.CertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCRLRevocationChecker
implements RevocationChecker {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private RevocationPolicy<Void> unavailableCRLPolicy = new DenyRevocationPolicy();
    @NotNull
    private RevocationPolicy<X509CRL> expiredCRLPolicy = new ThresholdExpiredCRLRevocationPolicy();

    @Override
    public void check(X509Certificate cert) throws GeneralSecurityException {
        X509CRLEntry entry;
        if (cert == null) {
            throw new IllegalArgumentException("Certificate cannot be null.");
        }
        this.logger.debug("Evaluating certificate revocation status for {}", (Object)CertUtils.toString(cert));
        X509CRL crl = this.getCRL(cert);
        if (crl == null) {
            this.logger.warn("CRL data is not available for {}", (Object)CertUtils.toString(cert));
            this.unavailableCRLPolicy.apply(null);
            return;
        }
        if (CertUtils.isExpired(crl)) {
            this.logger.warn("CRL data expired on ", (Object)crl.getNextUpdate());
            this.expiredCRLPolicy.apply(crl);
        }
        if ((entry = crl.getRevokedCertificate(cert)) != null) {
            throw new RevokedCertificateException(entry);
        }
    }

    public void setUnavailableCRLPolicy(RevocationPolicy<Void> policy) {
        this.unavailableCRLPolicy = policy;
    }

    public void setExpiredCRLPolicy(RevocationPolicy<X509CRL> policy) {
        this.expiredCRLPolicy = policy;
    }

    protected abstract X509CRL getCRL(X509Certificate var1);
}

