/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.x509.authentication.handler.support;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevokedCertificateException
extends GeneralSecurityException {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 8827788431199129708L;
    public static final String CRL_REASON_OID = "2.5.29.21";
    private final Date revocationDate;
    private final BigInteger serial;
    private Reason reason;

    public RevokedCertificateException(Date revoked, BigInteger serial) {
        this(revoked, serial, null);
    }

    public RevokedCertificateException(Date revoked, BigInteger serial, Reason reason) {
        this.revocationDate = revoked;
        this.serial = serial;
        this.reason = reason;
    }

    public RevokedCertificateException(X509CRLEntry entry) {
        this.revocationDate = entry.getRevocationDate();
        this.serial = entry.getSerialNumber();
        if (entry.hasExtensions()) {
            try {
                int code = Integer.parseInt(new String(entry.getExtensionValue(CRL_REASON_OID), "ASCII"));
                if (code < Reason.values().length) {
                    this.reason = Reason.fromCode(code);
                }
            }
            catch (Exception e) {
                this.logger.trace("An exception occurred when resolving extension value: {}", (Object)e.getMessage());
            }
        }
    }

    public Date getRevocationDate() {
        return this.revocationDate;
    }

    public BigInteger getSerial() {
        return this.serial;
    }

    public Reason getReason() {
        return this.reason;
    }

    @Override
    public String getMessage() {
        if (this.reason != null) {
            return String.format("Certificate %s revoked on %s for reason %s", new Object[]{this.serial, this.revocationDate, this.reason});
        }
        return String.format("Certificate %s revoked on %s", this.serial, this.revocationDate);
    }

    public static enum Reason {
        Unspecified,
        KeyCompromise,
        CACompromise,
        AffiliationChanged,
        Superseded,
        CessationOfOperation,
        CertificateHold,
        RemoveFromCRL,
        PrivilegeWithdrawn,
        AACompromise;


        public static Reason fromCode(int code) {
            for (int i = 0; i < Reason.values().length; ++i) {
                if (i != code) continue;
                return Reason.values()[i];
            }
            throw new IllegalArgumentException("Unknown CRL reason code.");
        }
    }
}

