/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.common;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.javalite.common.Base64;

public final class Util {
    private Util() {
    }

    public static byte[] readResourceBytes(String resourceName) {
        InputStream is = Util.class.getResourceAsStream(resourceName);
        try {
            byte[] byArray = Util.bytes(is);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            Util.closeQuietly(is);
        }
    }

    public static String readResource(String resourceName) {
        return Util.readResource(resourceName, "UTF-8");
    }

    public static String readResource(String resourceName, String charset) {
        InputStream is = Util.class.getResourceAsStream(resourceName);
        try {
            String string = Util.read(is, charset);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            Util.closeQuietly(is);
        }
    }

    public static String readFile(String fileName) {
        return Util.readFile(fileName, "UTF-8");
    }

    public static String readFile(String fileName, String charset) {
        String string;
        FileInputStream in = null;
        try {
            in = new FileInputStream(fileName);
            string = Util.read(in, charset);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(in);
                throw throwable;
            }
        }
        Util.closeQuietly(in);
        return string;
    }

    @Deprecated
    public static void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void closeQuietly(AutoCloseable autoCloseable) {
        try {
            if (autoCloseable != null) {
                autoCloseable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String read(InputStream in) throws IOException {
        return Util.read(in, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream in, String charset) throws IOException {
        String string;
        if (in == null) {
            throw new IllegalArgumentException("input stream cannot be null");
        }
        InputStreamReader reader = null;
        try {
            int len;
            reader = new InputStreamReader(in, charset);
            char[] buffer = new char[1024];
            StringBuilder sb = new StringBuilder();
            while ((len = reader.read(buffer)) != -1) {
                sb.append(buffer, 0, len);
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            Util.closeQuietly(reader);
            throw throwable;
        }
        Util.closeQuietly(reader);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] bytes(InputStream in) throws IOException {
        byte[] byArray;
        if (in == null) {
            throw new IllegalArgumentException("input stream cannot be null");
        }
        ByteArrayOutputStream os = null;
        try {
            int len;
            os = new ByteArrayOutputStream(1024);
            byte[] bytes = new byte[1024];
            while ((len = in.read(bytes)) != -1) {
                os.write(bytes, 0, len);
            }
            byArray = os.toByteArray();
        }
        catch (Throwable throwable) {
            Util.closeQuietly(os);
            throw throwable;
        }
        Util.closeQuietly(os);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            byte[] byArray = Util.bytes(is);
            return byArray;
        }
        finally {
            Util.closeQuietly(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getResourceLines(String resourceName) throws IOException {
        ArrayList<String> arrayList;
        InputStreamReader isreader = null;
        BufferedReader reader = null;
        try {
            String tmp;
            isreader = new InputStreamReader(Util.class.getResourceAsStream(resourceName));
            reader = new BufferedReader(isreader);
            ArrayList<String> lines = new ArrayList<String>();
            while ((tmp = reader.readLine()) != null) {
                lines.add(tmp);
            }
            arrayList = lines;
        }
        catch (Throwable throwable) {
            Util.closeQuietly(reader);
            Util.closeQuietly(isreader);
            throw throwable;
        }
        Util.closeQuietly(reader);
        Util.closeQuietly(isreader);
        return arrayList;
    }

    public static boolean blank(Object value) {
        return value == null || value.toString().trim().length() == 0;
    }

    public static boolean empty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean empty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static String join(String[] array, String delimiter) {
        if (Util.empty(array)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Util.join(sb, array, delimiter);
        return sb.toString();
    }

    public static String[] split(String input, String delimiters) {
        if (input == null) {
            throw new NullPointerException("input cannot be null");
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(input, delimiters);
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken().trim());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String[] split(String input, char delimiter) {
        return Util.split(input, String.valueOf(delimiter));
    }

    public static String join(Collection<?> collection, String delimiter) {
        if (collection.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Util.join(sb, collection, delimiter);
        return sb.toString();
    }

    public static void join(StringBuilder sb, Collection<?> collection, String delimiter) {
        if (collection.isEmpty()) {
            return;
        }
        Iterator<?> it = collection.iterator();
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(delimiter);
            sb.append(it.next());
        }
    }

    public static void join(StringBuilder sb, Object[] array, String delimiter) {
        if (Util.empty(array)) {
            return;
        }
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(delimiter);
            sb.append(array[i]);
        }
    }

    public static void repeat(StringBuilder sb, String str, int count) {
        for (int i = 0; i < count; ++i) {
            sb.append(str);
        }
    }

    public static void joinAndRepeat(StringBuilder sb, String str, String delimiter, int count) {
        if (count > 0) {
            sb.append(str);
            for (int i = 1; i < count; ++i) {
                sb.append(delimiter);
                sb.append(str);
            }
        }
    }

    public static void saveTo(String path, InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("input stream cannot be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        FileOutputStream out = null;
        try {
            int len;
            out = new FileOutputStream(path);
            byte[] bytes = new byte[1024];
            while ((len = in.read(bytes)) != -1) {
                out.write(bytes, 0, len);
            }
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(out);
                throw throwable;
            }
        }
        Util.closeQuietly(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTraceString(Throwable throwable) {
        String string;
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            pw.println(throwable.toString());
            throwable.printStackTrace(pw);
            pw.flush();
            string = sw.toString();
        }
        catch (Throwable throwable2) {
            Util.closeQuietly(pw);
            Util.closeQuietly(sw);
            throw throwable2;
        }
        Util.closeQuietly(pw);
        Util.closeQuietly(sw);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTo(String path, byte[] content) {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(content);
            Util.saveTo(path, is);
        }
        catch (Throwable throwable) {
            Util.closeQuietly(is);
            throw throwable;
        }
        Util.closeQuietly(is);
    }

    public static String toBase64(byte[] input) {
        return Base64.getEncoder().encodeToString(input);
    }

    public static byte[] fromBase64(String input) {
        return Base64.getDecoder().decode(input);
    }

    public String[] arr(String ... params) {
        return params;
    }
}

