/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.bytecode;

import java.util.HashMap;
import java.util.Map;
import org.kohsuke.asm5.ClassVisitor;
import org.kohsuke.asm5.Label;
import org.kohsuke.asm5.MethodVisitor;
import org.kohsuke.asm5.Type;

final class ClassRewritingContext {
    final String className;
    private final Map<Type, Integer> checkerMethods = new HashMap<Type, Integer>();
    private static final String CHECKER_METHOD_DESCRIPTOR = "(Ljava/lang/Class;)Z";
    public static final String ILLEGAL_ACCESS_ERROR = Type.getInternalName(IllegalAccessError.class);

    ClassRewritingContext(String className) {
        this.className = className;
    }

    public void callTypeCheckMethod(Type suspected, Type actual, MethodVisitor base) {
        base.visitLdcInsn((Object)actual);
        Integer idx = this.checkerMethods.get(suspected);
        if (idx == null) {
            idx = this.checkerMethods.size();
            this.checkerMethods.put(suspected, idx);
        }
        base.visitMethodInsn(184, this.className, this.checkerMethodName(idx), CHECKER_METHOD_DESCRIPTOR, false);
    }

    public void generateCheckerMethods(ClassVisitor base) {
        for (Map.Entry<Type, Integer> e : this.checkerMethods.entrySet()) {
            MethodVisitor mv = base.visitMethod(10, this.checkerMethodName(e.getValue()), CHECKER_METHOD_DESCRIPTOR, null, new String[0]);
            Label startTry = new Label();
            Label endTry = new Label();
            Label handler = new Label();
            mv.visitLabel(startTry);
            mv.visitLdcInsn((Object)e.getKey());
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "java/lang/Class", "isAssignableFrom", CHECKER_METHOD_DESCRIPTOR, false);
            mv.visitInsn(172);
            mv.visitLabel(endTry);
            mv.visitTryCatchBlock(startTry, endTry, handler, ILLEGAL_ACCESS_ERROR);
            mv.visitLabel(handler);
            mv.visitLdcInsn((Object)0);
            mv.visitInsn(172);
            mv.visitMaxs(2, 0);
            mv.visitEnd();
        }
    }

    private String checkerMethodName(int idx) {
        return "____isAssignableFrom" + idx;
    }
}

