/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.resources;

import android.content.Context;
import android.content.res.AssetManager;
import android.net.Uri;
import android.util.Log;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.runtime.ProvidableCompositionLocal;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.resources.AndroidContextProviderKt;
import org.jetbrains.compose.resources.MissingResourceException;
import org.jetbrains.compose.resources.ResourceReader;
import org.jetbrains.compose.resources.ResourceReader_androidKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\"\u001e\u0010\u0002\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u00038AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"getPlatformResourceReader", "Lorg/jetbrains/compose/resources/ResourceReader;", "currentOrPreview", "Landroidx/compose/runtime/ProvidableCompositionLocal;", "getCurrentOrPreview", "(Landroidx/compose/runtime/ProvidableCompositionLocal;Landroidx/compose/runtime/Composer;I)Lorg/jetbrains/compose/resources/ResourceReader;", "library_release"})
@SourceDebugExtension(value={"SMAP\nResourceReader.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceReader.android.kt\norg/jetbrains/compose/resources/ResourceReader_androidKt\n+ 2 CompositionLocal.kt\nandroidx/compose/runtime/CompositionLocal\n*L\n1#1,113:1\n75#2:114\n*S KotlinDebug\n*F\n+ 1 ResourceReader.android.kt\norg/jetbrains/compose/resources/ResourceReader_androidKt\n*L\n111#1:114\n*E\n"})
public final class ResourceReader_androidKt {
    @NotNull
    public static final ResourceReader getPlatformResourceReader() {
        return new ResourceReader(){
            private final Lazy assets$delegate;
            {
                this.assets$delegate = LazyKt.lazy(getPlatformResourceReader.1::assets_delegate$lambda$0);
            }

            private final AssetManager getAssets() {
                Lazy lazy = this.assets$delegate;
                Object object = lazy.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                return (AssetManager)object;
            }

            private final AssetManager getInstrumentedAssets() {
                AssetManager assetManager;
                try {
                    assetManager = AndroidContextProviderKt.getAndroidInstrumentedContext().getAssets();
                }
                catch (NoClassDefFoundError e) {
                    Log.d((String)"ResourceReader", (String)"Android Instrumentation context is not available.");
                    assetManager = null;
                }
                return assetManager;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object read(String path, Continuation<? super byte[]> $completion) {
                byte[] byArray;
                InputStream resource = this.getResourceAsStream(path);
                Closeable closeable = resource;
                Throwable throwable = null;
                try {
                    InputStream input = (InputStream)closeable;
                    boolean bl = false;
                    byArray = ByteStreamsKt.readBytes((InputStream)input);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return byArray;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object readPart(String path, long offset, long size, Continuation<? super byte[]> $completion) {
                InputStream resource = this.getResourceAsStream(path);
                byte[] result = new byte[(int)size];
                Closeable closeable = resource;
                Throwable throwable = null;
                try {
                    InputStream input = (InputStream)closeable;
                    boolean bl = false;
                    this.skipBytes(input, offset);
                    this.readBytes(input, result, 0, (int)size);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return result;
            }

            private final void skipBytes(InputStream $this$skipBytes, long offset) {
                long count;
                for (long skippedBytes = 0L; skippedBytes < offset && (count = $this$skipBytes.skip(offset - skippedBytes)) != 0L; skippedBytes += count) {
                }
            }

            private final void readBytes(InputStream $this$readBytes, byte[] byteArray, int offset, int size) {
                int count;
                for (int readBytes = 0; readBytes < size && (count = $this$readBytes.read(byteArray, offset + readBytes, size - readBytes)) > 0; readBytes += count) {
                }
            }

            public String getUri(String path) {
                Comparable comparable;
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                if (this.hasFile(this.getAssets(), path) || this.hasFile(this.getInstrumentedAssets(), path)) {
                    comparable = (Comparable)Uri.parse((String)("file:///android_asset/" + path));
                } else {
                    ClassLoader classLoader = this.getClassLoader();
                    URL uRL = classLoader.getResource(path);
                    if (uRL == null) {
                        throw new MissingResourceException(path);
                    }
                    URL resource = uRL;
                    comparable = resource.toURI();
                }
                Comparable uri = comparable;
                return uri.toString();
            }

            private final InputStream getResourceAsStream(String path) {
                InputStream inputStream;
                try {
                    inputStream = this.getAssets().open(path);
                    Intrinsics.checkNotNull((Object)inputStream);
                }
                catch (FileNotFoundException e) {
                    InputStream inputStream2;
                    try {
                        inputStream2 = this.open(this.getInstrumentedAssets(), path);
                    }
                    catch (FileNotFoundException e2) {
                        ClassLoader classLoader = this.getClassLoader();
                        InputStream inputStream3 = classLoader.getResourceAsStream(path);
                        if (inputStream3 == null) {
                            throw new MissingResourceException(path);
                        }
                        inputStream2 = inputStream3;
                    }
                    inputStream = inputStream2;
                }
                return inputStream;
            }

            private final ClassLoader getClassLoader() {
                ClassLoader classLoader = this.getClass().getClassLoader();
                if (classLoader == null) {
                    throw new IllegalStateException("Cannot find class loader".toString());
                }
                return classLoader;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean hasFile(AssetManager $this$hasFile, String path) {
                boolean bl;
                InputStream inputStream = null;
                try {
                    inputStream = this.open($this$hasFile, path);
                    bl = true;
                }
                catch (FileNotFoundException e) {
                    bl = false;
                }
                finally {
                    InputStream inputStream2 = inputStream;
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
                boolean result = bl;
                return result;
            }

            private final InputStream open(AssetManager $this$open, String path) {
                Object object = $this$open;
                if (object == null || (object = object.open(path)) == null) {
                    throw new FileNotFoundException("Current AssetManager is null.");
                }
                return object;
            }

            private static final AssetManager assets_delegate$lambda$0() {
                Context context = AndroidContextProviderKt.getAndroidContext();
                if (context == null) {
                    throw new IllegalStateException("Android context is not initialized. If it happens in the Preview mode then call PreviewContextConfigurationEffect() function.".toString());
                }
                Context context2 = context;
                return context2.getAssets();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    @JvmName(name="getCurrentOrPreview")
    @NotNull
    public static final ResourceReader getCurrentOrPreview(@NotNull ProvidableCompositionLocal<ResourceReader> $this$currentOrPreview, @Nullable Composer $composer, int $changed) {
        void this_$iv;
        Intrinsics.checkNotNullParameter($this$currentOrPreview, (String)"<this>");
        $composer.startReplaceGroup(-1260790148);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-1260790148, (int)$changed, (int)-1, (String)"org.jetbrains.compose.resources.<get-currentOrPreview> (ResourceReader.android.kt:108)");
        }
        AndroidContextProviderKt.PreviewContextConfigurationEffect($composer, 0);
        CompositionLocal compositionLocal = (CompositionLocal)$this$currentOrPreview;
        int $changed$iv = 0xE & $changed;
        boolean $i$f$getCurrent = false;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)2023513938, (String)"CC(<get-current>):CompositionLocal.kt#9igjgp");
        Object object = $composer.consume((CompositionLocal)this_$iv);
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        ResourceReader resourceReader = (ResourceReader)object;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceGroup();
        return resourceReader;
    }
}

