/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.AtomicNullableLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfoRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.PathExecLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;

public class SystemInfo
extends SystemInfoRt {
    public static final String OS_NAME = SystemInfoRt.OS_NAME;
    public static final String OS_VERSION = SystemInfoRt.OS_VERSION;
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String JAVA_RUNTIME_VERSION = SystemInfo.getRtVersion(JAVA_VERSION);
    public static final String ARCH_DATA_MODEL = System.getProperty("sun.arch.data.model");
    public static final String SUN_DESKTOP = System.getProperty("sun.desktop", "");
    public static final boolean isWindows = SystemInfoRt.isWindows;
    public static final boolean isMac = SystemInfoRt.isMac;
    public static final boolean isLinux = SystemInfoRt.isLinux;
    public static final boolean isFreeBSD = SystemInfoRt.isFreeBSD;
    public static final boolean isSolaris = SystemInfoRt.isSolaris;
    public static final boolean isUnix = SystemInfoRt.isUnix;
    public static final boolean isAppleJvm = SystemInfo.vendorContains("Apple");
    public static final boolean isOracleJvm = SystemInfo.vendorContains("Oracle");
    public static final boolean isSunJvm = SystemInfo.vendorContains("Sun") && SystemInfo.vendorContains("Microsystems");
    public static final boolean isIbmJvm = SystemInfo.vendorContains("IBM");
    public static final boolean isJetBrainsJvm;
    public static final boolean isJetbrainsJvm;
    public static final boolean IS_AT_LEAST_JAVA9;
    public static final boolean isWin2kOrNewer;
    public static final boolean isWinXpOrNewer;
    public static final boolean isWinVistaOrNewer;
    public static final boolean isWin7OrNewer;
    public static final boolean isWin8OrNewer;
    public static final boolean isWin10OrNewer;
    private static final AtomicNullableLazyValue<File> ourWSLBashFile;
    public static final boolean isXWindow;
    public static final boolean isWayland;
    public static final boolean isGNOME;
    public static final boolean isKDE;
    public static final boolean isMacSystemMenu;
    public static final boolean isFileSystemCaseSensitive;
    public static final boolean areSymLinksSupported;
    public static final boolean is32Bit;
    public static final boolean is64Bit;
    public static final boolean isMacIntel64;
    private static final NotNullLazyValue<Boolean> ourHasXdgOpen;
    private static final NotNullLazyValue<Boolean> ourHasXdgMime;
    public static final boolean isMacOSTiger;
    public static final boolean isMacOSLeopard;
    public static final boolean isMacOSSnowLeopard;
    public static final boolean isMacOSLion;
    public static final boolean isMacOSMountainLion;
    public static final boolean isMacOSMavericks;
    public static final boolean isMacOSYosemite;
    public static final boolean isMacOSElCapitan;
    public static final boolean isMacOSSierra;
    public static final boolean isWindowsXP;
    public static final boolean isAMD64;
    public static final boolean isOS2;

    private static String getRtVersion(String fallback) {
        String rtVersion = System.getProperty("java.runtime.version");
        return Character.isDigit(rtVersion.charAt(0)) ? rtVersion : fallback;
    }

    public static boolean isOsVersionAtLeast(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/kotlin/com/intellij/openapi/util/SystemInfo", "isOsVersionAtLeast"));
        }
        return StringUtil.compareVersionNumbers(OS_VERSION, version) >= 0;
    }

    public static boolean hasXdgOpen() {
        return isXWindow && ourHasXdgOpen.getValue() != false;
    }

    public static boolean isJavaVersionAtLeast(String v) {
        return StringUtil.compareVersionNumbers(JAVA_RUNTIME_VERSION, v) >= 0;
    }

    private static boolean vendorContains(String s) {
        String vendor = SystemProperties.getJavaVmVendor();
        return vendor != null && StringUtil.containsIgnoreCase(vendor, s);
    }

    static {
        isJetbrainsJvm = isJetBrainsJvm = SystemInfo.vendorContains("JetBrains");
        IS_AT_LEAST_JAVA9 = SystemInfo.isJavaVersionAtLeast("9");
        isWin2kOrNewer = isWindows && SystemInfo.isOsVersionAtLeast("5.0");
        isWinXpOrNewer = isWindows && SystemInfo.isOsVersionAtLeast("5.1");
        isWinVistaOrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.0");
        isWin7OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.1");
        isWin8OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.2");
        isWin10OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("10.0");
        ourWSLBashFile = new AtomicNullableLazyValue<File>(){

            @Override
            @Nullable
            protected File compute() {
                File bashFile;
                String windir;
                if (isWin10OrNewer && !StringUtil.isEmpty(windir = System.getenv().get("windir")) && (bashFile = new File(windir + "\\System32\\bash.exe")).exists()) {
                    return bashFile;
                }
                return null;
            }
        };
        isXWindow = isUnix && !isMac;
        isWayland = isXWindow && !StringUtil.isEmpty(System.getenv("WAYLAND_DISPLAY"));
        isGNOME = isXWindow && ObjectUtils.notNull(System.getenv("GDMSESSION"), "").startsWith("gnome");
        isKDE = isXWindow && !StringUtil.isEmpty(System.getenv("KDE_FULL_SESSION"));
        isMacSystemMenu = isMac && "true".equals(System.getProperty("apple.laf.useScreenMenuBar"));
        isFileSystemCaseSensitive = SystemInfoRt.isFileSystemCaseSensitive;
        areSymLinksSupported = isUnix || isWinVistaOrNewer;
        is32Bit = ARCH_DATA_MODEL == null || ARCH_DATA_MODEL.equals("32");
        is64Bit = !is32Bit;
        isMacIntel64 = isMac && "x86_64".equals(OS_ARCH);
        ourHasXdgOpen = new PathExecLazyValue("xdg-open");
        ourHasXdgMime = new PathExecLazyValue("xdg-mime");
        isMacOSTiger = isMac && SystemInfo.isOsVersionAtLeast("10.4");
        isMacOSLeopard = isMac && SystemInfo.isOsVersionAtLeast("10.5");
        isMacOSSnowLeopard = isMac && SystemInfo.isOsVersionAtLeast("10.6");
        isMacOSLion = isMac && SystemInfo.isOsVersionAtLeast("10.7");
        isMacOSMountainLion = isMac && SystemInfo.isOsVersionAtLeast("10.8");
        isMacOSMavericks = isMac && SystemInfo.isOsVersionAtLeast("10.9");
        isMacOSYosemite = isMac && SystemInfo.isOsVersionAtLeast("10.10");
        isMacOSElCapitan = isMac && SystemInfo.isOsVersionAtLeast("10.11");
        isMacOSSierra = isMac && SystemInfo.isOsVersionAtLeast("10.12");
        isWindowsXP = isWindows && (OS_VERSION.equals("5.1") || OS_VERSION.equals("5.2"));
        isAMD64 = "amd64".equals(OS_ARCH);
        isOS2 = SystemInfoRt.isOS2;
    }
}

