/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImpl;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeRendererKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphRendererKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeKind;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EnterNodeMarker;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ExitNodeMarker;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FirControlFlowGraphRenderVisitor;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.UnionFunctionCallArgumentsNode;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 $2\u00020\u0001:\u0001$B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\f\u0010\u001c\u001a\u00020\u0013*\u00020\bH\u0002J\u0014\u0010\u001d\u001a\u00020\u0013*\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\f\u0010 \u001a\u00020\u0013*\u00020\u0010H\u0002J\u0014\u0010!\u001a\u00020\u0013*\u00020\u00102\u0006\u0010\"\u001a\u00020\bH\u0002J\u0014\u0010#\u001a\u00020\u0013*\u00020\u00102\u0006\u0010\"\u001a\u00020\bH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FirControlFlowGraphRenderVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Ljava/lang/StringBuilder;)V", "allGraphs", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "clusterCounter", "", "indices", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "nodeCounter", "printer", "Lorg/jetbrains/kotlin/utils/Printer;", "topLevelGraphs", "visitControlFlowGraphReference", "", "controlFlowGraphReference", "Lorg/jetbrains/kotlin/fir/references/FirControlFlowGraphReference;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "collectNodes", "enterCluster", "color", "", "exitCluster", "renderEdges", "graph", "renderNodes", "Companion", "resolve"})
public final class FirControlFlowGraphRenderVisitor
extends FirVisitorVoid {
    private final Printer printer;
    private int nodeCounter;
    private int clusterCounter;
    private final Map<CFGNode<?>, Integer> indices;
    private final Set<ControlFlowGraph> topLevelGraphs;
    private final Set<ControlFlowGraph> allGraphs;
    private static final EnumMap<EdgeKind, String> EDGE_STYLE;
    public static final Companion Companion;

    @Override
    public void visitFile(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.printer.println("digraph " + StringsKt.replace$default((String)file2.getName(), (String)".", (String)"_", (boolean)false, (int)4, null) + " {").pushIndent().println("graph [nodesep=3]").println("node [shape=box penwidth=2]").println("edge [penwidth=2]").println(new Object[0]);
        this.visitElement(file2);
        for (ControlFlowGraph topLevelGraph : this.topLevelGraphs) {
            this.renderNodes(this.printer, topLevelGraph);
            this.renderEdges(this.printer, topLevelGraph);
            this.printer.println(new Object[0]);
        }
        this.printer.popIndent().println("}");
    }

    private final void collectNodes(ControlFlowGraph $this$collectNodes) {
        for (CFGNode<?> node : $this$collectNodes.getNodes()) {
            int n = this.nodeCounter;
            this.nodeCounter = n + 1;
            this.indices.put(node, n);
        }
    }

    private final void renderNodes(Printer $this$renderNodes, ControlFlowGraph graph2) {
        String color = "red";
        List sortedNodes2 = ControlFlowGraphRendererKt.access$sortedNodes(graph2);
        for (CFGNode node : sortedNodes2) {
            if (node instanceof EnterNodeMarker) {
                this.enterCluster($this$renderNodes, color);
                color = "blue";
            }
            boolean bl = false;
            List attributes = new ArrayList();
            Collection collection = attributes;
            String string2 = "label=\"" + StringsKt.replace$default((String)CFGNodeRendererKt.render(node), (String)"\"", (String)"", (boolean)false, (int)4, null) + '\"';
            boolean bl2 = false;
            collection.add(string2);
            Function1<String, Unit> $fun$fillColor$1 = new Function1<String, Unit>(attributes){
                final /* synthetic */ List $attributes;

                public final void invoke(@NotNull String color) {
                    Intrinsics.checkNotNullParameter((Object)color, (String)"color");
                    Collection collection = this.$attributes;
                    String string2 = "style=\"filled\"";
                    boolean bl = false;
                    collection.add(string2);
                    collection = this.$attributes;
                    string2 = "fillcolor=" + color;
                    bl = false;
                    collection.add(string2);
                }
                {
                    this.$attributes = list2;
                    super(1);
                }
            };
            if (Intrinsics.areEqual((Object)node, node.getOwner().getEnterNode()) || Intrinsics.areEqual((Object)node, node.getOwner().getExitNode())) {
                $fun$fillColor$1.invoke("red");
            }
            if (node.isDead()) {
                $fun$fillColor$1.invoke("gray");
            } else if (node instanceof UnionFunctionCallArgumentsNode) {
                $fun$fillColor$1.invoke("yellow");
            }
            $this$renderNodes.println(MapsKt.getValue(this.indices, (Object)node), CollectionsKt.joinToString$default((Iterable)attributes, (CharSequence)" ", (CharSequence)" [", (CharSequence)"];", (int)0, null, null, (int)56, null));
            if (!(node instanceof ExitNodeMarker)) continue;
            this.exitCluster($this$renderNodes);
        }
    }

    private final void renderEdges(Printer $this$renderEdges, ControlFlowGraph graph2) {
        for (CFGNode<?> node : graph2.getNodes()) {
            if (node.getFollowingNodes().isEmpty()) continue;
            Function1<EdgeKind, Unit> $fun$renderEdges$1 = new Function1<EdgeKind, Unit>(this, $this$renderEdges, node){
                final /* synthetic */ FirControlFlowGraphRenderVisitor this$0;
                final /* synthetic */ Printer $this_renderEdges;
                final /* synthetic */ CFGNode $node;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull EdgeKind kind) {
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
                    Iterable $this$filter$iv = this.$node.getFollowingNodes();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Object destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo22 = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        CFGNode it = (CFGNode)element$iv$iv;
                        boolean bl = false;
                        if (!((EdgeKind)((Object)MapsKt.getValue(this.$node.getOutgoingEdges(), (Object)it)) == kind)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List edges = (List)destination$iv$iv;
                    if (edges.isEmpty()) {
                        return;
                    }
                    Object[] objectArray = new Object[3];
                    objectArray[0] = MapsKt.getValue((Map)FirControlFlowGraphRenderVisitor.access$getIndices$p(this.this$0), (Object)this.$node);
                    objectArray[1] = " -> ";
                    Object object = (Function1)new Function1<CFGNode<?>, CharSequence>(this){
                        final /* synthetic */ renderEdges.1 this$0;

                        @NotNull
                        public final CharSequence invoke(@NotNull CFGNode<?> it) {
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            return String.valueOf(((Number)MapsKt.getValue((Map)FirControlFlowGraphRenderVisitor.access$getIndices$p(this.this$0.this$0), it)).intValue());
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    };
                    CharSequence charSequence = null;
                    int n = 0;
                    destination$iv$iv = " ";
                    CharSequence $i$f$filterTo22 = "}";
                    Object object2 = "{";
                    objectArray[2] = CollectionsKt.joinToString$default((Iterable)edges, (CharSequence)destination$iv$iv, (CharSequence)object2, (CharSequence)$i$f$filterTo22, (int)n, charSequence, (Function1)object, (int)24, null);
                    this.$this_renderEdges.print(objectArray);
                    object = MapsKt.getValue((Map)FirControlFlowGraphRenderVisitor.access$getEDGE_STYLE$cp(), (Object)((Object)kind));
                    boolean bl = false;
                    n = 0;
                    String it = (String)object;
                    boolean bl2 = false;
                    String string2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
                    object2 = string2;
                    boolean bl3 = false;
                    String string3 = (String)(!StringsKt.isBlank((CharSequence)object2) ? object : null);
                    if (string3 != null) {
                        object = string3;
                        bl = false;
                        n = 0;
                        it = object;
                        boolean bl4 = false;
                        this.$this_renderEdges.printWithNoIndent(' ' + it);
                    }
                    this.$this_renderEdges.printlnWithNoIndent(";");
                }
                {
                    this.this$0 = firControlFlowGraphRenderVisitor;
                    this.$this_renderEdges = printer;
                    this.$node = cFGNode;
                    super(1);
                }
            };
            for (EdgeKind kind : EdgeKind.values()) {
                $fun$renderEdges$1.invoke(kind);
            }
        }
        for (ControlFlowGraph subGraph : graph2.getSubGraphs()) {
            this.renderEdges($this$renderEdges, subGraph);
        }
    }

    @Override
    public void visitElement(@NotNull FirElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.acceptChildren(this);
    }

    @Override
    public void visitControlFlowGraphReference(@NotNull FirControlFlowGraphReference controlFlowGraphReference) {
        boolean bl;
        Collection collection;
        Object object;
        Intrinsics.checkNotNullParameter((Object)controlFlowGraphReference, (String)"controlFlowGraphReference");
        FirControlFlowGraphReference firControlFlowGraphReference = controlFlowGraphReference;
        if (!(firControlFlowGraphReference instanceof FirControlFlowGraphReferenceImpl)) {
            firControlFlowGraphReference = null;
        }
        if ((object = (FirControlFlowGraphReferenceImpl)firControlFlowGraphReference) == null || (object = ((FirControlFlowGraphReferenceImpl)object).getControlFlowGraph()) == null) {
            return;
        }
        Object controlFlowGraph = object;
        this.collectNodes((ControlFlowGraph)controlFlowGraph);
        if (((ControlFlowGraph)controlFlowGraph).getOwner() == null) {
            collection = this.topLevelGraphs;
            bl = false;
            collection.add(controlFlowGraph);
        }
        collection = this.allGraphs;
        bl = false;
        collection.add(controlFlowGraph);
    }

    private final void enterCluster(Printer $this$enterCluster, String color) {
        Object[] objectArray = new Object[1];
        int n = this.clusterCounter;
        this.clusterCounter = n + 1;
        objectArray[0] = "subgraph cluster_" + n + " {";
        $this$enterCluster.println(objectArray);
        $this$enterCluster.pushIndent();
        $this$enterCluster.println("color=" + color);
    }

    private final void exitCluster(Printer $this$exitCluster) {
        $this$exitCluster.popIndent();
        $this$exitCluster.println("}");
    }

    public FirControlFlowGraphRenderVisitor(@NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.printer = new Printer(builder);
        boolean bl = false;
        this.indices = new LinkedHashMap();
        bl = false;
        this.topLevelGraphs = new LinkedHashSet();
        bl = false;
        this.allGraphs = new LinkedHashSet();
    }

    static {
        Companion = new Companion(null);
        EDGE_STYLE = new EnumMap(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)EdgeKind.Simple), (Object)""), TuplesKt.to((Object)((Object)EdgeKind.Dead), (Object)"[style=dotted]"), TuplesKt.to((Object)((Object)EdgeKind.Cfg), (Object)"[color=green]"), TuplesKt.to((Object)((Object)EdgeKind.Dfg), (Object)"[color=red]")}));
    }

    public static final /* synthetic */ Map access$getIndices$p(FirControlFlowGraphRenderVisitor $this) {
        return $this.indices;
    }

    public static final /* synthetic */ EnumMap access$getEDGE_STYLE$cp() {
        return EDGE_STYLE;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00040\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FirControlFlowGraphRenderVisitor$Companion;", "", "()V", "BLUE", "", "EDGE", "EDGE_STYLE", "Ljava/util/EnumMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeKind;", "kotlin.jvm.PlatformType", "RED", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

