/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.GeneratedJvmClass;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.util.io.BooleanDataDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.com.intellij.util.io.EnumeratorStringDescriptor;
import org.jetbrains.kotlin.incremental.AbstractIncrementalCache;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ClassProtoData;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache$WhenMappings;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.JavaClassProtoMapValueExternalizer;
import org.jetbrains.kotlin.incremental.JavaClassesTrackerImplKt;
import org.jetbrains.kotlin.incremental.LocalFileKotlinClass;
import org.jetbrains.kotlin.incremental.PathCollectionExternalizer;
import org.jetbrains.kotlin.incremental.ProtoDifferenceUtilsKt;
import org.jetbrains.kotlin.incremental.SerializedJavaClass;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.ConstantsMapExternalizer;
import org.jetbrains.kotlin.incremental.storage.DirtyClassesJvmNameMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverterKt;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.ProtoMapValue;
import org.jetbrains.kotlin.incremental.storage.ProtoMapValueExternalizer;
import org.jetbrains.kotlin.incremental.storage.SourceToJvmNameMap;
import org.jetbrains.kotlin.incremental.storage.StringCollectionExternalizer;
import org.jetbrains.kotlin.incremental.storage.StringToLongMapExternalizer;
import org.jetbrains.kotlin.inline.InlineUtilKt;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.JvmPackagePartProto;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.jvm.deserialization.BitEncoding;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0016\u0018\u0000 X2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\tXYZ[\\]^_`B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0005H\u0002J\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050-J\u0010\u0010/\u001a\u00020(2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020(2\u0006\u00103\u001a\u000204H\u0014J\u0010\u00105\u001a\u0002042\u0006\u00106\u001a\u000204H\u0016J\n\u00107\u001a\u0004\u0018\u000108H\u0016J\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u0002040:H\u0016J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u0002040:H\u0016J\u0012\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010@\u001a\u000204H\u0016J\u0018\u0010A\u001a\n\u0012\u0004\u0012\u000204\u0018\u00010:2\u0006\u0010B\u001a\u000204H\u0016J\u000e\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020;J\u000e\u0010F\u001a\u00020D2\u0006\u0010E\u001a\u00020;J\u000e\u0010G\u001a\u00020D2\u0006\u0010H\u001a\u00020\u0002J\u000e\u0010I\u001a\u00020D2\u0006\u0010J\u001a\u00020\u0005J\u0018\u0010K\u001a\u00020(2\u0006\u0010L\u001a\u00020M2\u0006\u00100\u001a\u000201H\u0016J\u001e\u0010N\u001a\u00020(2\u0006\u0010O\u001a\u00020\u00052\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u000201J\u001c\u0010S\u001a\u00020(2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00050:2\u0006\u0010J\u001a\u00020\u0005J\u000e\u0010U\u001a\u00020D2\u0006\u0010J\u001a\u00020\u0005J\u0014\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00050:2\u0006\u0010W\u001a\u000204R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001d\u001a\u00060\u001eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001f\u001a\u00060 R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u00060\"R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;", "Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache;", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCache;", "targetDataRoot", "Ljava/io/File;", "targetOutputDir", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Ljava/io/File;Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "constantsMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ConstantsMap;", "dirtyOutputClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesJvmNameMap;", "getDirtyOutputClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesJvmNameMap;", "inlineFunctionsMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InlineFunctionsMap;", "internalNameToSource", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InternalNameToSourcesMap;", "javaSourcesProtoMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$JavaSourcesProtoMap;", "multifileFacadeToParts", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassFacadeMap;", "outputDir", "getOutputDir", "()Ljava/io/File;", "outputDir$delegate", "Lkotlin/Lazy;", "packagePartMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$PackagePartMap;", "partToMultifileFacade", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassPartMap;", "protoMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ProtoMap;", "sourceToClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/SourceToJvmNameMap;", "getSourceToClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/SourceToJvmNameMap;", "addToClassStorage", "", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "srcFile", "classesBySources", "", "sources", "clearCacheForRemovedClasses", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "debugLog", "message", "", "getClassFilePath", "internalClassName", "getModuleMappingData", "", "getObsoleteJavaClasses", "", "Lorg/jetbrains/kotlin/name/ClassId;", "getObsoleteMultifileClasses", "getObsoletePackageParts", "getPackagePartData", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/JvmPackagePartProto;", "partInternalName", "getStableMultifileFacadeParts", "facadeInternalName", "isJavaClassAlreadyInCache", "", "classId", "isJavaClassToTrack", "isMultifileFacade", "className", "isTrackedFile", "file", "saveFileToCache", "generatedClass", "Lorg/jetbrains/kotlin/build/GeneratedJvmClass;", "saveJavaClassProto", "source", "serializedJavaClass", "Lorg/jetbrains/kotlin/incremental/SerializedJavaClass;", "collector", "saveModuleMappingToCache", "sourceFiles", "sourceInCache", "sourcesByInternalName", "internalName", "Companion", "ConstantsMap", "InlineFunctionsMap", "InternalNameToSourcesMap", "JavaSourcesProtoMap", "MultifileClassFacadeMap", "MultifileClassPartMap", "PackagePartMap", "ProtoMap", "kotlin-build-common"})
public class IncrementalJvmCache
extends AbstractIncrementalCache<JvmClassName>
implements IncrementalCache {
    @NotNull
    private final SourceToJvmNameMap sourceToClassesMap;
    @NotNull
    private final DirtyClassesJvmNameMap dirtyOutputClassesMap;
    private final ProtoMap protoMap;
    private final ConstantsMap constantsMap;
    private final PackagePartMap packagePartMap;
    private final MultifileClassFacadeMap multifileFacadeToParts;
    private final MultifileClassPartMap partToMultifileFacade;
    private final InlineFunctionsMap inlineFunctionsMap;
    private final InternalNameToSourcesMap internalNameToSource;
    private final JavaSourcesProtoMap javaSourcesProtoMap;
    private final Lazy outputDir$delegate;
    private final File targetDataRoot;
    private static final String PROTO_MAP;
    private static final String CONSTANTS_MAP;
    private static final String PACKAGE_PARTS;
    private static final String MULTIFILE_CLASS_FACADES;
    private static final String MULTIFILE_CLASS_PARTS;
    private static final String INLINE_FUNCTIONS;
    private static final String INTERNAL_NAME_TO_SOURCE;
    private static final String JAVA_SOURCES_PROTO_MAP;
    private static final String MODULE_MAPPING_FILE_NAME;
    public static final Companion Companion;

    @NotNull
    public SourceToJvmNameMap getSourceToClassesMap$kotlin_build_common() {
        return this.sourceToClassesMap;
    }

    @NotNull
    public DirtyClassesJvmNameMap getDirtyOutputClassesMap$kotlin_build_common() {
        return this.dirtyOutputClassesMap;
    }

    private final File getOutputDir() {
        Lazy lazy = this.outputDir$delegate;
        IncrementalJvmCache incrementalJvmCache = this;
        Object var3_3 = null;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    protected void debugLog(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
    }

    public final boolean isTrackedFile(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.getSourceToClassesMap$kotlin_build_common().contains(file2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<JvmClassName> classesBySources(@NotNull Iterable<? extends File> sources) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Iterable<? extends File> $this$flatMap$iv = sources;
        boolean $i$f$flatMap = false;
        Iterable<? extends File> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getSourceToClassesMap$kotlin_build_common().get(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean sourceInCache(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.getSourceToClassesMap$kotlin_build_common().contains(file2);
    }

    @NotNull
    public final Collection<File> sourcesByInternalName(@NotNull String internalName) {
        Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
        return this.internalNameToSource.get(internalName);
    }

    public final boolean isMultifileFacade(@NotNull JvmClassName className2) {
        Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
        return this.multifileFacadeToParts.contains(className2);
    }

    @Override
    @NotNull
    public String getClassFilePath(@NotNull String internalClassName) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        String string2 = FileUtil.toSystemIndependentName(new File(this.getOutputDir(), internalClassName + ".class").getCanonicalPath());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(\u2026me.class\").canonicalPath)");
        return string2;
    }

    public final void saveModuleMappingToCache(@NotNull Collection<? extends File> sourceFiles2, @NotNull File file2) {
        Intrinsics.checkNotNullParameter(sourceFiles2, (String)"sourceFiles");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        JvmClassName jvmClassName = JvmClassName.byInternalName(MODULE_MAPPING_FILE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"JvmClassName.byInternalN\u2026MODULE_MAPPING_FILE_NAME)");
        JvmClassName jvmClassName2 = jvmClassName;
        this.protoMap.storeModuleMapping(jvmClassName2, FilesKt.readBytes((File)file2));
        this.getDirtyOutputClassesMap$kotlin_build_common().notDirty(jvmClassName2);
        Iterable $this$forEach$iv = sourceFiles2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.getSourceToClassesMap$kotlin_build_common().add(it, jvmClassName2);
        }
    }

    public void saveFileToCache(@NotNull GeneratedJvmClass generatedClass, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkNotNullParameter((Object)generatedClass, (String)"generatedClass");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        Collection sourceFiles2 = generatedClass.getSourceFiles();
        LocalFileKotlinClass kotlinClass = generatedClass.getOutputClass();
        JvmClassName className2 = kotlinClass.getClassName();
        this.getDirtyOutputClassesMap$kotlin_build_common().notDirty(className2);
        Iterable $this$forEach$iv = sourceFiles2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.getSourceToClassesMap$kotlin_build_common().add(it, className2);
        }
        String string2 = className2.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
        this.internalNameToSource.set(string2, sourceFiles2);
        ClassId classId = kotlinClass.getClassId();
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"kotlinClass.classId");
        if (classId.isLocal()) {
            return;
        }
        KotlinClassHeader kotlinClassHeader = kotlinClass.getClassHeader();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinClassHeader, (String)"kotlinClass.classHeader");
        KotlinClassHeader header = kotlinClassHeader;
        switch (IncrementalJvmCache$WhenMappings.$EnumSwitchMapping$0[header.getKind().ordinal()]) {
            case 1: {
                $i$f$forEach = sourceFiles2.size() == 1;
                boolean bl = false;
                if (_Assertions.ENABLED && !$i$f$forEach) {
                    boolean $i$a$-assert-IncrementalJvmCache$saveFileToCache$52 = false;
                    String $i$a$-assert-IncrementalJvmCache$saveFileToCache$52 = "Package part from several source files: " + sourceFiles2;
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-IncrementalJvmCache$saveFileToCache$52));
                }
                this.packagePartMap.addPackagePart(className2);
                this.protoMap.process(kotlinClass, changesCollector);
                this.constantsMap.process(kotlinClass, changesCollector);
                this.inlineFunctionsMap.process(kotlinClass, changesCollector);
                break;
            }
            case 2: {
                Object object = kotlinClass.getClassHeader().getData();
                if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Multifile class has no parts: " + kotlinClass.getClassName())));
                }
                Object partNames = object;
                this.multifileFacadeToParts.set(className2, (Collection)partNames);
                if (this.protoMap.contains(className2)) {
                    FqName fqName2 = className2.getFqNameForClassNameWithoutDollars();
                    Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"className.fqNameForClassNameWithoutDollars");
                    changesCollector.collectSignature(fqName2, true);
                }
                this.protoMap.remove(className2, changesCollector);
                AbstractIncrementalCache.ClassFqNameToSourceMap classFqNameToSourceMap = this.getClassFqNameToSourceMap();
                FqName fqName3 = className2.getFqNameForClassNameWithoutDollars();
                Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"className.fqNameForClassNameWithoutDollars");
                classFqNameToSourceMap.remove(fqName3);
                String string3 = className2.getInternalName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"className.internalName");
                this.internalNameToSource.remove(string3);
                this.constantsMap.process(kotlinClass, changesCollector);
                this.inlineFunctionsMap.process(kotlinClass, changesCollector);
                break;
            }
            case 3: {
                boolean bl = sourceFiles2.size() == 1;
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-IncrementalJvmCache$saveFileToCache$62 = false;
                    String $i$a$-assert-IncrementalJvmCache$saveFileToCache$62 = "Multifile class part from several source files: " + sourceFiles2;
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-IncrementalJvmCache$saveFileToCache$62));
                }
                this.packagePartMap.addPackagePart(className2);
                String string4 = className2.getInternalName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"className.internalName");
                String string5 = header.getMultifileClassName();
                Intrinsics.checkNotNull((Object)string5);
                this.partToMultifileFacade.set(string4, string5);
                this.protoMap.process(kotlinClass, changesCollector);
                this.constantsMap.process(kotlinClass, changesCollector);
                this.inlineFunctionsMap.process(kotlinClass, changesCollector);
                break;
            }
            case 4: {
                boolean bl = sourceFiles2.size() == 1;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string6 = "Class is expected to have only one source file: " + sourceFiles2;
                    throw (Throwable)((Object)new AssertionError((Object)string6));
                }
                this.addToClassStorage(kotlinClass, (File)CollectionsKt.first((Iterable)sourceFiles2));
                this.protoMap.process(kotlinClass, changesCollector);
                this.constantsMap.process(kotlinClass, changesCollector);
                this.inlineFunctionsMap.process(kotlinClass, changesCollector);
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void saveJavaClassProto(@NotNull File source, @NotNull SerializedJavaClass serializedJavaClass, @NotNull ChangesCollector collector2) {
        void proto;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)serializedJavaClass, (String)"serializedJavaClass");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        JvmClassName jvmClassName = JvmClassName.byClassId(serializedJavaClass.getClassId());
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"JvmClassName.byClassId(s\u2026ializedJavaClass.classId)");
        JvmClassName jvmClassName2 = jvmClassName;
        this.javaSourcesProtoMap.process(jvmClassName2, serializedJavaClass, collector2);
        this.getSourceToClassesMap$kotlin_build_common().add(source, jvmClassName2);
        ClassProtoData classProtoData = JavaClassesTrackerImplKt.toProtoData(serializedJavaClass);
        ProtoBuf.Class clazz = classProtoData.component1();
        NameResolver nameResolver2 = classProtoData.component2();
        this.addToClassStorage((ProtoBuf.Class)proto, nameResolver2, source);
        this.getDirtyOutputClassesMap$kotlin_build_common().notDirty(jvmClassName2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<ClassId> getObsoleteJavaClasses() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ClassId classId;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            JvmClassName it = (JvmClassName)element$iv$iv;
            boolean bl2 = false;
            SerializedJavaClass serializedJavaClass = this.javaSourcesProtoMap.get(it);
            if ((serializedJavaClass != null ? serializedJavaClass.getClassId() : null) == null) continue;
            classId = classId;
            boolean bl3 = false;
            boolean bl4 = false;
            ClassId it$iv$iv = classId;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isJavaClassToTrack(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        JvmClassName jvmClassName = JvmClassName.byClassId(classId);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"JvmClassName.byClassId(classId)");
        JvmClassName jvmClassName2 = jvmClassName;
        return this.getDirtyOutputClassesMap$kotlin_build_common().isDirty(jvmClassName2) || !this.javaSourcesProtoMap.contains(jvmClassName2);
    }

    public final boolean isJavaClassAlreadyInCache(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        JvmClassName jvmClassName = JvmClassName.byClassId(classId);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"JvmClassName.byClassId(classId)");
        JvmClassName jvmClassName2 = jvmClassName;
        return this.javaSourcesProtoMap.contains(jvmClassName2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clearCacheForRemovedClasses(@NotNull ChangesCollector changesCollector) {
        Collection<FqName> collection;
        void $this$mapTo$iv$iv;
        Object removedParts;
        Iterable answer$iv;
        Object facade;
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        Collection dirtyClasses = this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses();
        boolean bl = false;
        HashMap facadesWithRemovedParts = new HashMap();
        for (JvmClassName jvmClassName : dirtyClasses) {
            Object object;
            JvmClassName facadeClassName;
            if (this.partToMultifileFacade.get(jvmClassName) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)JvmClassName.byInternalName((String)facade), (String)"JvmClassName.byInternalName(facade)");
            Map $this$getOrPut$iv = facadesWithRemovedParts;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(facadeClassName);
            if (value$iv == null) {
                boolean bl2 = false;
                boolean bl3 = false;
                answer$iv = new HashSet();
                $this$getOrPut$iv.put(facadeClassName, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            removedParts = (Set)object;
            String string2 = jvmClassName.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dirtyClass.internalName");
            removedParts.add(string2);
        }
        for (Map.Entry entry : facadesWithRemovedParts.entrySet()) {
            void $this$filterTo$iv$iv;
            Collection<String> allParts;
            removedParts = entry;
            boolean $this$getOrPut$iv = false;
            facade = (JvmClassName)removedParts.getKey();
            removedParts = entry;
            $this$getOrPut$iv = false;
            Set removedParts2 = (Set)removedParts.getValue();
            Object object = facade;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"facade");
            if (this.multifileFacadeToParts.get((JvmClassName)object) == null) {
                continue;
            }
            Iterable $this$filter$iv = allParts;
            boolean $i$f$filter = false;
            answer$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl4 = false;
                if (!(!removedParts2.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List notRemovedParts = (List)destination$iv$iv;
            if (notRemovedParts.isEmpty()) {
                this.multifileFacadeToParts.remove((JvmClassName)facade);
                continue;
            }
            this.multifileFacadeToParts.set((JvmClassName)facade, notRemovedParts);
        }
        Iterable iterable = dirtyClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : iterable) {
            JvmClassName it = (JvmClassName)element$iv;
            boolean bl5 = false;
            this.protoMap.remove(it, changesCollector);
            this.packagePartMap.remove(it);
            this.multifileFacadeToParts.remove(it);
            this.partToMultifileFacade.remove(it);
            this.constantsMap.remove(it);
            this.inlineFunctionsMap.remove(it);
            String string3 = it.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.internalName");
            this.internalNameToSource.remove(string3);
            this.javaSourcesProtoMap.remove(it, changesCollector);
        }
        Iterable iterable2 = dirtyClasses;
        IncrementalJvmCache incrementalJvmCache = this;
        boolean $i$f$map = false;
        facade = iterable2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FqName fqName2;
            void it;
            JvmClassName $i$f$filter = (JvmClassName)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl6 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getFqNameForClassNameWithoutDollars(), (String)"it.fqNameForClassNameWithoutDollars");
            collection.add(fqName2);
        }
        collection = (List)destination$iv$iv;
        incrementalJvmCache.removeAllFromClassStorage(collection, changesCollector);
        this.getDirtyOutputClassesMap$kotlin_build_common().clean();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<String> getObsoletePackageParts() {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses();
        PackagePartMap packagePartMap = this.packagePartMap;
        boolean $i$f$filter22 = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JvmClassName p1 = (JvmClassName)element$iv$iv;
            boolean bl = false;
            if (!packagePartMap.isPackagePart(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List obsoletePackageParts = (List)destination$iv$iv;
        this.debugLog("Obsolete package parts: " + obsoletePackageParts);
        Iterable $this$map$iv = obsoletePackageParts;
        boolean $i$f$map = false;
        Iterable $i$f$filter22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (JvmClassName)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            String string2 = it.getInternalName();
            collection.add(string2);
        }
        return (List)destination$iv$iv2;
    }

    @Override
    @Nullable
    public JvmPackagePartProto getPackagePartData(@NotNull String partInternalName) {
        JvmPackagePartProto jvmPackagePartProto;
        Intrinsics.checkNotNullParameter((Object)partInternalName, (String)"partInternalName");
        JvmClassName jvmClassName = JvmClassName.byInternalName(partInternalName);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"JvmClassName.byInternalName(partInternalName)");
        ProtoMapValue protoMapValue = this.protoMap.get(jvmClassName);
        if (protoMapValue != null) {
            ProtoMapValue protoMapValue2 = protoMapValue;
            boolean bl = false;
            boolean bl2 = false;
            ProtoMapValue value2 = protoMapValue2;
            boolean bl3 = false;
            jvmPackagePartProto = new JvmPackagePartProto(value2.getBytes(), value2.getStrings());
        } else {
            jvmPackagePartProto = null;
        }
        return jvmPackagePartProto;
    }

    @Override
    @NotNull
    public Collection<String> getObsoleteMultifileClasses() {
        boolean bl = false;
        LinkedHashSet<String> obsoleteMultifileClasses = new LinkedHashSet<String>();
        for (JvmClassName dirtyClass : this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses()) {
            String dirtyFacade;
            if (this.partToMultifileFacade.get(dirtyClass) == null) {
                continue;
            }
            obsoleteMultifileClasses.add(dirtyFacade);
        }
        this.debugLog("Obsolete multifile class facades: " + obsoleteMultifileClasses);
        return obsoleteMultifileClasses;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Collection<String> getStableMultifileFacadeParts(@NotNull String facadeInternalName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)facadeInternalName, (String)"facadeInternalName");
        JvmClassName jvmClassName = JvmClassName.byInternalName(facadeInternalName);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"JvmClassName.byInternalName(facadeInternalName)");
        JvmClassName jvmClassName2 = jvmClassName;
        Collection<String> collection = this.multifileFacadeToParts.get(jvmClassName2);
        if (collection == null) {
            return null;
        }
        Collection<String> partNames = collection;
        Iterable $this$filter$iv = partNames;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            DirtyClassesJvmNameMap dirtyClassesJvmNameMap = this.getDirtyOutputClassesMap$kotlin_build_common();
            JvmClassName jvmClassName3 = JvmClassName.byInternalName(it);
            Intrinsics.checkNotNullExpressionValue((Object)jvmClassName3, (String)"JvmClassName.byInternalName(it)");
            if (!(!dirtyClassesJvmNameMap.isDirty(jvmClassName3))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public byte[] getModuleMappingData() {
        JvmClassName jvmClassName = JvmClassName.byInternalName(MODULE_MAPPING_FILE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"JvmClassName.byInternalN\u2026MODULE_MAPPING_FILE_NAME)");
        ProtoMapValue protoMapValue = this.protoMap.get(jvmClassName);
        return (byte[])(protoMapValue != null ? protoMapValue.getBytes() : null);
    }

    /*
     * WARNING - void declaration
     */
    private final void addToClassStorage(LocalFileKotlinClass kotlinClass, File srcFile) {
        void nameResolver2;
        String[] stringArray = kotlinClass.getClassHeader().getData();
        Intrinsics.checkNotNull((Object)stringArray);
        String[] stringArray2 = kotlinClass.getClassHeader().getStrings();
        Intrinsics.checkNotNull((Object)stringArray2);
        Pair<JvmNameResolver, ProtoBuf.Class> pair = JvmProtoBufUtil.readClassDataFrom(stringArray, stringArray2);
        JvmNameResolver jvmNameResolver = (JvmNameResolver)pair.component1();
        ProtoBuf.Class proto = (ProtoBuf.Class)pair.component2();
        this.addToClassStorage(proto, (NameResolver)nameResolver2, srcFile);
    }

    public IncrementalJvmCache(@NotNull File targetDataRoot, @Nullable File targetOutputDir, @NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkNotNullParameter((Object)targetDataRoot, (String)"targetDataRoot");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        super(new File(targetDataRoot, IncrementalJvmCacheKt.getKOTLIN_CACHE_DIRECTORY_NAME()), pathConverter);
        this.targetDataRoot = targetDataRoot;
        this.sourceToClassesMap = (SourceToJvmNameMap)this.registerMap((BasicMap)new SourceToJvmNameMap(this.getStorageFile(AbstractIncrementalCache.Companion.getSOURCE_TO_CLASSES()), pathConverter));
        this.dirtyOutputClassesMap = (DirtyClassesJvmNameMap)this.registerMap((BasicMap)new DirtyClassesJvmNameMap(this.getStorageFile(AbstractIncrementalCache.Companion.getDIRTY_OUTPUT_CLASSES())));
        this.protoMap = (ProtoMap)this.registerMap((BasicMap)new ProtoMap(this.getStorageFile(PROTO_MAP)));
        this.constantsMap = (ConstantsMap)this.registerMap((BasicMap)new ConstantsMap(this.getStorageFile(CONSTANTS_MAP)));
        this.packagePartMap = (PackagePartMap)this.registerMap((BasicMap)new PackagePartMap(this.getStorageFile(PACKAGE_PARTS)));
        this.multifileFacadeToParts = (MultifileClassFacadeMap)this.registerMap((BasicMap)new MultifileClassFacadeMap(this.getStorageFile(MULTIFILE_CLASS_FACADES)));
        this.partToMultifileFacade = (MultifileClassPartMap)this.registerMap((BasicMap)new MultifileClassPartMap(this.getStorageFile(MULTIFILE_CLASS_PARTS)));
        this.inlineFunctionsMap = (InlineFunctionsMap)this.registerMap((BasicMap)new InlineFunctionsMap(this.getStorageFile(INLINE_FUNCTIONS)));
        this.internalNameToSource = (InternalNameToSourcesMap)this.registerMap((BasicMap)new InternalNameToSourcesMap(this.getStorageFile(INTERNAL_NAME_TO_SOURCE), pathConverter));
        this.javaSourcesProtoMap = (JavaSourcesProtoMap)this.registerMap((BasicMap)new JavaSourcesProtoMap(this.getStorageFile(JAVA_SOURCES_PROTO_MAP)));
        this.outputDir$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<File>(targetOutputDir){
            final /* synthetic */ File $targetOutputDir;

            @NotNull
            public final File invoke() {
                File file2 = this.$targetOutputDir;
                boolean bl = false;
                boolean bl2 = false;
                if (file2 == null) {
                    boolean bl3 = false;
                    String string2 = "Target is expected to have output directory";
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
                return file2;
            }
            {
                this.$targetOutputDir = file2;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        PROTO_MAP = "proto";
        CONSTANTS_MAP = "constants";
        PACKAGE_PARTS = "package-parts";
        MULTIFILE_CLASS_FACADES = "multifile-class-facades";
        MULTIFILE_CLASS_PARTS = "multifile-class-parts";
        INLINE_FUNCTIONS = "inline-functions";
        INTERNAL_NAME_TO_SOURCE = "internal-name-to-source";
        JAVA_SOURCES_PROTO_MAP = "java-sources-proto-map";
        MODULE_MAPPING_FILE_NAME = ".kotlin_module";
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0013\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ProtoMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/incremental/storage/ProtoMapValue;", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "get", "process", "", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "put", "remove", "storeModuleMapping", "bytes", "", "kotlin-build-common"})
    private final class ProtoMap
    extends BasicStringMap<ProtoMapValue> {
        public final void process(@NotNull LocalFileKotlinClass kotlinClass, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkNotNullParameter((Object)kotlinClass, (String)"kotlinClass");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            this.put(kotlinClass, changesCollector);
        }

        public final void storeModuleMapping(@NotNull JvmClassName className2, @NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            LazyStorage<String, ProtoMapValue> lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            lazyStorage.set(string2, new ProtoMapValue(false, bytes, new String[0]));
        }

        private final void put(LocalFileKotlinClass kotlinClass, ChangesCollector changesCollector) {
            KotlinClassHeader kotlinClassHeader = kotlinClass.getClassHeader();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinClassHeader, (String)"kotlinClass.classHeader");
            KotlinClassHeader header = kotlinClassHeader;
            String string2 = kotlinClass.getClassName().getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"kotlinClass.className.internalName");
            String key = string2;
            ProtoMapValue oldData = (ProtoMapValue)this.getStorage().get(key);
            boolean bl = header.getKind() != KotlinClassHeader.Kind.CLASS;
            String[] stringArray = header.getData();
            Intrinsics.checkNotNull((Object)stringArray);
            byte[] byArray = BitEncoding.decodeBytes(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"BitEncoding.decodeBytes(header.data!!)");
            String[] stringArray2 = header.getStrings();
            Intrinsics.checkNotNull((Object)stringArray2);
            ProtoMapValue newData = new ProtoMapValue(bl, byArray, stringArray2);
            this.getStorage().set(key, newData);
            FqName fqName2 = kotlinClass.getClassName().getPackageFqName();
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"kotlinClass.className.packageFqName");
            FqName packageFqName = fqName2;
            ProtoMapValue protoMapValue = oldData;
            ChangesCollector.collectProtoChanges$default(changesCollector, protoMapValue != null ? ProtoDifferenceUtilsKt.toProtoData(protoMapValue, packageFqName) : null, ProtoDifferenceUtilsKt.toProtoData(newData, packageFqName), false, 4, null);
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            return lazyStorage.contains(string2);
        }

        @Nullable
        public final ProtoMapValue get(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            return (ProtoMapValue)lazyStorage.get(string2);
        }

        public final void remove(@NotNull JvmClassName className2, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            String key = string2;
            ProtoMapValue protoMapValue = (ProtoMapValue)this.getStorage().get(key);
            if (protoMapValue == null) {
                return;
            }
            ProtoMapValue oldValue = protoMapValue;
            if (Intrinsics.areEqual((Object)key, (Object)MODULE_MAPPING_FILE_NAME) ^ true) {
                FqName fqName2 = className2.getPackageFqName();
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"className.packageFqName");
                ChangesCollector.collectProtoChanges$default(changesCollector, ProtoDifferenceUtilsKt.toProtoData(oldValue, fqName2), null, false, 4, null);
            }
            this.getStorage().remove(key);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull ProtoMapValue value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return (value2.isPackageFacade() ? "1" : "0") + Long.toHexString(IncrementalJvmCacheKt.md5(value2.getBytes()));
        }

        public ProtoMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            super(storageFile, ProtoMapValueExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0013\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$JavaSourcesProtoMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/incremental/SerializedJavaClass;", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "get", "process", "", "jvmClassName", "newData", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "remove", "kotlin-build-common"})
    private final class JavaSourcesProtoMap
    extends BasicStringMap<SerializedJavaClass> {
        public final void process(@NotNull JvmClassName jvmClassName, @NotNull SerializedJavaClass newData, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkNotNullParameter((Object)jvmClassName, (String)"jvmClassName");
            Intrinsics.checkNotNullParameter((Object)newData, (String)"newData");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            String string2 = jvmClassName.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jvmClassName.internalName");
            String key = string2;
            SerializedJavaClass oldData = (SerializedJavaClass)this.getStorage().get(key);
            this.getStorage().set(key, newData);
            SerializedJavaClass serializedJavaClass = oldData;
            changesCollector.collectProtoChanges(serializedJavaClass != null ? JavaClassesTrackerImplKt.toProtoData(serializedJavaClass) : null, JavaClassesTrackerImplKt.toProtoData(newData), true);
        }

        public final void remove(@NotNull JvmClassName className2, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            String key = string2;
            SerializedJavaClass serializedJavaClass = (SerializedJavaClass)this.getStorage().get(key);
            if (serializedJavaClass == null) {
                return;
            }
            SerializedJavaClass oldValue = serializedJavaClass;
            this.getStorage().remove(key);
            ChangesCollector.collectProtoChanges$default(changesCollector, JavaClassesTrackerImplKt.toProtoData(oldValue), null, false, 4, null);
        }

        @Nullable
        public final SerializedJavaClass get(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            return (SerializedJavaClass)lazyStorage.get(string2);
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            return lazyStorage.contains(string2);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull SerializedJavaClass value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            byte[] byArray = value2.getProto().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"value.proto.toByteArray()");
            String string2 = Long.toHexString(IncrementalJvmCacheKt.md5(byArray));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.Long.toHexStri\u2026roto.toByteArray().md5())");
            return string2;
        }

        public JavaSourcesProtoMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            super(storageFile, JavaClassProtoMapValueExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u001c\u0010\f\u001a\u00020\u00032\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0014J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ConstantsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "value", "getConstantsMap", "bytes", "", "process", "", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "remove", "kotlin-build-common"})
    private final class ConstantsMap
    extends BasicStringMap<Map<String, ? extends Object>> {
        private final Map<String, Object> getConstantsMap(byte[] bytes) {
            HashMap result2 = new HashMap();
            new ClassReader(bytes).accept(new ClassVisitor(result2, 458752){
                final /* synthetic */ HashMap $result;

                @Nullable
                public FieldVisitor visitField(int access, @NotNull String name, @NotNull String desc, @Nullable String signature2, @Nullable Object value2) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                    int staticFinal = 26;
                    if (value2 != null && (access & staticFinal) == 24) {
                        ((Map)this.$result).put(name, value2);
                    }
                    return null;
                }
                {
                    this.$result = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }, 7);
            return result2;
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            return lazyStorage.contains(string2);
        }

        public final void process(@NotNull LocalFileKotlinClass kotlinClass, @NotNull ChangesCollector changesCollector) {
            Map<String, Object> newMap2;
            Intrinsics.checkNotNullParameter((Object)kotlinClass, (String)"kotlinClass");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            String string2 = kotlinClass.getClassName().getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"kotlinClass.className.internalName");
            String key = string2;
            Map map2 = (Map)this.getStorage().get(key);
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map oldMap2 = map2;
            Map<String, Object> map3 = newMap2 = this.getConstantsMap(kotlinClass.getFileContents());
            boolean bl = false;
            if (!map3.isEmpty()) {
                this.getStorage().set(key, newMap2);
            } else {
                this.getStorage().remove(key);
            }
            for (String string3 : SetsKt.plus(oldMap2.keySet(), (Iterable)newMap2.keySet())) {
                changesCollector.collectMemberIfValueWasChanged(IncrementalJvmCacheKt.access$scopeFqName(kotlinClass), string3, oldMap2.get(string3), newMap2.get(string3));
            }
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            lazyStorage.remove(string2);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Map<String, ? extends Object> value2) {
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            return IncrementalJvmCacheKt.dumpMap(value2, dumpValue.1.INSTANCE);
        }

        public ConstantsMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            super(storageFile, ConstantsMapExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u000e\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$PackagePartMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "addPackagePart", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "isPackagePart", "remove", "kotlin-build-common"})
    private final class PackagePartMap
    extends BasicStringMap<Boolean> {
        public final void addPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage<String, Boolean> lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            lazyStorage.set(string2, true);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            lazyStorage.remove(string2);
        }

        public final boolean isPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            return lazyStorage.contains(string2);
        }

        @Override
        @NotNull
        protected String dumpValue(boolean value2) {
            return "";
        }

        public PackagePartMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            BooleanDataDescriptor booleanDataDescriptor = BooleanDataDescriptor.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)booleanDataDescriptor, (String)"BooleanDataDescriptor.INSTANCE");
            super(storageFile, booleanDataDescriptor);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086\u0002J\u0016\u0010\u000b\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0019\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0086\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0086\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassFacadeMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "value", "get", "remove", "", "set", "partNames", "kotlin-build-common"})
    private final class MultifileClassFacadeMap
    extends BasicStringMap<Collection<? extends String>> {
        public final void set(@NotNull JvmClassName className2, @NotNull Collection<String> partNames) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            Intrinsics.checkNotNullParameter(partNames, (String)"partNames");
            LazyStorage<String, Collection<String>> lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            lazyStorage.set(string2, partNames);
        }

        @Nullable
        public final Collection<String> get(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            return (Collection)lazyStorage.get(string2);
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            return lazyStorage.contains(string2);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            lazyStorage.remove(string2);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value2) {
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            return IncrementalJvmCacheKt.dumpCollection(value2);
        }

        public MultifileClassFacadeMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            super(storageFile, StringCollectionExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u0016\u0010\u000e\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassPartMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "dumpValue", "value", "get", "partName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "remove", "", "className", "set", "facadeName", "kotlin-build-common"})
    private final class MultifileClassPartMap
    extends BasicStringMap<String> {
        public final void set(@NotNull String partName, @NotNull String facadeName) {
            Intrinsics.checkNotNullParameter((Object)partName, (String)"partName");
            Intrinsics.checkNotNullParameter((Object)facadeName, (String)"facadeName");
            this.getStorage().set(partName, facadeName);
        }

        @Nullable
        public final String get(@NotNull JvmClassName partName) {
            Intrinsics.checkNotNullParameter((Object)partName, (String)"partName");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = partName.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"partName.internalName");
            return (String)lazyStorage.get(string2);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            lazyStorage.remove(string2);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return value2;
        }

        public MultifileClassPartMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)enumeratorStringDescriptor, (String)"EnumeratorStringDescriptor.INSTANCE");
            super(storageFile, enumeratorStringDescriptor);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0003J\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002H\u0086\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InternalNameToSourcesMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "dumpValue", "value", "get", "internalName", "remove", "", "set", "sourceFiles", "kotlin-build-common"})
    public final class InternalNameToSourcesMap
    extends BasicStringMap<Collection<? extends String>> {
        private final FileToPathConverter pathConverter;

        public final void set(@NotNull String internalName, @NotNull Collection<? extends File> sourceFiles2) {
            Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
            Intrinsics.checkNotNullParameter(sourceFiles2, (String)"sourceFiles");
            this.getStorage().set(internalName, FileToPathConverterKt.toPaths(this.pathConverter, sourceFiles2));
        }

        @NotNull
        public final Collection<File> get(@NotNull String internalName) {
            Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
            Collection collection = (Collection)this.getStorage().get(internalName);
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            return FileToPathConverterKt.toFiles(this.pathConverter, collection);
        }

        public final void remove(@NotNull String internalName) {
            Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
            this.getStorage().remove(internalName);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value2) {
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            return IncrementalJvmCacheKt.dumpCollection(value2);
        }

        public InternalNameToSourcesMap(@NotNull File storageFile, FileToPathConverter pathConverter) {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
            super(storageFile, new EnumeratorStringDescriptor(), (DataExternalizer)PathCollectionExternalizer.INSTANCE);
            this.pathConverter = pathConverter;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00032\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0014J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J$\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InlineFunctionsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "dumpValue", "value", "functionNameBySignature", "signature", "getInlineFunctionsMap", "header", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "bytes", "", "process", "", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "remove", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "kotlin-build-common"})
    private final class InlineFunctionsMap
    extends BasicStringMap<Map<String, ? extends Long>> {
        /*
         * WARNING - void declaration
         */
        private final Map<String, Long> getInlineFunctionsMap(KotlinClassHeader header, byte[] bytes) {
            void dummyVersion;
            Set<String> inlineFunctions = InlineUtilKt.inlineFunctionsJvmNames(header);
            if (inlineFunctions.isEmpty()) {
                return MapsKt.emptyMap();
            }
            HashMap result2 = new HashMap();
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = -1;
            new ClassReader(bytes).accept(new ClassVisitor((Ref.IntRef)dummyVersion, inlineFunctions, result2, 458752){
                final /* synthetic */ Ref.IntRef $dummyVersion;
                final /* synthetic */ Set $inlineFunctions;
                final /* synthetic */ HashMap $result;

                public void visit(int version, int access, @Nullable String name, @Nullable String signature2, @Nullable String superName, @Nullable String[] interfaces) {
                    super.visit(version, access, name, signature2, superName, interfaces);
                    this.$dummyVersion.element = version;
                }

                @Nullable
                public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature2, @Nullable String[] exceptions) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                    ClassWriter dummyClassWriter = new ClassWriter(0);
                    int n = this.$dummyVersion.element;
                    Type type2 = AsmTypes.OBJECT_TYPE;
                    Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"AsmTypes.OBJECT_TYPE");
                    dummyClassWriter.visit(n, 0, "dummy", null, type2.getInternalName(), null);
                    return new MethodVisitor(this, name, desc, dummyClassWriter, exceptions, 458752, dummyClassWriter.visitMethod(0, name, desc, null, exceptions)){
                        final /* synthetic */ getInlineFunctionsMap.1 this$0;
                        final /* synthetic */ String $name;
                        final /* synthetic */ String $desc;
                        final /* synthetic */ ClassWriter $dummyClassWriter;
                        final /* synthetic */ String[] $exceptions;

                        public void visitEnd() {
                            String jvmName = this.$name + this.$desc;
                            if (!this.this$0.$inlineFunctions.contains(jvmName)) {
                                return;
                            }
                            byte[] byArray = this.$dummyClassWriter.toByteArray();
                            Intrinsics.checkNotNull((Object)byArray);
                            byte[] dummyBytes = byArray;
                            long hash = IncrementalJvmCacheKt.md5(dummyBytes);
                            ((Map)this.this$0.$result).put(jvmName, hash);
                        }
                        {
                            this.this$0 = this$0;
                            this.$name = $captured_local_variable$1;
                            this.$desc = $captured_local_variable$2;
                            this.$dummyClassWriter = $captured_local_variable$3;
                            this.$exceptions = $captured_local_variable$4;
                            super($super_call_param$5, $super_call_param$6);
                        }
                    };
                }
                {
                    this.$dummyVersion = $captured_local_variable$0;
                    this.$inlineFunctions = $captured_local_variable$1;
                    this.$result = $captured_local_variable$2;
                    super($super_call_param$3);
                }
            }, 0);
            return result2;
        }

        public final void process(@NotNull LocalFileKotlinClass kotlinClass, @NotNull ChangesCollector changesCollector) {
            Map<String, Long> newMap2;
            Intrinsics.checkNotNullParameter((Object)kotlinClass, (String)"kotlinClass");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            String string2 = kotlinClass.getClassName().getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"kotlinClass.className.internalName");
            String key = string2;
            Map map2 = (Map)this.getStorage().get(key);
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map oldMap2 = map2;
            KotlinClassHeader kotlinClassHeader = kotlinClass.getClassHeader();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinClassHeader, (String)"kotlinClass.classHeader");
            Map<String, Long> map3 = newMap2 = this.getInlineFunctionsMap(kotlinClassHeader, kotlinClass.getFileContents());
            boolean bl = false;
            if (!map3.isEmpty()) {
                this.getStorage().set(key, newMap2);
            } else {
                this.getStorage().remove(key);
            }
            for (String fn : SetsKt.plus(oldMap2.keySet(), (Iterable)newMap2.keySet())) {
                changesCollector.collectMemberIfValueWasChanged(IncrementalJvmCacheKt.access$scopeFqName(kotlinClass), this.functionNameBySignature(fn), oldMap2.get(fn), newMap2.get(fn));
            }
        }

        private final String functionNameBySignature(String signature2) {
            return StringsKt.substringBefore$default((String)signature2, (String)"(", null, (int)2, null);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            lazyStorage.remove(string2);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Map<String, Long> value2) {
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            return IncrementalJvmCacheKt.dumpMap(value2, dumpValue.1.INSTANCE);
        }

        public InlineFunctionsMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            super(storageFile, StringToLongMapExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$Companion;", "", "()V", "CONSTANTS_MAP", "", "INLINE_FUNCTIONS", "INTERNAL_NAME_TO_SOURCE", "JAVA_SOURCES_PROTO_MAP", "MODULE_MAPPING_FILE_NAME", "MULTIFILE_CLASS_FACADES", "MULTIFILE_CLASS_PARTS", "PACKAGE_PARTS", "PROTO_MAP", "kotlin-build-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

