/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.io.Bits;
import org.jetbrains.kotlin.com.intellij.util.io.IOStatistics;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentEnumeratorBase;
import org.jetbrains.kotlin.com.intellij.util.io.ResizeableMappedFile;
import org.jetbrains.kotlin.com.intellij.util.io.StorageLockContext;

public class PersistentEnumerator<Data>
extends PersistentEnumeratorBase<Data> {
    private static final byte[] EMPTY_VECTOR = new byte[64];
    private static final byte[] FIRST_VECTOR = new byte[16384];
    private int valuesCount;

    public PersistentEnumerator(@NotNull Path file2, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable StorageLockContext storageLockContext, int version) throws IOException {
        if (file2 == null) {
            PersistentEnumerator.$$$reportNull$$$0(2);
        }
        if (dataDescriptor == null) {
            PersistentEnumerator.$$$reportNull$$$0(3);
        }
        super(file2, new ResizeableMappedFile(file2, initialSize, storageLockContext, -1, false), dataDescriptor, initialSize, new PersistentEnumeratorBase.Version(6 + version), new RecordBufferHandler(), true);
    }

    @Override
    protected void setupEmptyFile() {
        this.allocVector(FIRST_VECTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean traverseAllRecords(@NotNull PersistentEnumeratorBase.RecordsProcessor p) throws IOException {
        if (p == null) {
            PersistentEnumerator.$$$reportNull$$$0(4);
        }
        Object object = this.getDataAccessLock();
        synchronized (object) {
            return this.traverseRecords(20, 4096, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean traverseRecords(int vectorStart, int slotsCount, @NotNull PersistentEnumeratorBase.RecordsProcessor p) throws IOException {
        if (p == null) {
            PersistentEnumerator.$$$reportNull$$$0(5);
        }
        this.lockStorageRead();
        try {
            for (int slotIdx = 0; slotIdx < slotsCount; ++slotIdx) {
                int vector = this.myStorage.getInt((long)vectorStart + (long)slotIdx * 4L);
                if (vector < 0) {
                    int record2 = -vector;
                    while (record2 != 0) {
                        if (!p.process(record2)) {
                            boolean bl = false;
                            return bl;
                        }
                        record2 = this.nextCandidate(record2);
                    }
                    continue;
                }
                if (vector <= 0 || this.traverseRecords(vector, 16, p)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlockStorageRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int enumerateImpl(Data value2, boolean onlyCheckForExisting, boolean saveNewValue) throws IOException {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            if (onlyCheckForExisting) {
                this.lockStorageWrite();
            } else {
                this.lockStorageWrite();
            }
            try {
                int candidateHC;
                int pos;
                int lastVector;
                int valueHC;
                int depth = 0;
                int hc = valueHC = this.myDataDescriptor.getHashCode(value2);
                int vector = 20;
                int levelMask = 4095;
                int bitsPerLevel = 12;
                do {
                    lastVector = vector;
                    pos = vector + (hc & levelMask) * 4;
                    hc >>>= bitsPerLevel;
                    vector = this.myStorage.getInt(pos);
                    ++depth;
                    levelMask = 15;
                    bitsPerLevel = 4;
                } while (vector > 0);
                if (vector == 0) {
                    if (onlyCheckForExisting) {
                        int n = 0;
                        return n;
                    }
                    int newId = this.writeData(value2, valueHC);
                    this.myStorage.putInt(pos, -newId);
                    int n = newId;
                    return n;
                }
                int collision = -vector;
                boolean splitVector = false;
                do {
                    if ((candidateHC = this.hashCodeOf(collision)) != valueHC) {
                        splitVector = true;
                        break;
                    }
                    Object candidate2 = this.valueOf(collision);
                    if (!this.myDataDescriptor.isEqual(value2, candidate2)) continue;
                    int n = collision;
                    return n;
                } while ((collision = this.nextCandidate(collision)) != 0);
                if (onlyCheckForExisting) {
                    int candidate2 = 0;
                    return candidate2;
                }
                int newId = this.writeData(value2, valueHC);
                if (splitVector) {
                    int oldHCByte;
                    int valueHCByte;
                    --depth;
                    while ((valueHCByte = PersistentEnumerator.hcByte(valueHC, depth)) == (oldHCByte = PersistentEnumerator.hcByte(candidateHC, depth))) {
                        int newVector = this.allocVector(EMPTY_VECTOR);
                        this.myStorage.putInt((long)lastVector + (long)oldHCByte * 4L, newVector);
                        lastVector = newVector;
                        ++depth;
                    }
                    this.myStorage.putInt((long)lastVector + (long)valueHCByte * 4L, -newId);
                    this.myStorage.putInt((long)lastVector + (long)oldHCByte * 4L, vector);
                } else {
                    this.myStorage.putInt(newId, vector);
                    this.myStorage.putInt(pos, -newId);
                }
                int n = newId;
                return n;
            }
            finally {
                if (onlyCheckForExisting) {
                    this.unlockStorageWrite();
                } else {
                    this.unlockStorageWrite();
                }
            }
        }
    }

    @Override
    protected int writeData(Data value2, int hashCode2) {
        int id = super.writeData(value2, hashCode2);
        ++this.valuesCount;
        if (IOStatistics.DEBUG && (this.valuesCount & 0xFFFF) == 0) {
            IOStatistics.dump("Index " + this.myFile + ", values " + this.valuesCount + ", storage size:" + this.myStorage.length());
        }
        return id;
    }

    private static int hcByte(int hashcode, int byteN) {
        if (byteN == 0) {
            return hashcode & 0xFFF;
        }
        return (hashcode >>>= 12) >>> --byteN * 4 & 0xF;
    }

    private int allocVector(byte @NotNull [] empty2) {
        if (empty2 == null) {
            PersistentEnumerator.$$$reportNull$$$0(6);
        }
        int pos = (int)this.myStorage.length();
        this.myStorage.put(pos, empty2, 0, empty2.length);
        return pos;
    }

    private int nextCandidate(int idx) {
        return -this.myStorage.getInt(idx);
    }

    private int hashCodeOf(int idx) {
        return this.myStorage.getInt(idx + 4);
    }

    @Override
    protected int indexToAddr(int idx) {
        return this.myStorage.getInt(idx + 8);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDescriptor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "empty";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentEnumerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "traverseAllRecords";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "traverseRecords";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "allocVector";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RecordBufferHandler
    extends PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumerator<?>> {
        private final ThreadLocal<byte[]> myBuffer = ThreadLocal.withInitial(() -> new byte[12]);

        private RecordBufferHandler() {
        }

        @Override
        protected int recordWriteOffset(@NotNull PersistentEnumerator<?> enumerator, byte[] buf) {
            if (enumerator == null) {
                RecordBufferHandler.$$$reportNull$$$0(0);
            }
            return (int)enumerator.myStorage.length();
        }

        @Override
        byte @NotNull [] getRecordBuffer(PersistentEnumerator<?> t) {
            byte[] byArray = this.myBuffer.get();
            if (byArray == null) {
                RecordBufferHandler.$$$reportNull$$$0(1);
            }
            return byArray;
        }

        @Override
        void setupRecord(PersistentEnumerator<?> enumerator, int hashCode2, int dataOffset, byte[] buf) {
            Bits.putInt(buf, 0, 0);
            Bits.putInt(buf, 4, hashCode2);
            Bits.putInt(buf, 8, dataOffset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumerator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentEnumerator$RecordBufferHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentEnumerator$RecordBufferHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecordBuffer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "recordWriteOffset";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

