/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunnerUtils;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunnerUtils$WhenMappings;
import org.jetbrains.kotlin.compilerRunner.KotlinLogger;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.client.DaemonReportMessage;
import org.jetbrains.kotlin.daemon.client.DaemonReportingTargets;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.WallAndThreadAndMemoryTotalProfiler;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJQ\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0007\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerRunnerUtils;", "", "()V", "exitCodeFromProcessExitCode", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "log", "Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "code", "", "newDaemonConnection", "Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "clientAliveFlagFile", "Ljava/io/File;", "sessionAliveFlagFile", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "isDebugEnabled", "", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "additionalJvmParams", "", "", "(Lorg/jetbrains/kotlin/daemon/common/CompilerId;Ljava/io/File;Ljava/io/File;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;ZLorg/jetbrains/kotlin/daemon/common/DaemonOptions;[Ljava/lang/String;)Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "kotlin-compiler-runner"})
public final class KotlinCompilerRunnerUtils {
    public static final KotlinCompilerRunnerUtils INSTANCE;

    @NotNull
    public final ExitCode exitCodeFromProcessExitCode(@NotNull KotlinLogger log, int code) {
        ExitCode exitCode;
        block2: {
            ExitCode exitCode2;
            ExitCode[] exitCodeArray;
            ExitCode[] exitCodeArray2;
            Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
            for (ExitCode exitCode3 : exitCodeArray2 = (exitCodeArray = ExitCode.values())) {
                ExitCode it = exitCode3;
                if (!(it.getCode() == code)) continue;
                exitCode2 = exitCode3;
                break block2;
            }
            exitCode2 = exitCode = null;
        }
        if (exitCode != null) {
            return exitCode;
        }
        log.debug("Could not find exit code by value: " + code);
        return code == 0 ? ExitCode.OK : ExitCode.COMPILATION_ERROR;
    }

    @JvmStatic
    @Nullable
    public static final synchronized CompileServiceSession newDaemonConnection(@NotNull CompilerId compilerId, @NotNull File clientAliveFlagFile, @NotNull File sessionAliveFlagFile, @NotNull MessageCollector messageCollector, boolean isDebugEnabled, @NotNull DaemonOptions daemonOptions, @NotNull String[] additionalJvmParams) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        Intrinsics.checkParameterIsNotNull((Object)clientAliveFlagFile, (String)"clientAliveFlagFile");
        Intrinsics.checkParameterIsNotNull((Object)sessionAliveFlagFile, (String)"sessionAliveFlagFile");
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkParameterIsNotNull((Object)additionalJvmParams, (String)"additionalJvmParams");
        String[] stringArray = Arrays.copyOf(additionalJvmParams, additionalJvmParams.length);
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        DaemonJVMOptions daemonJVMOptions = DaemonParamsKt.configureDaemonJVMOptions((String[])stringArray, (boolean)bl3, (boolean)bl2, (boolean)bl);
        ArrayList daemonReportMessages = new ArrayList();
        DaemonReportingTargets daemonReportingTargets = new DaemonReportingTargets(null, (Collection)daemonReportMessages, null, null, 13, null);
        Profiler profiler = daemonOptions.getReportPerf() ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
        CompileServiceSession connection2 = (CompileServiceSession)profiler.withMeasure(null, (Function0)new Function0<CompileServiceSession>(compilerId, clientAliveFlagFile, daemonJVMOptions, daemonOptions, daemonReportingTargets, sessionAliveFlagFile){
            final /* synthetic */ CompilerId $compilerId;
            final /* synthetic */ File $clientAliveFlagFile;
            final /* synthetic */ DaemonJVMOptions $daemonJVMOptions;
            final /* synthetic */ DaemonOptions $daemonOptions;
            final /* synthetic */ DaemonReportingTargets $daemonReportingTargets;
            final /* synthetic */ File $sessionAliveFlagFile;

            @Nullable
            public final CompileServiceSession invoke() {
                return KotlinCompilerClient.INSTANCE.connectAndLease(this.$compilerId, this.$clientAliveFlagFile, this.$daemonJVMOptions, this.$daemonOptions, this.$daemonReportingTargets, true, true, this.$sessionAliveFlagFile);
            }
            {
                this.$compilerId = compilerId;
                this.$clientAliveFlagFile = file;
                this.$daemonJVMOptions = daemonJVMOptions;
                this.$daemonOptions = daemonOptions;
                this.$daemonReportingTargets = daemonReportingTargets;
                this.$sessionAliveFlagFile = file2;
                super(0);
            }
        });
        if (connection2 == null || isDebugEnabled) {
            for (DaemonReportMessage message : daemonReportMessages) {
                CompilerMessageSeverity compilerMessageSeverity;
                switch (KotlinCompilerRunnerUtils$WhenMappings.$EnumSwitchMapping$0[message.getCategory().ordinal()]) {
                    case 1: {
                        compilerMessageSeverity = CompilerMessageSeverity.INFO;
                        break;
                    }
                    case 2: {
                        compilerMessageSeverity = CompilerMessageSeverity.INFO;
                        break;
                    }
                    case 3: {
                        compilerMessageSeverity = CompilerMessageSeverity.EXCEPTION;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                CompilerMessageSeverity severity = compilerMessageSeverity;
                MessageCollector.DefaultImpls.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)severity, (String)message.getMessage(), null, (int)4, null);
            }
        }
        newDaemonConnection.1 reportTotalAndThreadPerf$ = newDaemonConnection.1.INSTANCE;
        reportTotalAndThreadPerf$.invoke("Daemon connect", daemonOptions, MessageCollector.Companion.getNONE(), profiler);
        return connection2;
    }

    @JvmStatic
    @Nullable
    public static /* synthetic */ CompileServiceSession newDaemonConnection$default(CompilerId compilerId, File file, File file2, MessageCollector messageCollector, boolean bl, DaemonOptions daemonOptions, String[] stringArray, int n, Object object) {
        if ((n & 0x20) != 0) {
            daemonOptions = DaemonParamsKt.configureDaemonOptions();
        }
        if ((n & 0x40) != 0) {
            stringArray = new String[]{};
        }
        return KotlinCompilerRunnerUtils.newDaemonConnection(compilerId, file, file2, messageCollector, bl, daemonOptions, stringArray);
    }

    private KotlinCompilerRunnerUtils() {
    }

    static {
        KotlinCompilerRunnerUtils kotlinCompilerRunnerUtils;
        INSTANCE = kotlinCompilerRunnerUtils = new KotlinCompilerRunnerUtils();
    }
}

