/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.objectTree.ObjectTree;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ObjectNode<T> {
    private static final ObjectNode[] EMPTY_ARRAY = new ObjectNode[0];
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.objectTree.ObjectNode");
    private final ObjectTree<T> myTree;
    private ObjectNode<T> myParent;
    private final T myObject;
    private List<ObjectNode<T>> myChildren;
    private final Throwable myTrace;
    private final long myOwnModification;

    ObjectNode(@NotNull ObjectTree<T> tree, @Nullable ObjectNode<T> parentNode, @NotNull T object, long modification) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/openapi/util/objectTree/ObjectNode", "<init>"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/openapi/util/objectTree/ObjectNode", "<init>"));
        }
        this.myTree = tree;
        this.myParent = parentNode;
        this.myObject = object;
        this.myTrace = Disposer.isDebugMode() ? ThrowableInterner.intern(new Throwable()) : null;
        this.myOwnModification = modification;
    }

    @NotNull
    private ObjectNode<T>[] getChildrenArray() {
        List<ObjectNode<ObjectNode>> children = this.myChildren;
        if (children == null || children.isEmpty()) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/objectTree/ObjectNode", "getChildrenArray"));
            }
            return EMPTY_ARRAY;
        }
        ObjectNode[] objectNodeArray = children.toArray(new ObjectNode[children.size()]);
        if (objectNodeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/objectTree/ObjectNode", "getChildrenArray"));
        }
        return objectNodeArray;
    }

    void addChild(@NotNull ObjectNode<T> child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/openapi/util/objectTree/ObjectNode", "addChild"));
        }
        List<ObjectNode<T>> children = this.myChildren;
        if (children == null) {
            this.myChildren = new SmartList<ObjectNode<T>>(child);
        } else {
            children.add(child);
        }
        child.myParent = this;
    }

    void removeChild(@NotNull ObjectNode<T> child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/openapi/util/objectTree/ObjectNode", "removeChild"));
        }
        List<ObjectNode<T>> children = this.myChildren;
        if (children != null) {
            for (int i = children.size() - 1; i >= 0; --i) {
                ObjectNode<T> node = children.get(i);
                if (!node.equals(child)) continue;
                children.remove(i);
                break;
            }
        }
        child.myParent = null;
    }

    ObjectNode<T> getParent() {
        return this.myParent;
    }

    void execute(final @NotNull ObjectTreeAction<T> action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/util/objectTree/ObjectNode", "execute"));
        }
        ObjectTree.executeActionWithRecursiveGuard(this, this.myTree.getNodesInExecution(), new ObjectTreeAction<ObjectNode<T>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(@NotNull ObjectNode<T> each) {
                ObjectNode[] childrenArray;
                if (each == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/openapi/util/objectTree/ObjectNode$1", "execute"));
                }
                try {
                    action.beforeTreeExecution(ObjectNode.this.myObject);
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
                Object object = ((ObjectNode)ObjectNode.this).myTree.treeLock;
                synchronized (object) {
                    childrenArray = ObjectNode.this.getChildrenArray();
                }
                for (int i = childrenArray.length - 1; i >= 0; --i) {
                    childrenArray[i].execute(action);
                }
                Object i = ((ObjectNode)ObjectNode.this).myTree.treeLock;
                synchronized (i) {
                    ObjectNode.this.myChildren = null;
                }
                try {
                    action.execute(ObjectNode.this.myObject);
                    ObjectNode.this.myTree.fireExecuted(ObjectNode.this.myObject);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
                ObjectNode.this.remove();
            }

            @Override
            public void beforeTreeExecution(@NotNull ObjectNode<T> parent2) {
                if (parent2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/util/objectTree/ObjectNode$1", "beforeTreeExecution"));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove() {
        Object object = this.myTree.treeLock;
        synchronized (object) {
            this.myTree.putNode(this.myObject, null);
            if (this.myParent == null) {
                this.myTree.removeRootObject(this.myObject);
            } else {
                this.myParent.removeChild(this);
            }
        }
    }

    @NotNull
    T getObject() {
        T t = this.myObject;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/objectTree/ObjectNode", "getObject"));
        }
        return t;
    }

    @NonNls
    public String toString() {
        return "Node: " + this.myObject;
    }
}

