/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.foundation;

import com.intellij.ui.mac.foundation.FoundationLibrary;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.containers.HashMap;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class Foundation {
    private static final FoundationLibrary myFoundationLibrary;
    private static final Map<String, Object> ourMainThreadRunnables;
    private static long ourCurrentRunnableCount;
    private static final Object RUNNABLE_LOCK;

    public static ID getObjcClass(String className2) {
        return myFoundationLibrary.objc_getClass(className2);
    }

    public static Pointer createSelector(String s) {
        return myFoundationLibrary.sel_registerName(s);
    }

    public static ID invoke(ID id, Pointer selector, Object ... args) {
        return myFoundationLibrary.objc_msgSend(id, selector, args);
    }

    public static ID invoke(String cls, String selector, Object ... args) {
        return Foundation.invoke(Foundation.getObjcClass(cls), Foundation.createSelector(selector), args);
    }

    public static ID invoke(ID id, String selector, Object ... args) {
        return Foundation.invoke(id, Foundation.createSelector(selector), args);
    }

    public static ID nsString(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/ui/mac/foundation/Foundation", "nsString"));
        }
        try {
            if (s.isEmpty()) {
                return Foundation.invoke("NSString", "string", new Object[0]);
            }
            byte[] utf16Bytes = s.getBytes("UTF-16LE");
            return Foundation.invoke(Foundation.invoke(Foundation.invoke("NSString", "alloc", new Object[0]), "initWithBytes:length:encoding:", utf16Bytes, utf16Bytes.length, Foundation.convertCFEncodingToNS(0x14000100L)), "autorelease", new Object[0]);
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException(x);
        }
    }

    private static long convertCFEncodingToNS(long cfEncoding) {
        return myFoundationLibrary.CFStringConvertEncodingToNSStringEncoding(cfEncoding) & 0xFFFFFFFFFFL;
    }

    public static void cfRetain(ID id) {
        myFoundationLibrary.CFRetain(id);
    }

    public static void cfRelease(ID ... ids) {
        for (ID id : ids) {
            if (id == null) continue;
            myFoundationLibrary.CFRelease(id);
        }
    }

    static {
        System.setProperty("jna.encoding", "UTF8");
        HashMap foundationOptions = new HashMap();
        myFoundationLibrary = (FoundationLibrary)Native.loadLibrary("Foundation", FoundationLibrary.class, foundationOptions);
        ourMainThreadRunnables = new HashMap<String, Object>();
        ourCurrentRunnableCount = 0L;
        RUNNABLE_LOCK = new Object();
    }
}

