/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.context;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.FunctionReader;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH$J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0011H$J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/inline/context/FunctionContext;", "", "functionReader", "Lorg/jetbrains/kotlin/js/inline/FunctionReader;", "(Lorg/jetbrains/kotlin/js/inline/FunctionReader;)V", "getFunctionDefinition", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "call", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "getFunctionDefinitionImpl", "hasFunctionDefinition", "", "lookUpStaticFunction", "functionName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "lookUpStaticFunctionByTag", "functionTag", "", "tryExtractCallableReference", "invocation", "kotlin-compiler"})
public abstract class FunctionContext {
    private final FunctionReader functionReader;

    @Nullable
    protected abstract JsFunction lookUpStaticFunction(@Nullable JsName var1);

    @Nullable
    protected abstract JsFunction lookUpStaticFunctionByTag(@NotNull String var1);

    @NotNull
    public final JsFunction getFunctionDefinition(@NotNull JsInvocation call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        JsFunction jsFunction = this.getFunctionDefinitionImpl(call2);
        if (jsFunction == null) {
            Intrinsics.throwNpe();
        }
        return jsFunction;
    }

    public final boolean hasFunctionDefinition(@NotNull JsInvocation call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        return this.getFunctionDefinitionImpl(call2) != null;
    }

    private final JsFunction getFunctionDefinitionImpl(JsInvocation call2) {
        JsFunction jsFunction;
        JsExpression qualifier;
        JsExpression jsExpression;
        CallableDescriptor descriptor2 = MetadataProperties.getDescriptor(call2);
        if (descriptor2 != null) {
            if (this.functionReader.contains(descriptor2)) {
                return this.functionReader.get(descriptor2);
            }
            String string = Namer.getFunctionTag(descriptor2);
            Intrinsics.checkExpressionValueIsNotNull(string, "Namer.getFunctionTag(descriptor)");
            JsFunction jsFunction2 = this.lookUpStaticFunctionByTag(string);
            if (jsFunction2 != null) {
                JsFunction jsFunction3;
                JsFunction it = jsFunction3 = jsFunction2;
                return it;
            }
        }
        if (InvocationUtilsKt.isCallInvocation(call2)) {
            JsExpression jsExpression2 = call2.getQualifier();
            if (jsExpression2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsNameRef");
            }
            JsExpression jsExpression3 = ((JsNameRef)jsExpression2).getQualifier();
            if (jsExpression3 == null) {
                Intrinsics.throwNpe();
            }
            jsExpression = jsExpression3;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression3, "(call.qualifier as JsNameRef).qualifier!!");
        } else {
            JsExpression jsExpression4 = call2.getQualifier();
            jsExpression = jsExpression4;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression4, "call.qualifier");
        }
        JsExpression callQualifier = jsExpression;
        JsExpression jsExpression5 = qualifier = InvocationUtilsKt.getTransitiveStaticRef(callQualifier);
        if (jsExpression5 instanceof JsInvocation) {
            jsFunction = this.tryExtractCallableReference((JsInvocation)qualifier);
            if (jsFunction == null) {
                JsName jsName = InvocationUtilsKt.getSimpleName((JsInvocation)qualifier);
                if (jsName != null) {
                    JsFunction jsFunction4;
                    JsFunction it;
                    JsName jsName2;
                    JsName simpleName2 = jsName2 = jsName;
                    JsFunction jsFunction5 = this.lookUpStaticFunction(simpleName2);
                    jsFunction = jsFunction5 != null ? (FunctionUtilsKt.isFunctionCreator(it = (jsFunction4 = jsFunction5)) ? it : null) : null;
                } else {
                    jsFunction = null;
                }
            }
        } else {
            jsFunction = jsExpression5 instanceof JsNameRef ? this.lookUpStaticFunction(((JsNameRef)qualifier).getName()) : (jsExpression5 instanceof JsFunction ? (JsFunction)qualifier : null);
        }
        return jsFunction;
    }

    private final JsFunction tryExtractCallableReference(JsInvocation invocation) {
        JsExpression arg;
        if (MetadataProperties.isCallableReference(invocation) && (arg = invocation.getArguments().get(1)) instanceof JsFunction) {
            return (JsFunction)arg;
        }
        return null;
    }

    public FunctionContext(@NotNull FunctionReader functionReader) {
        Intrinsics.checkParameterIsNotNull(functionReader, "functionReader");
        this.functionReader = functionReader;
    }
}

