/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.util.OperatorNameConventions;

class InlineChecker
implements CallChecker {
    private final FunctionDescriptor descriptor;
    private final Set<CallableDescriptor> inlinableParameters;
    private final EffectiveVisibility inlineFunEffectiveVisibility;
    private final boolean isEffectivelyPrivateApiFunction;

    public InlineChecker(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            InlineChecker.$$$reportNull$$$0(0);
        }
        this.inlinableParameters = new LinkedHashSet<CallableDescriptor>();
        assert (InlineUtil.isInline(descriptor2)) : "This extension should be created only for inline functions: " + descriptor2;
        this.descriptor = descriptor2;
        this.inlineFunEffectiveVisibility = EffectiveVisibilityKt.effectiveVisibility(descriptor2, descriptor2.getVisibility(), true);
        this.isEffectivelyPrivateApiFunction = DescriptorUtilsKt.isEffectivelyPrivateApi(descriptor2);
        for (ValueParameterDescriptor param : descriptor2.getValueParameters()) {
            if (!InlineChecker.isInlinableParameter(param)) continue;
            this.inlinableParameters.add(param);
        }
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        KtExpression expression2;
        if (resolvedCall2 == null) {
            InlineChecker.$$$reportNull$$$0(1);
        }
        if (reportOn == null) {
            InlineChecker.$$$reportNull$$$0(2);
        }
        if (context == null) {
            InlineChecker.$$$reportNull$$$0(3);
        }
        if ((expression2 = resolvedCall2.getCall().getCalleeExpression()) == null) {
            return;
        }
        Object targetDescriptor = resolvedCall2.getResultingDescriptor();
        this.checkCallWithReceiver(context, (CallableDescriptor)targetDescriptor, resolvedCall2.getDispatchReceiver(), expression2);
        this.checkCallWithReceiver(context, (CallableDescriptor)targetDescriptor, resolvedCall2.getExtensionReceiver(), expression2);
        if (this.inlinableParameters.contains(targetDescriptor) && !InlineChecker.isInsideCall(expression2)) {
            context.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on(expression2, expression2, this.descriptor));
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : resolvedCall2.getValueArguments().entrySet()) {
            ResolvedValueArgument value = entry.getValue();
            ValueParameterDescriptor valueDescriptor = entry.getKey();
            if (value instanceof DefaultValueArgument) continue;
            for (ValueArgument argument : value.getArguments()) {
                this.checkValueParameter(context, (CallableDescriptor)targetDescriptor, argument, valueDescriptor);
            }
        }
        this.checkVisibilityAndAccess((CallableDescriptor)targetDescriptor, expression2, context);
        this.checkRecursion(context, (CallableDescriptor)targetDescriptor, expression2);
    }

    private static boolean isInsideCall(KtExpression expression2) {
        KtToken token;
        KtExpression parent2 = KtPsiUtil.getParentCallIfPresent(expression2);
        if (parent2 instanceof KtBinaryExpression && ((token = KtPsiUtil.getOperationToken((KtOperationExpression)parent2)) == KtTokens.EQ || token == KtTokens.ANDAND || token == KtTokens.OROR)) {
            return false;
        }
        if (parent2 != null) {
            for (PsiElement current = expression2; current != parent2; current = current.getParent()) {
                if (!(current instanceof KtBinaryExpressionWithTypeRHS)) continue;
                return false;
            }
        }
        return parent2 != null;
    }

    private void checkValueParameter(@NotNull CallCheckerContext context, @NotNull CallableDescriptor targetDescriptor, @NotNull ValueArgument targetArgument, @NotNull ValueParameterDescriptor targetParameterDescriptor) {
        KtExpression argumentExpression;
        if (context == null) {
            InlineChecker.$$$reportNull$$$0(4);
        }
        if (targetDescriptor == null) {
            InlineChecker.$$$reportNull$$$0(5);
        }
        if (targetArgument == null) {
            InlineChecker.$$$reportNull$$$0(6);
        }
        if (targetParameterDescriptor == null) {
            InlineChecker.$$$reportNull$$$0(7);
        }
        if ((argumentExpression = targetArgument.getArgumentExpression()) == null) {
            return;
        }
        CallableDescriptor argumentCallee = InlineChecker.getCalleeDescriptor(context, argumentExpression, false);
        if (argumentCallee != null && this.inlinableParameters.contains(argumentCallee)) {
            if (InlineUtil.isInline(targetDescriptor) && InlineChecker.isInlinableParameter(targetParameterDescriptor)) {
                if (InlineUtil.allowsNonLocalReturns(argumentCallee) && !InlineUtil.allowsNonLocalReturns(targetParameterDescriptor)) {
                    context.getTrace().report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on(argumentExpression, argumentExpression));
                } else {
                    this.checkNonLocalReturn(context, argumentCallee, argumentExpression);
                }
            } else {
                context.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on(argumentExpression, argumentExpression, this.descriptor));
            }
        }
    }

    private void checkCallWithReceiver(@NotNull CallCheckerContext context, @NotNull CallableDescriptor targetDescriptor, @Nullable ReceiverValue receiver, @Nullable KtExpression expression2) {
        if (context == null) {
            InlineChecker.$$$reportNull$$$0(8);
        }
        if (targetDescriptor == null) {
            InlineChecker.$$$reportNull$$$0(9);
        }
        if (receiver == null) {
            return;
        }
        CallableDescriptor varDescriptor = null;
        KtExpression receiverExpression = null;
        if (receiver instanceof ExpressionReceiver) {
            receiverExpression = ((ExpressionReceiver)receiver).getExpression();
            varDescriptor = InlineChecker.getCalleeDescriptor(context, receiverExpression, true);
        } else if (receiver instanceof ExtensionReceiver) {
            ExtensionReceiver extensionReceiver = (ExtensionReceiver)receiver;
            CallableDescriptor extension = extensionReceiver.getDeclarationDescriptor();
            varDescriptor = extension.getExtensionReceiverParameter();
            assert (varDescriptor != null) : "Extension should have receiverParameterDescriptor: " + extension;
            receiverExpression = expression2;
        }
        if (this.inlinableParameters.contains(varDescriptor)) {
            this.checkLambdaInvokeOrExtensionCall(context, varDescriptor, targetDescriptor, receiverExpression);
        }
    }

    @Nullable
    private static CallableDescriptor getCalleeDescriptor(@NotNull CallCheckerContext context, @NotNull KtExpression expression2, boolean unwrapVariableAsFunction) {
        if (context == null) {
            InlineChecker.$$$reportNull$$$0(10);
        }
        if (expression2 == null) {
            InlineChecker.$$$reportNull$$$0(11);
        }
        if (!(expression2 instanceof KtSimpleNameExpression) && !(expression2 instanceof KtThisExpression)) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> thisCall = CallUtilKt.getResolvedCall(expression2, context.getTrace().getBindingContext());
        if (unwrapVariableAsFunction && thisCall instanceof VariableAsFunctionResolvedCall) {
            return ((VariableAsFunctionResolvedCall)((Object)thisCall)).getVariableCall().getResultingDescriptor();
        }
        return thisCall != null ? thisCall.getResultingDescriptor() : null;
    }

    private void checkLambdaInvokeOrExtensionCall(@NotNull CallCheckerContext context, @NotNull CallableDescriptor lambdaDescriptor, @NotNull CallableDescriptor callDescriptor, @NotNull KtExpression receiverExpression) {
        boolean inlinableCall;
        if (context == null) {
            InlineChecker.$$$reportNull$$$0(12);
        }
        if (lambdaDescriptor == null) {
            InlineChecker.$$$reportNull$$$0(13);
        }
        if (callDescriptor == null) {
            InlineChecker.$$$reportNull$$$0(14);
        }
        if (receiverExpression == null) {
            InlineChecker.$$$reportNull$$$0(15);
        }
        if (!(inlinableCall = InlineChecker.isInvokeOrInlineExtension(callDescriptor))) {
            context.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on(receiverExpression, receiverExpression, this.descriptor));
        } else {
            this.checkNonLocalReturn(context, lambdaDescriptor, receiverExpression);
        }
    }

    private void checkRecursion(@NotNull CallCheckerContext context, @NotNull CallableDescriptor targetDescriptor, @NotNull KtElement expression2) {
        if (context == null) {
            InlineChecker.$$$reportNull$$$0(16);
        }
        if (targetDescriptor == null) {
            InlineChecker.$$$reportNull$$$0(17);
        }
        if (expression2 == null) {
            InlineChecker.$$$reportNull$$$0(18);
        }
        if (targetDescriptor.getOriginal() == this.descriptor) {
            context.getTrace().report(Errors.RECURSION_IN_INLINE.on(expression2, expression2, this.descriptor));
        }
    }

    private static boolean isInlinableParameter(@NotNull ParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            InlineChecker.$$$reportNull$$$0(19);
        }
        return InlineUtil.isInlineLambdaParameter(descriptor2) && !descriptor2.getType().isMarkedNullable();
    }

    private static boolean isInvokeOrInlineExtension(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            InlineChecker.$$$reportNull$$$0(20);
        }
        if (!(descriptor2 instanceof SimpleFunctionDescriptor)) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        boolean isInvoke = descriptor2.getName().equals(OperatorNameConventions.INVOKE) && containingDeclaration instanceof ClassDescriptor && FunctionTypesKt.isFunctionType(((ClassDescriptor)containingDeclaration).getDefaultType());
        return isInvoke || InlineUtil.isInline(descriptor2);
    }

    private void checkVisibilityAndAccess(@NotNull CallableDescriptor calledDescriptor, @NotNull KtElement expression2, @NotNull CallCheckerContext context) {
        if (calledDescriptor == null) {
            InlineChecker.$$$reportNull$$$0(21);
        }
        if (expression2 == null) {
            InlineChecker.$$$reportNull$$$0(22);
        }
        if (context == null) {
            InlineChecker.$$$reportNull$$$0(23);
        }
        EffectiveVisibility.Public calledFunEffectiveVisibility = this.isDefinedInInlineFunction(calledDescriptor) ? EffectiveVisibility.Public.INSTANCE : EffectiveVisibilityKt.effectiveVisibility(calledDescriptor, calledDescriptor.getVisibility(), true);
        boolean isCalledFunPublicOrPublishedApi = calledFunEffectiveVisibility.getPublicApi();
        boolean isInlineFunPublicOrPublishedApi = this.inlineFunEffectiveVisibility.getPublicApi();
        if (isInlineFunPublicOrPublishedApi && !isCalledFunPublicOrPublishedApi && calledDescriptor.getVisibility() != Visibilities.LOCAL) {
            context.getTrace().report(Errors.NON_PUBLIC_CALL_FROM_PUBLIC_INLINE.on(expression2, calledDescriptor, this.descriptor));
        } else {
            this.checkPrivateClassMemberAccess(calledDescriptor, expression2, context);
        }
        if (!(calledDescriptor instanceof ConstructorDescriptor) && isInlineFunPublicOrPublishedApi && this.inlineFunEffectiveVisibility.toVisibility() != Visibilities.PROTECTED && ((EffectiveVisibility)calledFunEffectiveVisibility).toVisibility() == Visibilities.PROTECTED) {
            context.getTrace().report(Errors.PROTECTED_CALL_FROM_PUBLIC_INLINE.on(expression2, calledDescriptor));
        }
    }

    private void checkPrivateClassMemberAccess(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull KtElement expression2, @NotNull CallCheckerContext context) {
        if (declarationDescriptor == null) {
            InlineChecker.$$$reportNull$$$0(24);
        }
        if (expression2 == null) {
            InlineChecker.$$$reportNull$$$0(25);
        }
        if (context == null) {
            InlineChecker.$$$reportNull$$$0(26);
        }
        if (!this.isEffectivelyPrivateApiFunction && DescriptorUtilsKt.isInsidePrivateClass(declarationDescriptor)) {
            context.getTrace().report(Errors.PRIVATE_CLASS_MEMBER_FROM_INLINE.on(expression2, declarationDescriptor, this.descriptor));
        }
    }

    private boolean isDefinedInInlineFunction(@NotNull DeclarationDescriptorWithVisibility startDescriptor) {
        if (startDescriptor == null) {
            InlineChecker.$$$reportNull$$$0(27);
        }
        DeclarationDescriptorWithVisibility parent2 = startDescriptor;
        while (parent2 != null) {
            if (parent2.getContainingDeclaration() == this.descriptor) {
                return true;
            }
            parent2 = DescriptorUtils.getParentOfType(parent2, DeclarationDescriptorWithVisibility.class);
        }
        return false;
    }

    private void checkNonLocalReturn(@NotNull CallCheckerContext context, @NotNull CallableDescriptor inlinableParameterDescriptor, @NotNull KtExpression parameterUsage) {
        if (context == null) {
            InlineChecker.$$$reportNull$$$0(28);
        }
        if (inlinableParameterDescriptor == null) {
            InlineChecker.$$$reportNull$$$0(29);
        }
        if (parameterUsage == null) {
            InlineChecker.$$$reportNull$$$0(30);
        }
        if (!InlineUtil.allowsNonLocalReturns(inlinableParameterDescriptor)) {
            return;
        }
        if (!InlineUtil.checkNonLocalReturnUsage(this.descriptor, parameterUsage, context.getResolutionContext())) {
            context.getTrace().report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on(parameterUsage, parameterUsage));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportOn";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 23: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDescriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetArgument";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetParameterDescriptor";
                break;
            }
            case 11: 
            case 18: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaDescriptor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callDescriptor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverExpression";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calledDescriptor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationDescriptor";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startDescriptor";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlinableParameterDescriptor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterUsage";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "check";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkValueParameter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCallWithReceiver";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getCalleeDescriptor";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "checkLambdaInvokeOrExtensionCall";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRecursion";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "isInlinableParameter";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "isInvokeOrInlineExtension";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "checkVisibilityAndAccess";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPrivateClassMemberAccess";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "isDefinedInInlineFunction";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNonLocalReturn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

