/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerConfiguration;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.KaptExecution;
import org.jetbrains.kotlin.gradle.internal.KaptOptionsForWorker;
import org.jetbrains.kotlin.gradle.internal.KaptPathsForWorker;
import org.jetbrains.kotlin.gradle.internal.KaptTask;
import org.jetbrains.kotlin.gradle.tasks.JarSearchingUtilKt;
import org.jetbrains.kotlin.gradle.tasks.TasksUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010&\u001a\u00020'H\u0007R\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00068\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001c\u0010\u0010\u001a\u00020\u00118\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0012\"\u0004\b\u0013\u0010\u0014R(\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00168\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u00020\u00118\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u0014R(\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00168\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0018\"\u0004\b \u0010\u001aR\u001c\u0010!\u001a\u00020\u00078\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/gradle/internal/KaptWithoutKotlincTask;", "Lorg/jetbrains/kotlin/gradle/internal/KaptTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "annotationProcessingJars", "", "Ljava/io/File;", "getAnnotationProcessingJars", "()Ljava/util/List;", "setAnnotationProcessingJars", "(Ljava/util/List;)V", "annotationProcessorFqNames", "", "getAnnotationProcessorFqNames", "setAnnotationProcessorFqNames", "isVerbose", "", "()Z", "setVerbose", "(Z)V", "javacOptions", "", "getJavacOptions", "()Ljava/util/Map;", "setJavacOptions", "(Ljava/util/Map;)V", "mapDiagnosticLocations", "getMapDiagnosticLocations", "setMapDiagnosticLocations", "processorOptions", "getProcessorOptions", "setProcessorOptions", "projectDir", "getProjectDir", "()Ljava/io/File;", "setProjectDir", "(Ljava/io/File;)V", "compile", "", "kotlin-gradle-plugin"})
public class KaptWithoutKotlincTask
extends KaptTask {
    @NotNull
    public List<? extends File> annotationProcessingJars;
    @NotNull
    public File projectDir;
    private boolean isVerbose;
    private boolean mapDiagnosticLocations;
    @NotNull
    public List<String> annotationProcessorFqNames;
    @NotNull
    public Map<String, String> processorOptions;
    @NotNull
    public Map<String, String> javacOptions;
    private final WorkerExecutor workerExecutor;

    @InputFiles
    @Classpath
    @NotNull
    public final List<File> getAnnotationProcessingJars() {
        List<File> list = this.annotationProcessingJars;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationProcessingJars");
        }
        return list;
    }

    public final void setAnnotationProcessingJars(@NotNull List<? extends File> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.annotationProcessingJars = list;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final File getProjectDir() {
        File file = this.projectDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectDir");
        }
        return file;
    }

    public final void setProjectDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.projectDir = file;
    }

    @Input
    public final boolean isVerbose() {
        return this.isVerbose;
    }

    public final void setVerbose(boolean bl) {
        this.isVerbose = bl;
    }

    @Input
    public final boolean getMapDiagnosticLocations() {
        return this.mapDiagnosticLocations;
    }

    public final void setMapDiagnosticLocations(boolean bl) {
        this.mapDiagnosticLocations = bl;
    }

    @Input
    @NotNull
    public final List<String> getAnnotationProcessorFqNames() {
        List<String> list = this.annotationProcessorFqNames;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationProcessorFqNames");
        }
        return list;
    }

    public final void setAnnotationProcessorFqNames(@NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.annotationProcessorFqNames = list;
    }

    @Input
    @NotNull
    public final Map<String, String> getProcessorOptions() {
        Map<String, String> map = this.processorOptions;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"processorOptions");
        }
        return map;
    }

    public final void setProcessorOptions(@NotNull Map<String, String> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        this.processorOptions = map;
    }

    @Input
    @NotNull
    public final Map<String, String> getJavacOptions() {
        Map<String, String> map = this.javacOptions;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javacOptions");
        }
        return map;
    }

    public final void setJavacOptions(@NotNull Map<String, String> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        this.javacOptions = map;
    }

    @TaskAction
    public final void compile() {
        this.getLogger().info("Running kapt annotation processing using the Gradle Worker API");
        TasksUtilsKt.clearOutputDirectories$default((Task)this, null, 1, null);
        File file = this.projectDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectDir");
        }
        Set set = this.getClasspath().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"classpath.files");
        List list = CollectionsKt.toList((Iterable)set);
        Set set2 = this.getKaptClasspath().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"kaptClasspath.files");
        KaptPathsForWorker paths = new KaptPathsForWorker(file, list, CollectionsKt.toList((Iterable)set2), CollectionsKt.toList((Iterable)this.getJavaSourceRoots()), this.getDestinationDir(), this.getClassesDir$kotlin_gradle_plugin(), this.getStubsDir$kotlin_gradle_plugin());
        List<String> list2 = this.annotationProcessorFqNames;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationProcessorFqNames");
        }
        Map<String, String> map = this.processorOptions;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"processorOptions");
        }
        Map<String, String> map2 = this.javacOptions;
        if (map2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javacOptions");
        }
        KaptOptionsForWorker options = new KaptOptionsForWorker(this.isVerbose, this.mapDiagnosticLocations, list2, map, map2);
        List<? extends File> list3 = this.annotationProcessingJars;
        if (list3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationProcessingJars");
        }
        Collection collection = list3;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        List kaptClasspath = CollectionsKt.plus((Collection)collection, (Iterable)JarSearchingUtilKt.findKotlinStdlibClasspath(project));
        this.workerExecutor.submit(KaptExecution.class, (Action)new Action<WorkerConfiguration>(this, options, paths, kaptClasspath){
            final /* synthetic */ KaptWithoutKotlincTask this$0;
            final /* synthetic */ KaptOptionsForWorker $options;
            final /* synthetic */ KaptPathsForWorker $paths;
            final /* synthetic */ List $kaptClasspath;

            public final void execute(WorkerConfiguration config) {
                WorkerConfiguration workerConfiguration = config;
                Intrinsics.checkExpressionValueIsNotNull((Object)workerConfiguration, (String)"config");
                workerConfiguration.setIsolationMode(IsolationMode.PROCESS);
                config.params(new Object[]{this.$options, this.$paths, JarSearchingUtilKt.findToolsJar(), this.$kaptClasspath});
                this.this$0.getLogger().info("Kapt worker classpath: " + config.getClasspath());
            }
            {
                this.this$0 = kaptWithoutKotlincTask;
                this.$options = kaptOptionsForWorker;
                this.$paths = kaptPathsForWorker;
                this.$kaptClasspath = list;
            }
        });
        this.workerExecutor.await();
    }

    @Inject
    public KaptWithoutKotlincTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
    }
}

