/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.FileUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0002H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0006*\u00020\u0002H\u0000\u001a\f\u0010\b\u001a\u00020\u0006*\u00020\u0002H\u0000\u001a\u001a\u0010\t\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\f\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\r\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a8\u0006\u0010"}, d2={"listClassFiles", "Lkotlin/sequences/Sequence;", "Ljava/io/File;", "path", "", "isClassFile", "", "isJavaFile", "isKotlinFile", "pathsAsStringRelativeTo", "", "base", "relativeOrCanonical", "relativeToRoot", "project", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin"})
public final class FileUtilsKt {
    public static final boolean isJavaFile(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.equals((String)FilesKt.getExtension((File)$receiver), (String)"java", (boolean)true);
    }

    public static final boolean isKotlinFile(@NotNull File $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String it = string = FilesKt.getExtension((File)$receiver);
        return StringsKt.equals((String)"kt", (String)it, (boolean)true) || StringsKt.equals((String)"kts", (String)it, (boolean)true);
    }

    public static final boolean isClassFile(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.equals((String)FilesKt.getExtension((File)$receiver), (String)"class", (boolean)true);
    }

    @NotNull
    public static final Sequence<File> listClassFiles(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)new File(path), null, (int)1, null)), (Function1)listClassFiles.1.INSTANCE);
    }

    @NotNull
    public static final String relativeOrCanonical(@NotNull File $receiver, @NotNull File base) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Object object = FilesKt.relativeToOrNull((File)$receiver, (File)base);
        if (object == null || (object = ((File)object).getPath()) == null) {
            String string = $receiver.getCanonicalPath();
            object = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"canonicalPath");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String pathsAsStringRelativeTo(@NotNull Iterable<? extends File> $receiver, @NotNull File base) {
        void $receiver$iv$iv;
        Iterable<? extends File> $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Iterable<? extends File> iterable = $receiver$iv = $receiver;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = FileUtilsKt.relativeOrCanonical((File)it, base);
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), null, null, null, (int)0, null, null, (int)63, null);
    }

    @NotNull
    public static final String relativeToRoot(@NotNull File $receiver, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Project project2 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
        File file = project2.getRootDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.rootProject.rootDir");
        return FileUtilsKt.relativeOrCanonical($receiver, file);
    }
}

