/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.gradle.plugin.LanguageSettingsBuilder;
import org.jetbrains.kotlin.gradle.plugin.sources.DefaultLanguageSettingsBuilder;
import org.jetbrains.kotlin.gradle.plugin.sources.DefaultLanguageSettingsBuilderKt;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinNativeCompile;
import org.jetbrains.kotlin.gradle.tasks.CompilerPluginOptions;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0004H\u0016J\u0010\u0010;\u001a\u0002092\u0006\u0010:\u001a\u00020\u0004H\u0016R(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001eR\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040\r8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u000fR(\u0010'\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\r\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R(\u0010-\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010\u0007\"\u0004\b/\u0010\tR\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\u000203X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/DefaultLanguageSettingsBuilder;", "Lorg/jetbrains/kotlin/gradle/plugin/LanguageSettingsBuilder;", "()V", "value", "", "apiVersion", "getApiVersion", "()Ljava/lang/String;", "setApiVersion", "(Ljava/lang/String;)V", "apiVersionImpl", "Lorg/jetbrains/kotlin/config/ApiVersion;", "compilerPluginArguments", "", "getCompilerPluginArguments", "()Ljava/util/List;", "compilerPluginClasspath", "Lorg/gradle/api/file/FileCollection;", "getCompilerPluginClasspath", "()Lorg/gradle/api/file/FileCollection;", "compilerPluginOptionsTask", "Lkotlin/Lazy;", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "getCompilerPluginOptionsTask", "()Lkotlin/Lazy;", "setCompilerPluginOptionsTask", "(Lkotlin/Lazy;)V", "enabledLanguageFeatures", "", "getEnabledLanguageFeatures", "()Ljava/util/Set;", "enabledLanguageFeaturesImpl", "", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "experimentalAnnotationsInUse", "getExperimentalAnnotationsInUse", "experimentalAnnotationsInUseImpl", "freeCompilerArgs", "getFreeCompilerArgs", "freeCompilerArgsProvider", "Lorg/gradle/api/provider/Provider;", "getFreeCompilerArgsProvider", "()Lorg/gradle/api/provider/Provider;", "setFreeCompilerArgsProvider", "(Lorg/gradle/api/provider/Provider;)V", "languageVersion", "getLanguageVersion", "setLanguageVersion", "languageVersionImpl", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "progressiveMode", "", "getProgressiveMode", "()Z", "setProgressiveMode", "(Z)V", "enableLanguageFeature", "", "name", "useExperimentalAnnotation", "kotlin-gradle-plugin"})
public final class DefaultLanguageSettingsBuilder
implements LanguageSettingsBuilder {
    private LanguageVersion languageVersionImpl;
    private ApiVersion apiVersionImpl;
    private boolean progressiveMode;
    private final Set<LanguageFeature> enabledLanguageFeaturesImpl;
    private final Set<String> experimentalAnnotationsInUseImpl;
    @NotNull
    private final Set<String> experimentalAnnotationsInUse;
    @NotNull
    private Lazy<? extends AbstractCompile> compilerPluginOptionsTask;
    @Nullable
    private Provider<List<String>> freeCompilerArgsProvider;

    @Nullable
    public String getLanguageVersion() {
        LanguageVersion languageVersion2 = this.languageVersionImpl;
        return languageVersion2 != null ? languageVersion2.getVersionString() : null;
    }

    public void setLanguageVersion(@Nullable String value) {
        LanguageVersion languageVersion2;
        DefaultLanguageSettingsBuilder defaultLanguageSettingsBuilder = this;
        String string = value;
        if (string != null) {
            String string2 = string;
            DefaultLanguageSettingsBuilder defaultLanguageSettingsBuilder2 = defaultLanguageSettingsBuilder;
            boolean bl = false;
            boolean bl2 = false;
            String versionString = string2;
            boolean bl3 = false;
            LanguageVersion languageVersion3 = LanguageVersion.Companion.fromVersionString(versionString);
            if (languageVersion3 == null) {
                throw (Throwable)new InvalidUserDataException("Incorrect language version. Expected one of: " + ArraysKt.joinToString$default((Object[])LanguageVersion.values(), null, null, null, (int)0, null, (Function1)languageVersion.1.1.INSTANCE, (int)31, null));
            }
            LanguageVersion languageVersion4 = languageVersion3;
            defaultLanguageSettingsBuilder = defaultLanguageSettingsBuilder2;
            languageVersion2 = languageVersion4;
        } else {
            languageVersion2 = null;
        }
        defaultLanguageSettingsBuilder.languageVersionImpl = languageVersion2;
    }

    @Nullable
    public String getApiVersion() {
        ApiVersion apiVersion2 = this.apiVersionImpl;
        return apiVersion2 != null ? apiVersion2.getVersionString() : null;
    }

    public void setApiVersion(@Nullable String value) {
        ApiVersion apiVersion2;
        DefaultLanguageSettingsBuilder defaultLanguageSettingsBuilder = this;
        String string = value;
        if (string != null) {
            String string2 = string;
            DefaultLanguageSettingsBuilder defaultLanguageSettingsBuilder2 = defaultLanguageSettingsBuilder;
            boolean bl = false;
            boolean bl2 = false;
            String versionString = string2;
            boolean bl3 = false;
            ApiVersion apiVersion3 = DefaultLanguageSettingsBuilderKt.parseApiVersionSettings(versionString);
            if (apiVersion3 == null) {
                throw (Throwable)new InvalidUserDataException("Incorrect API version. Expected one of: " + CollectionsKt.joinToString$default((Iterable)DefaultLanguageSettingsBuilderKt.access$getApiVersionValues$p(), null, null, null, (int)0, null, (Function1)apiVersion.1.1.INSTANCE, (int)31, null));
            }
            ApiVersion apiVersion4 = apiVersion3;
            defaultLanguageSettingsBuilder = defaultLanguageSettingsBuilder2;
            apiVersion2 = apiVersion4;
        } else {
            apiVersion2 = null;
        }
        defaultLanguageSettingsBuilder.apiVersionImpl = apiVersion2;
    }

    public boolean getProgressiveMode() {
        return this.progressiveMode;
    }

    public void setProgressiveMode(boolean bl) {
        this.progressiveMode = bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> getEnabledLanguageFeatures() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.enabledLanguageFeaturesImpl;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LanguageFeature languageFeature = (LanguageFeature)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.name();
            collection.add(string);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public void enableLanguageFeature(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        LanguageFeature languageFeature = DefaultLanguageSettingsBuilderKt.parseLanguageFeature(name);
        if (languageFeature == null) {
            throw (Throwable)new InvalidUserDataException("Unknown language feature '" + name + '\'');
        }
        LanguageFeature languageFeature2 = languageFeature;
        Collection collection = this.enabledLanguageFeaturesImpl;
        boolean bl = false;
        collection.add(languageFeature2);
    }

    @NotNull
    public Set<String> getExperimentalAnnotationsInUse() {
        return this.experimentalAnnotationsInUse;
    }

    public void useExperimentalAnnotation(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Collection collection = this.experimentalAnnotationsInUseImpl;
        boolean bl = false;
        collection.add(name);
    }

    @NotNull
    public final Lazy<AbstractCompile> getCompilerPluginOptionsTask() {
        return this.compilerPluginOptionsTask;
    }

    public final void setCompilerPluginOptionsTask(@NotNull Lazy<? extends AbstractCompile> lazy) {
        Intrinsics.checkParameterIsNotNull(lazy, (String)"<set-?>");
        this.compilerPluginOptionsTask = lazy;
    }

    @Nullable
    public final List<String> getCompilerPluginArguments() {
        CompilerPluginOptions compilerPluginOptions;
        AbstractCompile pluginOptionsTask;
        AbstractCompile abstractCompile = (AbstractCompile)this.compilerPluginOptionsTask.getValue();
        if (abstractCompile == null) {
            return null;
        }
        AbstractCompile abstractCompile2 = pluginOptionsTask = abstractCompile;
        if (abstractCompile2 instanceof AbstractKotlinCompile) {
            compilerPluginOptions = ((AbstractKotlinCompile)pluginOptionsTask).getPluginOptions$kotlin_gradle_plugin();
        } else if (abstractCompile2 instanceof AbstractKotlinNativeCompile) {
            compilerPluginOptions = ((AbstractKotlinNativeCompile)pluginOptionsTask).getCompilerPluginOptions();
        } else {
            String string = "Unexpected task: " + pluginOptionsTask;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return compilerPluginOptions.getArguments();
    }

    @Nullable
    public final FileCollection getCompilerPluginClasspath() {
        FileCollection fileCollection;
        AbstractCompile pluginClasspathTask;
        AbstractCompile abstractCompile = (AbstractCompile)this.compilerPluginOptionsTask.getValue();
        if (abstractCompile == null) {
            return null;
        }
        AbstractCompile abstractCompile2 = pluginClasspathTask = abstractCompile;
        if (abstractCompile2 instanceof AbstractKotlinCompile) {
            fileCollection = ((AbstractKotlinCompile)pluginClasspathTask).getPluginClasspath();
        } else if (abstractCompile2 instanceof AbstractKotlinNativeCompile) {
            fileCollection = ((AbstractKotlinNativeCompile)pluginClasspathTask).getCompilerPluginClasspath();
            if (fileCollection == null) {
                fileCollection = (FileCollection)((AbstractKotlinNativeCompile)pluginClasspathTask).getProject().files(new Object[0]);
            }
        } else {
            String string = "Unexpected task: " + pluginClasspathTask;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return fileCollection;
    }

    @Nullable
    public final Provider<List<String>> getFreeCompilerArgsProvider() {
        return this.freeCompilerArgsProvider;
    }

    public final void setFreeCompilerArgsProvider(@Nullable Provider<List<String>> provider) {
        this.freeCompilerArgsProvider = provider;
    }

    @NotNull
    public final List<String> getFreeCompilerArgs() {
        Provider<List<String>> provider = this.freeCompilerArgsProvider;
        List list2 = provider != null ? (List)provider.get() : null;
        boolean bl = false;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    public DefaultLanguageSettingsBuilder() {
        Set set2;
        DefaultLanguageSettingsBuilder defaultLanguageSettingsBuilder = this;
        boolean bl = false;
        defaultLanguageSettingsBuilder.enabledLanguageFeaturesImpl = set2 = (Set)new LinkedHashSet();
        defaultLanguageSettingsBuilder = this;
        bl = false;
        defaultLanguageSettingsBuilder.experimentalAnnotationsInUseImpl = set2 = (Set)new LinkedHashSet();
        this.experimentalAnnotationsInUse = this.experimentalAnnotationsInUseImpl;
        this.compilerPluginOptionsTask = LazyKt.lazyOf(null);
    }
}

