/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilationProcessor;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSetProcessor;
import org.jetbrains.kotlin.gradle.plugin.VariantImplementationFactories;
import org.jetbrains.kotlin.gradle.plugin.internal.JavaSourceSetsAccessor;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJvmCompilation;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinWithJavaCompilation;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.KotlinCompilationData;
import org.jetbrains.kotlin.gradle.targets.jvm.KotlinJvmTarget;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile;
import org.jetbrains.kotlin.gradle.tasks.KotlinTasksProvider;
import org.jetbrains.kotlin.gradle.tasks.TasksProviderKt;
import org.jetbrains.kotlin.gradle.tasks.configuration.AbstractKotlinCompileConfig;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010\u001f\u001a\u00020\u001e2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!H\u0004J\b\u0010\"\u001a\u00020\u001eH\u0002J \u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00102\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0007H$J\b\u0010'\u001a\u00020\u001eH$J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0010H\u0002J\b\u0010-\u001a\u00020\u001eH\u0016R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSetProcessor;", "T", "Lorg/jetbrains/kotlin/gradle/tasks/AbstractKotlinCompile;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilationProcessor;", "tasksProvider", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinTasksProvider;", "taskDescription", "", "kotlinCompilation", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/pm20/KotlinCompilationData;", "(Lorg/jetbrains/kotlin/gradle/tasks/KotlinTasksProvider;Ljava/lang/String;Lorg/jetbrains/kotlin/gradle/plugin/mpp/pm20/KotlinCompilationData;)V", "javaSourceSet", "Lorg/gradle/api/tasks/SourceSet;", "getJavaSourceSet", "()Lorg/gradle/api/tasks/SourceSet;", "kotlinTask", "Lorg/gradle/api/tasks/TaskProvider;", "getKotlinTask", "()Lorg/gradle/api/tasks/TaskProvider;", "logger", "Lorg/gradle/api/logging/Logger;", "getLogger", "()Lorg/gradle/api/logging/Logger;", "sourceSetName", "getSourceSetName", "()Ljava/lang/String;", "getTaskDescription", "getTasksProvider", "()Lorg/jetbrains/kotlin/gradle/tasks/KotlinTasksProvider;", "addKotlinDirectoriesToJavaSourceSet", "", "applyStandardTaskConfiguration", "taskConfiguration", "Lorg/jetbrains/kotlin/gradle/tasks/configuration/AbstractKotlinCompileConfig;", "createAdditionalClassesTaskForIdeRunner", "doRegisterTask", "project", "Lorg/gradle/api/Project;", "taskName", "doTargetSpecificProcessing", "filterOutJavaSrcDirsIfPossible", "Lorg/gradle/api/file/FileCollection;", "sourceDirectories", "Lorg/gradle/api/file/SourceDirectorySet;", "prepareKotlinCompileTask", "run", "kotlin-gradle-plugin_common"})
public abstract class KotlinSourceSetProcessor<T extends AbstractKotlinCompile<?>>
extends KotlinCompilationProcessor<T> {
    @NotNull
    private final KotlinTasksProvider tasksProvider;
    @NotNull
    private final String taskDescription;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String sourceSetName;
    @NotNull
    private final TaskProvider<? extends T> kotlinTask;

    public KotlinSourceSetProcessor(@NotNull KotlinTasksProvider tasksProvider, @NotNull String taskDescription, @NotNull KotlinCompilationData<?> kotlinCompilation) {
        Intrinsics.checkNotNullParameter((Object)tasksProvider, (String)"tasksProvider");
        Intrinsics.checkNotNullParameter((Object)taskDescription, (String)"taskDescription");
        Intrinsics.checkNotNullParameter(kotlinCompilation, (String)"kotlinCompilation");
        super(kotlinCompilation);
        this.tasksProvider = tasksProvider;
        this.taskDescription = taskDescription;
        Logger logger = Logging.getLogger(this.getClass());
        Intrinsics.checkNotNull((Object)logger);
        this.logger = logger;
        this.sourceSetName = kotlinCompilation.getCompilationPurpose();
        this.kotlinTask = this.prepareKotlinCompileTask();
    }

    @NotNull
    public final KotlinTasksProvider getTasksProvider() {
        return this.tasksProvider;
    }

    @NotNull
    public final String getTaskDescription() {
        return this.taskDescription;
    }

    protected abstract void doTargetSpecificProcessing();

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    protected final String getSourceSetName() {
        return this.sourceSetName;
    }

    @Override
    @NotNull
    public TaskProvider<? extends T> getKotlinTask() {
        return this.kotlinTask;
    }

    @Nullable
    protected final SourceSet getJavaSourceSet() {
        KotlinCompilationData<?> compilation2 = this.getKotlinCompilation();
        KotlinWithJavaCompilation kotlinWithJavaCompilation = compilation2 instanceof KotlinWithJavaCompilation ? (KotlinWithJavaCompilation)compilation2 : null;
        if (kotlinWithJavaCompilation == null || (kotlinWithJavaCompilation = kotlinWithJavaCompilation.getJavaSourceSet()) == null) {
            Object it = this.getKotlinCompilation().getOwner();
            boolean bl = false;
            if (it instanceof KotlinJvmTarget && ((KotlinJvmTarget)it).getWithJavaEnabled() && compilation2 instanceof KotlinJvmCompilation) {
                Gradle gradle = this.getProject().getGradle();
                Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
                Gradle $this$variantImplementationFactory$iv = gradle;
                boolean $i$f$variantImplementationFactory = false;
                kotlinWithJavaCompilation = (SourceSet)((JavaSourceSetsAccessor.JavaSourceSetsAccessorVariantFactory)VariantImplementationFactories.Companion.get($this$variantImplementationFactory$iv).get(Reflection.getOrCreateKotlinClass(JavaSourceSetsAccessor.JavaSourceSetsAccessorVariantFactory.class))).getInstance(this.getProject()).getSourceSets().maybeCreate(((KotlinJvmCompilation)compilation2).getName());
            } else {
                kotlinWithJavaCompilation = null;
            }
        }
        return kotlinWithJavaCompilation;
    }

    private final TaskProvider<? extends T> prepareKotlinCompileTask() {
        TaskProvider<T> taskProvider;
        TaskProvider<T> task2 = taskProvider = this.doRegisterTask(this.getProject(), this.getKotlinCompilation().getCompileKotlinTaskName());
        boolean bl = false;
        Object[] objectArray = new Object[]{task2.flatMap((Transformer)prepareKotlinCompileTask.1.1.INSTANCE)};
        this.getKotlinCompilation().getOutput().getClassesDirs().from(objectArray);
        return taskProvider;
    }

    @Override
    public void run() {
        this.addKotlinDirectoriesToJavaSourceSet();
        this.doTargetSpecificProcessing();
        if (this.getKotlinCompilation() instanceof KotlinWithJavaCompilation) {
            this.createAdditionalClassesTaskForIdeRunner();
        }
    }

    private final void addKotlinDirectoriesToJavaSourceSet() {
        SourceSet sourceSet = this.getJavaSourceSet();
        if (sourceSet == null) {
            return;
        }
        SourceSet java = sourceSet;
        Callable kotlinSrcDirsToAdd2 = new Callable(this){
            final /* synthetic */ KotlinSourceSetProcessor<T> this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final List<FileCollection> call() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.this$0.getKotlinCompilation().getKotlinSourceDirectoriesByFragmentName().values();
                KotlinSourceSetProcessor<T> kotlinSourceSetProcessor = this.this$0;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SourceDirectorySet sourceDirectorySet = (SourceDirectorySet)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(KotlinSourceSetProcessor.access$filterOutJavaSrcDirsIfPossible(kotlinSourceSetProcessor, (SourceDirectorySet)it));
                }
                return (List)destination$iv$iv;
            }
        };
        Object[] objectArray = new Object[]{kotlinSrcDirsToAdd2};
        java.getAllJava().srcDirs(objectArray);
        objectArray = new Object[]{kotlinSrcDirsToAdd2};
        java.getAllSource().srcDirs(objectArray);
    }

    private final FileCollection filterOutJavaSrcDirsIfPossible(SourceDirectorySet sourceDirectories) {
        SourceSet sourceSet = this.getJavaSourceSet();
        if (sourceSet == null) {
            return (FileCollection)sourceDirectories;
        }
        SourceSet java = sourceSet;
        FileCollection fileCollection = sourceDirectories.getSourceDirectories().minus(java.getJava().getSourceDirectories());
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"sourceDirectories.source\u2026a.java.sourceDirectories)");
        return fileCollection;
    }

    private final void createAdditionalClassesTaskForIdeRunner() {
        boolean shouldCreateTask;
        KotlinCompilationData<?> kotlinCompilationData = this.getKotlinCompilation();
        KotlinCompilation kotlinCompilation = kotlinCompilationData instanceof KotlinCompilation ? (KotlinCompilation)((Object)kotlinCompilationData) : null;
        if (kotlinCompilation == null) {
            return;
        }
        KotlinCompilation kotlinCompilation2 = kotlinCompilation;
        String expectedClassesTaskName = kotlinCompilation2.getDefaultSourceSetName() + "Classes";
        TaskContainer $this$createAdditionalClassesTaskForIdeRunner_u24lambda_u242 = this.getProject().getTasks();
        boolean bl = false;
        boolean bl2 = shouldCreateTask = !$this$createAdditionalClassesTaskForIdeRunner_u24lambda_u242.getNames().contains(expectedClassesTaskName);
        if (shouldCreateTask) {
            @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u001a\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"org/jetbrains/kotlin/gradle/plugin/KotlinSourceSetProcessor$createAdditionalClassesTaskForIdeRunner$IDEClassesTask", "Lorg/gradle/api/DefaultTask;", "()V", "kotlin-gradle-plugin_common"})
            public class IDEClassesTask
            extends DefaultTask {
                public IDEClassesTask() {
                }
            }
            TasksProviderKt.registerTask$default(this.getProject(), expectedClassesTaskName, IDEClassesTask.class, null, (Function1)new Function1<IDEClassesTask, Unit>($this$createAdditionalClassesTaskForIdeRunner_u24lambda_u242, kotlinCompilation2){
                final /* synthetic */ TaskContainer $this_run;
                final /* synthetic */ KotlinCompilation<?> $kotlinCompilation;
                {
                    this.$this_run = $receiver;
                    this.$kotlinCompilation = $kotlinCompilation;
                    super(1);
                }

                public final void invoke(@NotNull IDEClassesTask it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    Object[] objectArray = new Object[]{this.$this_run.getByName(this.$kotlinCompilation.getCompileAllTaskName())};
                    it.dependsOn(objectArray);
                }
            }, 4, null);
        }
    }

    protected final void applyStandardTaskConfiguration(@NotNull AbstractKotlinCompileConfig<?> taskConfiguration) {
        Intrinsics.checkNotNullParameter(taskConfiguration, (String)"taskConfiguration");
        taskConfiguration.configureTask((Function1)new Function1<AbstractKotlinCompile<?>, Unit>(this){
            final /* synthetic */ KotlinSourceSetProcessor<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull AbstractKotlinCompile<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.setDescription(this.this$0.getTaskDescription());
                it.getDestinationDirectory().convention(this.this$0.getDefaultKotlinDestinationDir());
                Object[] objectArray = new Object[]{new Function0<FileCollection>(this.this$0){
                    final /* synthetic */ KotlinSourceSetProcessor<T> this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final FileCollection invoke() {
                        return this.this$0.getKotlinCompilation().getCompileDependencyFiles();
                    }
                }};
                it.getLibraries().from(objectArray);
            }
        });
    }

    @NotNull
    protected abstract TaskProvider<? extends T> doRegisterTask(@NotNull Project var1, @NotNull String var2);

    public static final /* synthetic */ FileCollection access$filterOutJavaSrcDirsIfPossible(KotlinSourceSetProcessor $this, SourceDirectorySet sourceDirectories) {
        return $this.filterOutJavaSrcDirsIfPossible(sourceDirectories);
    }
}

