/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0000\u001aB\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0002\u001a\u00020\u00032!\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u0002H\t0\u000bH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000e\u001a\f\u0010\u000f\u001a\u00020\u0003*\u00020\u0001H\u0000\u001a\u0012\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011*\u00020\u0003H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0007*\u00020\u0001H\u0000\u001a\u001a\u0010\u0013\u001a\u00020\u0007*\u00020\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0000\u001a\u001e\u0010\u0015\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\b\b\u0002\u0010\u0017\u001a\u00020\u0007H\u0000\u001a!\u0010\u0018\u001a\u0012\u0012\u000e\b\u0001\u0012\n \u001a*\u0004\u0018\u00010\u00010\u00010\u0019*\u00020\u0001H\u0000\u00a2\u0006\u0002\u0010\u001b\u001a\u001a\u0010\u001c\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u001f\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0001H\u0000\u001a\u0014\u0010 \u001a\u00020\u0003*\u00020\u00012\u0006\u0010!\u001a\u00020\"H\u0000\u001a\u001d\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019*\b\u0012\u0004\u0012\u00020\u00010\u001dH\u0000\u00a2\u0006\u0002\u0010$\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006%"}, d2={"newTmpFile", "Ljava/io/File;", "prefix", "", "suffix", "directory", "deleteOnExit", "", "withTemporaryDirectory", "T", "action", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "canonicalPathWithoutExtension", "fileExtensionCasePermutations", "", "isJavaFile", "isKotlinFile", "sourceFilesExtensions", "isParentOf", "childCandidate", "strict", "listFilesOrEmpty", "", "kotlin.jvm.PlatformType", "(Ljava/io/File;)[Ljava/io/File;", "pathsAsStringRelativeTo", "", "base", "relativeOrCanonical", "relativeToRoot", "project", "Lorg/gradle/api/Project;", "toPathsArray", "(Ljava/lang/Iterable;)[Ljava/lang/String;", "kotlin-gradle-plugin_common"})
public final class FileUtilsKt {
    public static final boolean isJavaFile(@NotNull File $this$isJavaFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isJavaFile, (String)"<this>");
        return StringsKt.equals((String)FilesKt.getExtension((File)$this$isJavaFile), (String)"java", (boolean)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKotlinFile(@NotNull File $this$isKotlinFile, @NotNull List<String> sourceFilesExtensions) {
        String it;
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinFile, (String)"<this>");
        Intrinsics.checkNotNullParameter(sourceFilesExtensions, (String)"sourceFilesExtensions");
        if (FileUtilsKt.isJavaFile($this$isKotlinFile)) return false;
        Iterable $this$any$iv = sourceFilesExtensions;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!StringsKt.equals((String)it, (String)FilesKt.getExtension((File)$this$isKotlinFile), (boolean)true));
        return true;
    }

    @NotNull
    public static final List<String> fileExtensionCasePermutations(@NotNull String $this$fileExtensionCasePermutations) {
        Intrinsics.checkNotNullParameter((Object)$this$fileExtensionCasePermutations, (String)"<this>");
        String string = $this$fileExtensionCasePermutations.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String lowercaseInput = string;
        int length = lowercaseInput.length();
        int max = 1 << length;
        List result2 = new ArrayList();
        char[] combination = null;
        for (int i2 = 0; i2 < max; ++i2) {
            Intrinsics.checkNotNullExpressionValue((Object)lowercaseInput.toCharArray(), (String)"this as java.lang.String).toCharArray()");
            for (int j = 0; j < length; ++j) {
                if ((i2 >> j & 1) != 1) continue;
                combination[j] = Character.toUpperCase(combination[j]);
            }
            result2.add(new String(combination));
        }
        return result2;
    }

    @NotNull
    public static final String relativeOrCanonical(@NotNull File $this$relativeOrCanonical, @NotNull File base) {
        Intrinsics.checkNotNullParameter((Object)$this$relativeOrCanonical, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        File file = FilesKt.relativeToOrNull((File)$this$relativeOrCanonical, (File)base);
        String string = file != null ? file.getPath() : null;
        if (string == null) {
            String string2 = $this$relativeOrCanonical.getCanonicalPath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"canonicalPath");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String pathsAsStringRelativeTo(@NotNull Iterable<? extends File> $this$pathsAsStringRelativeTo, @NotNull File base) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$pathsAsStringRelativeTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Iterable<? extends File> $this$map$iv = $this$pathsAsStringRelativeTo;
        boolean $i$f$map = false;
        Iterable<? extends File> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FileUtilsKt.relativeOrCanonical((File)it, base));
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), null, null, null, (int)0, null, null, (int)63, null);
    }

    @NotNull
    public static final String relativeToRoot(@NotNull File $this$relativeToRoot, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$relativeToRoot, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File file = project.getRootProject().getRootDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.rootProject.rootDir");
        return FileUtilsKt.relativeOrCanonical($this$relativeToRoot, file);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String[] toPathsArray(@NotNull Iterable<? extends File> $this$toPathsArray) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toPathsArray, (String)"<this>");
        Iterable<? extends File> $this$map$iv = $this$toPathsArray;
        boolean $i$f$map = false;
        Iterable<? extends File> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCanonicalPath());
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return stringArray;
    }

    @NotNull
    public static final File newTmpFile(@NotNull String prefix, @Nullable String suffix, @Nullable File directory2, boolean deleteOnExit) {
        Comparable<Path> comparable;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        try {
            File file = directory2;
            comparable = file == null ? Files.createTempFile(prefix, suffix, new FileAttribute[0]) : Files.createTempFile(file.toPath(), prefix, suffix, new FileAttribute[0]);
        }
        catch (NoSuchFileException e) {
            File parentDir = e.getFile().getParentFile();
            if (parentDir.isFile()) {
                throw new IOException("Temp folder " + parentDir + " is not a directory");
            }
            if (!parentDir.isDirectory() && !parentDir.mkdirs()) {
                throw new IOException("Could not create temp directory " + parentDir);
            }
            comparable = Files.createTempFile(parentDir.toPath(), prefix, suffix, new FileAttribute[0]);
        }
        Comparable<Path> $this$newTmpFile_u24lambda_u243 = comparable = comparable.toFile();
        boolean bl = false;
        if (deleteOnExit) {
            ((File)$this$newTmpFile_u24lambda_u243).deleteOnExit();
        }
        Comparable<Path> comparable2 = comparable;
        Intrinsics.checkNotNullExpressionValue(comparable2, (String)"try {\n        (if (direc\u2026eOnExit) deleteOnExit() }");
        return comparable2;
    }

    public static /* synthetic */ File newTmpFile$default(String string, String string2, File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return FileUtilsKt.newTmpFile(string, string2, file, bl);
    }

    public static final boolean isParentOf(@NotNull File $this$isParentOf, @NotNull File childCandidate, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)$this$isParentOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)childCandidate, (String)"childCandidate");
        Path parentPath = Paths.get($this$isParentOf.getAbsolutePath(), new String[0]).normalize();
        Path childCandidatePath = Paths.get(childCandidate.getAbsolutePath(), new String[0]).normalize();
        return strict ? childCandidatePath.startsWith(parentPath) && !Intrinsics.areEqual((Object)parentPath, (Object)childCandidate) : childCandidatePath.startsWith(parentPath);
    }

    public static /* synthetic */ boolean isParentOf$default(File file, File file2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return FileUtilsKt.isParentOf(file, file2, bl);
    }

    @NotNull
    public static final String canonicalPathWithoutExtension(@NotNull File $this$canonicalPathWithoutExtension) {
        Intrinsics.checkNotNullParameter((Object)$this$canonicalPathWithoutExtension, (String)"<this>");
        String string = $this$canonicalPathWithoutExtension.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"canonicalPath");
        return StringsKt.substringBeforeLast$default((String)string, (String)".", null, (int)2, null);
    }

    @NotNull
    public static final File[] listFilesOrEmpty(@NotNull File $this$listFilesOrEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$listFilesOrEmpty, (String)"<this>");
        File[] $this$orEmpty$iv = $this$listFilesOrEmpty.exists() ? $this$listFilesOrEmpty.listFiles() : null;
        boolean $i$f$orEmpty = false;
        Object[] objectArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            boolean $i$f$emptyArray = false;
            objectArray = new File[0];
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T withTemporaryDirectory(@NotNull String prefix, @NotNull Function1<? super File, ? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$withTemporaryDirectory = false;
        File directory2 = Files.createTempDirectory(prefix, new FileAttribute[0]).toFile();
        try {
            Intrinsics.checkNotNullExpressionValue((Object)directory2, (String)"directory");
            object = action.invoke((Object)directory2);
        }
        catch (Throwable throwable) {
            InlineMarker.finallyStart((int)1);
            Intrinsics.checkNotNullExpressionValue((Object)directory2, (String)"directory");
            FilesKt.deleteRecursively((File)directory2);
            InlineMarker.finallyEnd((int)1);
            throw throwable;
        }
        InlineMarker.finallyStart((int)1);
        FilesKt.deleteRecursively((File)directory2);
        InlineMarker.finallyEnd((int)1);
        return (T)object;
    }
}

