/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.kpm.idea;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.gson.GsonBuilder;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.idea.kpm.IdeaKpmProject;
import org.jetbrains.kotlin.gradle.idea.proto.kpm.KpmIdeaProto;
import org.jetbrains.kotlin.gradle.idea.serialize.IdeaKotlinSerializationContext;
import org.jetbrains.kotlin.gradle.kpm.idea.IdeaKpmProjectModelBuilderImpl;
import org.jetbrains.kotlin.gradle.utils.CompatibilityKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0005R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/kpm/idea/IdeaKpmBuildProjectModelTask;", "Lorg/gradle/api/DefaultTask;", "()V", "builder", "Lorg/jetbrains/kotlin/gradle/kpm/idea/IdeaKpmProjectModelBuilderImpl;", "outputDirectory", "Ljava/io/File;", "getOutputDirectory", "()Ljava/io/File;", "buildIdeaKpmProjectModel", "", "Companion", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nIdeaKpmBuildProjectModelTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaKpmBuildProjectModelTask.kt\norg/jetbrains/kotlin/gradle/kpm/idea/IdeaKpmBuildProjectModelTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1#2:69\n*E\n"})
public class IdeaKpmBuildProjectModelTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @OutputDirectory
    @NotNull
    private final File outputDirectory;
    @NotNull
    private final IdeaKpmProjectModelBuilderImpl builder;
    @NotNull
    public static final String defaultTaskName = "buildIdeaKpmProjectModel";

    public IdeaKpmBuildProjectModelTask() {
        File file = this.getProject().getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
        this.outputDirectory = FilesKt.resolve((File)file, (String)"IdeaKpmProject");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.builder = KotlinProjectExtensionKt.getPm20Extension(project).getIdeaKpmProjectModelBuilder$kotlin_gradle_plugin_common();
        CompatibilityKt.doNotTrackStateCompat((Task)this, "Should always re-run to produce updated models");
    }

    @NotNull
    public final File getOutputDirectory() {
        return this.outputDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    protected final void buildIdeaKpmProjectModel() {
        this.outputDirectory.mkdirs();
        IdeaKpmProject model = this.builder.buildIdeaKpmProject();
        IdeaKotlinSerializationContext serializationContext = this.builder.buildSerializationContext();
        File textFile = FilesKt.resolve((File)this.outputDirectory, (String)"model.txt");
        FilesKt.writeText$default((File)textFile, (String)model.toString(), null, (int)2, null);
        File javaIoSerializableBinaryFile = FilesKt.resolve((File)this.outputDirectory, (String)"model.java.bin");
        Closeable closeable = new ByteArrayOutputStream();
        File file = javaIoSerializableBinaryFile;
        Throwable throwable = null;
        try {
            Object byteArrayOutputStream = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new ObjectOutputStream((OutputStream)byteArrayOutputStream);
            Throwable throwable2 = null;
            try {
                ObjectOutputStream objectOutputStream = (ObjectOutputStream)closeable2;
                boolean bl2 = false;
                objectOutputStream.writeObject(model);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byteArrayOutputStream = ((ByteArrayOutputStream)byteArrayOutputStream).toByteArray();
        }
        catch (Throwable byteArrayOutputStream) {
            throwable = byteArrayOutputStream;
            throw byteArrayOutputStream;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object object = byteArrayOutputStream;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ByteArrayOutputStream().\u2026m.toByteArray()\n        }");
        FilesKt.writeBytes((File)file, (byte[])object);
        File protoBinaryFile = FilesKt.resolve((File)this.outputDirectory, (String)"model.proto.bin");
        if (protoBinaryFile.exists()) {
            protoBinaryFile.delete();
        }
        closeable = new FileOutputStream(protoBinaryFile);
        throwable = null;
        try {
            FileOutputStream stream = (FileOutputStream)closeable;
            boolean bl = false;
            KpmIdeaProto.writeTo((IdeaKpmProject)model, (OutputStream)stream, (IdeaKotlinSerializationContext)serializationContext);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        File jsonFile = FilesKt.resolve((File)this.outputDirectory, (String)"model.json");
        String string = new GsonBuilder().setLenient().setPrettyPrinting().create().toJson(model);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GsonBuilder().setLenient\u2026().create().toJson(model)");
        FilesKt.writeText$default((File)jsonFile, (String)string, null, (int)2, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/kpm/idea/IdeaKpmBuildProjectModelTask$Companion;", "", "()V", "defaultTaskName", "", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

