/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import com.gradle.scan.plugin.BuildScanExtension;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.StartParameter;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.ValueType;
import org.jetbrains.kotlin.gradle.plugin.BuildEventsListenerRegistryHolder;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;
import org.jetbrains.kotlin.gradle.plugin.stat.BuildFinishStatisticsData;
import org.jetbrains.kotlin.gradle.plugin.stat.CompileStatisticsData;
import org.jetbrains.kotlin.gradle.plugin.stat.GradleBuildStartParameters;
import org.jetbrains.kotlin.gradle.plugin.stat.StatTag;
import org.jetbrains.kotlin.gradle.report.BuildMetricsService;
import org.jetbrains.kotlin.gradle.report.BuildReportsService;
import org.jetbrains.kotlin.gradle.report.BuildScanExtensionHolder;
import org.jetbrains.kotlin.gradle.report.BuildScanSettings;
import org.jetbrains.kotlin.gradle.report.ConfigureReporingKt;
import org.jetbrains.kotlin.gradle.report.FileReportSettings;
import org.jetbrains.kotlin.gradle.report.HttpReportService;
import org.jetbrains.kotlin.gradle.report.HttpReportServiceImpl;
import org.jetbrains.kotlin.gradle.report.HttpReportSettings;
import org.jetbrains.kotlin.gradle.report.MetricsWriter;
import org.jetbrains.kotlin.gradle.report.PlainTextBuildReportWriter;
import org.jetbrains.kotlin.gradle.report.ReportDataUtilKt;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;
import org.jetbrains.kotlin.gradle.report.UsesBuildReportsService;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionData;
import org.jetbrains.kotlin.gradle.report.data.BuildOperationRecord;
import org.jetbrains.kotlin.gradle.utils.ConfigurationCacheKt;
import org.jetbrains.kotlin.gradle.utils.FormattingUtilsKt;
import org.jetbrains.kotlin.gradle.utils.SingleActionPerProject;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u0000 32\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u000234B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J \u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u0012\u0010 \u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010!\u001a\u00020\u0014H\u0016J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010#\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070%2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010&\u001a\u00020\u0014H\u0002J\u0018\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070%2\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\tH\u0002J\u0014\u0010/\u001a\u000200*\u0002002\u0006\u00101\u001a\u000202H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildReportsService;", "Lorg/gradle/api/services/BuildService;", "Lorg/jetbrains/kotlin/gradle/report/BuildReportsService$Parameters;", "Ljava/lang/AutoCloseable;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "()V", "buildUuid", "", "customValues", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "startTime", "", "tags", "Ljava/util/LinkedHashSet;", "addBuildScanReport", "", "event", "Lorg/gradle/tooling/events/FinishEvent;", "buildScan", "Lorg/jetbrains/kotlin/gradle/report/BuildScanExtensionHolder;", "data", "Lorg/jetbrains/kotlin/gradle/plugin/stat/CompileStatisticsData;", "customValuesLimit", "addBuildScanTag", "tag", "addBuildScanValue", "customValue", "addHttpReport", "close", "initBuildScanTags", "onFinish", "readableString", "", "reportBuildFinish", "reportBuildStatInFile", "fileReportSettings", "Lorg/jetbrains/kotlin/gradle/report/FileReportSettings;", "buildData", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionData;", "splitStringIfNeed", "str", "lengthLimit", "includeVerboseEnvironment", "Lorg/jetbrains/kotlin/gradle/plugin/stat/GradleBuildStartParameters;", "verboseEnvironment", "", "Companion", "Parameters", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nBuildReportsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildReportsService.kt\norg/jetbrains/kotlin/gradle/report/BuildReportsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,400:1\n1045#2:401\n766#2:410\n857#2,2:411\n1855#2,2:413\n1855#2,2:415\n183#3,3:402\n17#4,5:405\n22#4:417\n125#5:418\n152#5,3:419\n125#5:422\n152#5,3:423\n*E\n*S KotlinDebug\n*F\n+ 1 BuildReportsService.kt\norg/jetbrains/kotlin/gradle/report/BuildReportsService\n*L\n81#1:401\n205#1:410\n205#1,2:411\n206#1,2:413\n211#1,2:415\n185#1,3:402\n202#1,5:405\n202#1:417\n258#1:418\n258#1,3:419\n259#1:422\n259#1,3:423\n*E\n"})
public abstract class BuildReportsService
implements BuildService<Parameters>,
AutoCloseable,
OperationCompletionListener {
    @NotNull
    public static final Companion Companion;
    private final Logger log = Logging.getLogger(this.getClass());
    private final long startTime = System.nanoTime();
    @NotNull
    private final String buildUuid;
    @NotNull
    private ExecutorService executorService;
    @NotNull
    private final LinkedHashSet<String> tags;
    private int customValues;
    public static final int CUSTOM_VALUE_LENGTH_LIMIT = 100000;
    @NotNull
    private static final SimpleDateFormat DATE_FORMATTER;
    @Nullable
    private static final String hostName;

    public BuildReportsService() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.buildUuid = string;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        this.executorService = executorService;
        this.tags = new LinkedHashSet();
        this.log.info("Build report service is registered. Unique build id: " + this.buildUuid);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void close() {
        v0 = ((Parameters)this.getParameters()).getStartParameters().get();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"parameters.startParameters.get()");
        v1 = (GradleBuildStartParameters)v0;
        v2 = (BuildMetricsService)((Parameters)this.getParameters()).getBuildMetricsService().getOrNull();
        if (v2 == null || (v2 = v2.getFailureMessages$kotlin_gradle_plugin_common()) == null || (v2 = CollectionsKt.toList((Iterable)((Iterable)v2))) == null) {
            v2 = CollectionsKt.emptyList();
        }
        if ((v3 = (BuildMetricsService)((Parameters)this.getParameters()).getBuildMetricsService().getOrNull()) == null || (v3 = v3.getBuildOperationRecords$kotlin_gradle_plugin_common()) == null) ** GOTO lbl-1000
        $this$sortedBy$iv = (Iterable)v3;
        $i$f$sortedBy = false;
        v3 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                BuildOperationRecord it = (BuildOperationRecord)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getStartTimeMs());
                it = (BuildOperationRecord)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getStartTimeMs()));
            }
        });
        if (v3 != null) {
            v4 = (Collection)v3;
        } else lbl-1000:
        // 2 sources

        {
            v4 = CollectionsKt.emptyList();
        }
        buildData = new BuildExecutionData(v1, (List<String>)v2, v4);
        reportingSettings = (ReportingSettings)((Parameters)this.getParameters()).getReportingSettings().get();
        v5 = reportingSettings.getHttpReportSettings();
        if (v5 != null) {
            var3_5 = v5;
            it = var3_5;
            $i$a$-also-BuildReportsService$close$1 = false;
            this.executorService.submit(new Runnable(this){
                final /* synthetic */ BuildReportsService this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void run() {
                    BuildReportsService.access$reportBuildFinish(this.this$0);
                }
            });
        }
        v6 = reportingSettings.getFileReportSettings();
        if (v6 != null) {
            var3_5 = v6;
            it = var3_5;
            $i$a$-also-BuildReportsService$close$2 = false;
            this.reportBuildStatInFile((FileReportSettings)it, buildData);
        }
        v7 = reportingSettings.getSingleOutputFile();
        if (v7 != null) {
            singleOutputFile = var3_5 = v7;
            $i$a$-also-BuildReportsService$close$3 = false;
            v8 = singleOutputFile.getAbsoluteFile();
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"singleOutputFile.absoluteFile");
            v9 = new MetricsWriter(v8);
            v10 = this.log;
            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"log");
            v9.process(buildData, v10);
        }
        this.executorService.shutdown();
    }

    public void onFinish(@Nullable FinishEvent event) {
        this.addHttpReport(event);
    }

    private final void reportBuildStatInFile(FileReportSettings fileReportSettings, BuildExecutionData buildData) {
        String ts = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(Calendar.getInstance().getTime());
        File reportFile = FilesKt.resolve((File)fileReportSettings.getBuildReportDir(), (String)((String)((Parameters)this.getParameters()).getProjectName().get() + "-build-" + ts + ".txt"));
        PlainTextBuildReportWriter plainTextBuildReportWriter = new PlainTextBuildReportWriter(reportFile, fileReportSettings.getIncludeMetricsInReport());
        Logger logger = this.log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        plainTextBuildReportWriter.process(buildData, logger);
    }

    private final void reportBuildFinish() {
        block3: {
            String string;
            HttpReportSettings httpReportSettings = ((ReportingSettings)((Parameters)this.getParameters()).getReportingSettings().get()).getHttpReportSettings();
            if (httpReportSettings == null) {
                return;
            }
            HttpReportSettings httpReportSettings2 = httpReportSettings;
            if (httpReportSettings2.getIncludeGitBranchName()) {
                Object object = new String[]{"git", "rev-parse", "--abbrev-ref", "HEAD"};
                Object it = object = new ProcessBuilder((String[])object).directory((File)((Parameters)this.getParameters()).getProjectDir().getAsFile().get()).start();
                boolean bl = false;
                ((Process)it).waitFor(5L, TimeUnit.SECONDS);
                Object process = object;
                InputStream inputStream = ((Process)process).getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
                object = inputStream;
                Charset charset = Charsets.UTF_8;
                string = TextStreamsKt.readText((Reader)new InputStreamReader((InputStream)object, charset));
            } else {
                string = "is not set";
            }
            String branchName = string;
            Object object = ((Parameters)this.getParameters()).getProjectName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.projectName.get()");
            String string2 = (String)object;
            Object object2 = ((Parameters)this.getParameters()).getStartParameters().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.startParameters.get()");
            HttpReportSettings httpReportSettings3 = ((ReportingSettings)((Parameters)this.getParameters()).getReportingSettings().get()).getHttpReportSettings();
            BuildFinishStatisticsData buildFinishData = new BuildFinishStatisticsData(string2, this.includeVerboseEnvironment((GradleBuildStartParameters)object2, httpReportSettings3 != null ? httpReportSettings3.getVerboseEnvironment() : false), this.buildUuid, (String)((Parameters)this.getParameters()).getLabel().getOrNull(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startTime), null, System.currentTimeMillis(), null, hostName, CollectionsKt.toList((Iterable)this.tags), branchName, 160, null);
            HttpReportService httpReportService = (HttpReportService)((Parameters)this.getParameters()).getHttpService().getOrNull();
            if (httpReportService == null) break block3;
            Logger logger = this.log;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
            httpReportService.sendData(buildFinishData, logger);
        }
    }

    private final GradleBuildStartParameters includeVerboseEnvironment(GradleBuildStartParameters $this$includeVerboseEnvironment, boolean verboseEnvironment) {
        return verboseEnvironment ? $this$includeVerboseEnvironment : new GradleBuildStartParameters($this$includeVerboseEnvironment.getTasks(), $this$includeVerboseEnvironment.getExcludedTasks(), null, CollectionsKt.emptyList(), CollectionsKt.emptyList());
    }

    private final void addHttpReport(FinishEvent event) {
        block2: {
            HttpReportService httpReportService;
            HttpReportService httpReportService2 = (HttpReportService)((Parameters)this.getParameters()).getHttpService().getOrNull();
            if (httpReportService2 == null) break block2;
            HttpReportService httpService = httpReportService = httpReportService2;
            boolean bl = false;
            if (event instanceof TaskFinishEvent) {
                CompileStatisticsData data;
                TaskFinishEvent taskFinishEvent = (TaskFinishEvent)event;
                Object object = ((Parameters)this.getParameters()).getProjectName().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.projectName.get()");
                String string = (String)object;
                String string2 = (String)((Parameters)this.getParameters()).getLabel().getOrNull();
                Object object2 = ((Parameters)this.getParameters()).getKotlinVersion().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.kotlinVersion.get()");
                String string3 = (String)object2;
                Collection collection = ((BuildMetricsService)((Parameters)this.getParameters()).getBuildMetricsService().get()).getBuildOperationRecords$kotlin_gradle_plugin_common();
                Object object3 = ((Parameters)this.getParameters()).getAdditionalTags().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.additionalTags.get()");
                CompileStatisticsData compileStatisticsData = data = ReportDataUtilKt.prepareData(taskFinishEvent, string, this.buildUuid, string2, string3, collection, (List)object3);
                if (compileStatisticsData != null) {
                    CompileStatisticsData compileStatisticsData2;
                    CompileStatisticsData it = compileStatisticsData2 = compileStatisticsData;
                    boolean bl2 = false;
                    this.executorService.submit(new Runnable(httpService, data, this){
                        final /* synthetic */ HttpReportService $httpService;
                        final /* synthetic */ CompileStatisticsData $data;
                        final /* synthetic */ BuildReportsService this$0;
                        {
                            this.$httpService = $httpService;
                            this.$data = $data;
                            this.this$0 = $receiver;
                        }

                        public final void run() {
                            Logger logger = BuildReportsService.access$getLog$p(this.this$0);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
                            this.$httpService.sendData(this.$data, logger);
                        }
                    });
                }
            }
        }
    }

    private final void addBuildScanReport(FinishEvent event, BuildScanExtensionHolder buildScan) {
        block1: {
            BuildScanSettings buildScanSettings;
            ReportingSettings reportingSettings = (ReportingSettings)((Parameters)this.getParameters()).getReportingSettings().getOrNull();
            BuildScanSettings buildScanSettings2 = buildScanSettings = reportingSettings != null ? reportingSettings.getBuildScanReportSettings() : null;
            if (buildScanSettings == null || buildScan.getBuildScan() == null || !(event instanceof TaskFinishEvent)) break block1;
            boolean $i$f$measureTimeMillisWithResult = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            TaskFinishEvent taskFinishEvent = (TaskFinishEvent)event;
            Object object = ((Parameters)this.getParameters()).getProjectName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.projectName.get()");
            String string = (String)object;
            String string2 = (String)((Parameters)this.getParameters()).getLabel().getOrNull();
            Object object2 = ((Parameters)this.getParameters()).getKotlinVersion().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.kotlinVersion.get()");
            CompileStatisticsData result$iv = ReportDataUtilKt.prepareData$default(taskFinishEvent, string, this.buildUuid, string2, (String)object2, ((BuildMetricsService)((Parameters)this.getParameters()).getBuildMetricsService().get()).getBuildOperationRecords$kotlin_gradle_plugin_common(), null, 64, null);
            Pair pair = new Pair((Object)(System.currentTimeMillis() - start$iv), (Object)result$iv);
            long collectDataDuration = ((Number)pair.component1()).longValue();
            CompileStatisticsData compileStatData = (CompileStatisticsData)pair.component2();
            this.log.debug("Collect data takes " + collectDataDuration + ": " + compileStatData);
            CompileStatisticsData compileStatisticsData = compileStatData;
            if (compileStatisticsData != null) {
                CompileStatisticsData compileStatisticsData2;
                CompileStatisticsData it = compileStatisticsData2 = compileStatisticsData;
                boolean bl2 = false;
                this.addBuildScanReport(it, buildScanSettings.getCustomValueLimit(), buildScan);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addBuildScanReport(CompileStatisticsData data, int customValuesLimit, BuildScanExtensionHolder buildScan) {
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        BuildScanExtension buildScanExtension = buildScan.getBuildScan();
        if (buildScanExtension != null) {
            Iterable $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            BuildScanExtension buildScanExtension2;
            BuildScanExtension it = buildScanExtension2 = buildScanExtension;
            boolean bl2 = false;
            Iterable iterable = data.getTags();
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it2 = (String)element$iv$iv;
                boolean bl3 = false;
                if (!(!this.tags.contains(it2))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it3 = (String)element$iv;
                boolean bl4 = false;
                this.addBuildScanTag(buildScan, it3);
            }
            if (this.customValues < customValuesLimit) {
                $this$forEach$iv = this.readableString(data);
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it4 = (String)element$iv;
                    boolean bl5 = false;
                    if (this.customValues < customValuesLimit) {
                        this.addBuildScanValue(buildScan, data, it4);
                        continue;
                    }
                    this.log.debug("Can't add any more custom values into build scan. Statistic data for " + data.getTaskName() + " was cut due to custom values limit.");
                }
            } else {
                this.log.debug("Can't add any more custom values into build scan.");
            }
        }
        long elapsedTime = System.currentTimeMillis() - start$iv;
        this.log.debug("Report statistic to build scan takes " + elapsedTime + " ms");
    }

    private final void addBuildScanValue(BuildScanExtensionHolder buildScan, CompileStatisticsData data, String customValue) {
        BuildScanExtension buildScanExtension = buildScan.getBuildScan();
        if (buildScanExtension != null) {
            buildScanExtension.value(data.getTaskName(), customValue);
        }
        int n = this.customValues;
        this.customValues = n + 1;
    }

    private final void addBuildScanTag(BuildScanExtensionHolder buildScan, String tag) {
        BuildScanExtension buildScanExtension = buildScan.getBuildScan();
        if (buildScanExtension != null) {
            buildScanExtension.tag(tag);
        }
        this.tags.add(tag);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> readableString(CompileStatisticsData data) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        StringBuilder readableString2 = new StringBuilder();
        if (data.getNonIncrementalAttributes().isEmpty()) {
            readableString2.append("Incremental build; ");
            CollectionsKt.joinTo$default((Iterable)data.getChanges(), (Appendable)readableString2, null, (CharSequence)"Changes: [", (CharSequence)"]; ", (int)0, null, (Function1)readableString.1.INSTANCE, (int)50, null);
        } else {
            CollectionsKt.joinTo$default((Iterable)data.getNonIncrementalAttributes(), (Appendable)readableString2, null, (CharSequence)"Non incremental build because: [", (CharSequence)"]; ", (int)0, null, (Function1)readableString.2.INSTANCE, (int)50, null);
        }
        Map<BuildTime, Long> $this$map$iv = data.getBuildTimesMetrics();
        boolean $i$f$map = false;
        Map<BuildTime, Long> map = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            BuildTime key = (BuildTime)entry2.getKey();
            long value = ((Number)entry2.getValue()).longValue();
            collection.add(key.getReadableString() + ": " + value + "ms");
        }
        List timeData = (List)destination$iv$iv;
        Map<BuildPerformanceMetric, Long> $this$map$iv2 = data.getPerformanceMetrics();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            String string;
            Map.Entry item$iv$iv;
            Map.Entry entry3 = item$iv$iv = iterator2.next();
            collection = destination$iv$iv2;
            boolean bl = false;
            BuildPerformanceMetric key = (BuildPerformanceMetric)entry3.getKey();
            long value = ((Number)entry3.getValue()).longValue();
            switch (WhenMappings.$EnumSwitchMapping$0[key.getType().ordinal()]) {
                case 1: {
                    string = key.getReadableString() + ": " + FormattingUtilsKt.formatSize(value);
                    break;
                }
                case 2: {
                    string = DATE_FORMATTER.format(value);
                    break;
                }
                default: {
                    string = key.getReadableString() + ": " + value + '}';
                }
            }
            collection.add(string);
        }
        List perfData = (List)destination$iv$iv2;
        CollectionsKt.joinTo$default((Iterable)CollectionsKt.union((Iterable)timeData, (Iterable)perfData), (Appendable)readableString2, (CharSequence)",", (CharSequence)"Performance: [", (CharSequence)"]", (int)0, null, null, (int)112, null);
        String string = readableString2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readableString.toString()");
        return this.splitStringIfNeed(string, 100000);
    }

    private final List<String> splitStringIfNeed(String str, int lengthLimit) {
        ArrayList<String> splattedString = new ArrayList<String>();
        String tempStr = str;
        while (tempStr.length() > lengthLimit) {
            String subSequence;
            Intrinsics.checkNotNullExpressionValue((Object)tempStr.substring(lengthLimit), (String)"this as java.lang.String).substring(startIndex)");
            int index = StringsKt.lastIndexOf$default((CharSequence)subSequence, (char)';', (int)0, (boolean)false, (int)6, null);
            if (index == -1 && (index = StringsKt.lastIndexOf$default((CharSequence)subSequence, (char)',', (int)0, (boolean)false, (int)6, null)) == -1) {
                index = lengthLimit;
            }
            String string = tempStr.substring(index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            splattedString.add(string);
            Intrinsics.checkNotNullExpressionValue((Object)tempStr.substring(index), (String)"this as java.lang.String).substring(startIndex)");
        }
        splattedString.add(tempStr);
        return splattedString;
    }

    private final void initBuildScanTags(BuildScanExtensionHolder buildScan) {
        block2: {
            String string;
            BuildScanExtension buildScanExtension = buildScan.getBuildScan();
            if (buildScanExtension != null) {
                buildScanExtension.tag(this.buildUuid);
            }
            String string2 = (String)((Parameters)this.getParameters()).getLabel().getOrNull();
            if (string2 == null) break block2;
            String it = string = string2;
            boolean bl = false;
            BuildScanExtension buildScanExtension2 = buildScan.getBuildScan();
            if (buildScanExtension2 != null) {
                buildScanExtension2.tag(it);
            }
        }
    }

    public static final /* synthetic */ void access$addBuildScanReport(BuildReportsService $this, FinishEvent event, BuildScanExtensionHolder buildScan) {
        $this.addBuildScanReport(event, buildScan);
    }

    public static final /* synthetic */ void access$reportBuildFinish(BuildReportsService $this) {
        $this.reportBuildFinish();
    }

    public static final /* synthetic */ Logger access$getLog$p(BuildReportsService $this) {
        return $this.log;
    }

    static {
        String string;
        Companion = new Companion(null);
        DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception _) {
            string = null;
        }
        hostName = string;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0012R\u0012\u0010\u0018\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0012R\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0012R\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0012\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildReportsService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "additionalTags", "Lorg/gradle/api/provider/ListProperty;", "Lorg/jetbrains/kotlin/gradle/plugin/stat/StatTag;", "getAdditionalTags", "()Lorg/gradle/api/provider/ListProperty;", "buildMetricsService", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/report/BuildMetricsService;", "getBuildMetricsService", "()Lorg/gradle/api/provider/Provider;", "setBuildMetricsService", "(Lorg/gradle/api/provider/Provider;)V", "httpService", "Lorg/gradle/api/provider/Property;", "Lorg/jetbrains/kotlin/gradle/report/HttpReportService;", "getHttpService", "()Lorg/gradle/api/provider/Property;", "kotlinVersion", "", "getKotlinVersion", "label", "getLabel", "projectDir", "Lorg/gradle/api/file/DirectoryProperty;", "getProjectDir", "()Lorg/gradle/api/file/DirectoryProperty;", "projectName", "getProjectName", "reportingSettings", "Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "getReportingSettings", "startParameters", "Lorg/jetbrains/kotlin/gradle/plugin/stat/GradleBuildStartParameters;", "getStartParameters", "kotlin-gradle-plugin_common"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public Property<GradleBuildStartParameters> getStartParameters();

        @NotNull
        public Property<ReportingSettings> getReportingSettings();

        @NotNull
        public Provider<BuildMetricsService> getBuildMetricsService();

        public void setBuildMetricsService(@NotNull Provider<BuildMetricsService> var1);

        @NotNull
        public Property<HttpReportService> getHttpService();

        @NotNull
        public DirectoryProperty getProjectDir();

        @NotNull
        public Property<String> getLabel();

        @NotNull
        public Property<String> getProjectName();

        @NotNull
        public Property<String> getKotlinVersion();

        @NotNull
        public ListProperty<StatTag> getAdditionalTags();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValueType.values().length];
            try {
                nArray[ValueType.BYTES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.MILLISECONDS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ$\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010J&\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildReportsService$Companion;", "", "()V", "CUSTOM_VALUE_LENGTH_LIMIT", "", "DATE_FORMATTER", "Ljava/text/SimpleDateFormat;", "hostName", "", "getHostName", "()Ljava/lang/String;", "getStartParameters", "Lorg/jetbrains/kotlin/gradle/plugin/stat/GradleBuildStartParameters;", "project", "Lorg/gradle/api/Project;", "registerIfAbsent", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/report/BuildReportsService;", "buildMetricsService", "Lorg/jetbrains/kotlin/gradle/report/BuildMetricsService;", "registerIfAbsentImpl", "setupTags", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/gradle/plugin/stat/StatTag;", "gradle", "Lorg/gradle/api/invocation/Gradle;", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nBuildReportsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildReportsService.kt\norg/jetbrains/kotlin/gradle/report/BuildReportsService$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,400:1\n1360#2:401\n1446#2,5:402\n125#3:407\n152#3,3:408\n125#3:411\n152#3,3:412\n*E\n*S KotlinDebug\n*F\n+ 1 BuildReportsService.kt\norg/jetbrains/kotlin/gradle/report/BuildReportsService$Companion\n*L\n305#1:401\n305#1,5:402\n308#1:407\n308#1,3:408\n309#1:411\n309#1,3:412\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final GradleBuildStartParameters getStartParameters(@NotNull Project project) {
            Collection<String> collection;
            String value;
            String key;
            Collection<String> collection2;
            Map.Entry entry2;
            Map.Entry item$iv$iv;
            Map $this$mapTo$iv$iv;
            Map $this$map$iv;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            StartParameter it = project.getGradle().getStartParameter();
            boolean bl = false;
            List list2 = it.getTaskRequests();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"it.taskRequests");
            Object $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                TaskExecutionRequest it2 = (TaskExecutionRequest)element$iv$iv;
                boolean bl2 = false;
                List list3 = it2.getArgs();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"it.args");
                Iterable list$iv$iv = list3;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list4 = (List)destination$iv$iv;
            Set set2 = it.getExcludedTaskNames();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"it.excludedTaskNames");
            String string = it.getCurrentDir().getPath();
            Map map = it.getProjectProperties();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"it.projectProperties");
            $this$flatMap$iv = map;
            String string2 = string;
            Set set3 = set2;
            List list5 = list4;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator<Object> iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                entry2 = item$iv$iv = (Map.Entry)iterator.next();
                collection2 = destination$iv$iv;
                boolean bl3 = false;
                key = (String)entry2.getKey();
                value = (String)entry2.getValue();
                collection2.add(key + ": " + value);
            }
            collection2 = (List)destination$iv$iv;
            Map map2 = it.getSystemPropertiesArgs();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"it.systemPropertiesArgs");
            $this$map$iv = map2;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                entry2 = item$iv$iv = (Map.Entry)iterator.next();
                collection = destination$iv$iv;
                boolean bl4 = false;
                key = (String)entry2.getKey();
                value = (String)entry2.getValue();
                collection.add(key + ": " + value);
            }
            Collection<String> collection3 = collection = (List)destination$iv$iv;
            Collection<String> collection4 = collection2;
            String string3 = string2;
            Set set4 = set3;
            List list6 = list5;
            return new GradleBuildStartParameters(list6, set4, string3, (List<String>)collection4, (List<String>)collection3);
        }

        private final Provider<BuildReportsService> registerIfAbsentImpl(Project project, Provider<BuildMetricsService> buildMetricsService) {
            Class<BuildReportsService> serviceClass = BuildReportsService.class;
            String serviceName = serviceClass.getName() + '_' + serviceClass.getClassLoader().hashCode();
            ReportingSettings reportingSettings = ConfigureReporingKt.reportingSettings(project);
            if (reportingSettings.getBuildReportOutputs().isEmpty()) {
                return null;
            }
            String kotlinVersion = KotlinPluginWrapperKt.getKotlinPluginVersion(project);
            Gradle gradle = project.getGradle();
            BuildServiceRegistration buildServiceRegistration = (BuildServiceRegistration)project.getGradle().getSharedServices().getRegistrations().findByName(serviceName);
            if (buildServiceRegistration != null) {
                BuildServiceRegistration it = buildServiceRegistration;
                boolean bl = false;
                Provider provider = it.getService();
                Intrinsics.checkNotNull((Object)provider, (String)"null cannot be cast to non-null type org.gradle.api.provider.Provider<org.jetbrains.kotlin.gradle.report.BuildReportsService>");
                return provider;
            }
            buildServiceRegistration = (Function1)new Function1<BuildServiceSpec<Parameters>, Unit>(reportingSettings, project, kotlinVersion, buildMetricsService, gradle){
                final /* synthetic */ ReportingSettings $reportingSettings;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $kotlinVersion;
                final /* synthetic */ Provider<BuildMetricsService> $buildMetricsService;
                final /* synthetic */ Gradle $gradle;
                {
                    this.$reportingSettings = $reportingSettings;
                    this.$project = $project;
                    this.$kotlinVersion = $kotlinVersion;
                    this.$buildMetricsService = $buildMetricsService;
                    this.$gradle = $gradle;
                    super(1);
                }

                public final void invoke(BuildServiceSpec<Parameters> it) {
                    ((Parameters)it.getParameters()).getLabel().set((Object)this.$reportingSettings.getBuildReportLabel());
                    ((Parameters)it.getParameters()).getProjectName().set((Object)this.$project.getRootProject().getName());
                    ((Parameters)it.getParameters()).getKotlinVersion().set((Object)this.$kotlinVersion);
                    ((Parameters)it.getParameters()).getStartParameters().set((Object)BuildReportsService.Companion.getStartParameters(this.$project));
                    ((Parameters)it.getParameters()).getReportingSettings().set((Object)this.$reportingSettings);
                    HttpReportSettings httpReportSettings = this.$reportingSettings.getHttpReportSettings();
                    if (httpReportSettings != null) {
                        HttpReportSettings httpSettings = httpReportSettings;
                        boolean bl = false;
                        ((Parameters)it.getParameters()).getHttpService().set((Object)new HttpReportServiceImpl(httpSettings));
                    }
                    ((Parameters)it.getParameters()).setBuildMetricsService(this.$buildMetricsService);
                    ((Parameters)it.getParameters()).getProjectDir().set((Object)this.$project.getRootProject().getLayout().getProjectDirectory());
                    ListProperty<StatTag> listProperty = ((Parameters)it.getParameters()).getAdditionalTags();
                    Gradle gradle = this.$gradle;
                    Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"gradle");
                    listProperty.value((Iterable)org.jetbrains.kotlin.gradle.report.BuildReportsService$Companion.access$setupTags(BuildReportsService.Companion, gradle));
                }
            };
            BuildServiceRegistration it = buildServiceRegistration = gradle.getSharedServices().registerIfAbsent(serviceName, serviceClass, new Action((Function1)buildServiceRegistration){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ void execute(Object p0) {
                    this.function.invoke(p0);
                }
            });
            boolean bl = false;
            if (reportingSettings.getHttpReportSettings() != null) {
                BuildEventsListenerRegistryHolder.Companion.getInstance(project).getListenerRegistry().onTaskCompletion((Provider)it);
            }
            Object buildScanExtension = project.getRootProject().getExtensions().findByName("buildScan");
            if (reportingSettings.getBuildScanReportSettings() != null && buildScanExtension != null) {
                Object object = it.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.get()");
                ((BuildReportsService)object).initBuildScanTags(new BuildScanExtensionHolder(buildScanExtension));
                BuildEventsListenerRegistryHolder.Companion.getInstance(project).getListenerRegistry().onTaskCompletion(project.provider(new Callable((Provider<BuildReportsService>)it, buildScanExtension){
                    final /* synthetic */ Provider<BuildReportsService> $it;
                    final /* synthetic */ Object $buildScanExtension;
                    {
                        this.$it = $it;
                        this.$buildScanExtension = $buildScanExtension;
                    }

                    public final OperationCompletionListener call() {
                        return new OperationCompletionListener(this.$it, this.$buildScanExtension){
                            final /* synthetic */ Provider<BuildReportsService> $it;
                            final /* synthetic */ Object $buildScanExtension;
                            {
                                this.$it = $it;
                                this.$buildScanExtension = $buildScanExtension;
                            }

                            public final void onFinish(FinishEvent event) {
                                Object object = this.$it.get();
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.get()");
                                BuildReportsService.access$addBuildScanReport((BuildReportsService)object, event, new BuildScanExtensionHolder(this.$buildScanExtension));
                            }
                        };
                    }
                }));
            }
            return buildServiceRegistration;
        }

        @Nullable
        public final Provider<BuildReportsService> registerIfAbsent(@NotNull Project project, @NotNull Provider<BuildMetricsService> buildMetricsService) {
            Provider<BuildReportsService> provider;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(buildMetricsService, (String)"buildMetricsService");
            Provider<BuildReportsService> provider2 = this.registerIfAbsentImpl(project, buildMetricsService);
            if (provider2 != null) {
                Provider<BuildReportsService> provider3;
                Provider<BuildReportsService> serviceProvider = provider3 = provider2;
                boolean bl = false;
                String string = UsesBuildReportsService.class.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UsesBuildReportsService::class.java.name");
                SingleActionPerProject.INSTANCE.run(project, string, (Function0<Unit>)((Function0)new Function0<Unit>(project, serviceProvider){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Provider<BuildReportsService> $serviceProvider;
                    {
                        this.$project = $project;
                        this.$serviceProvider = $serviceProvider;
                        super(0);
                    }

                    public final void invoke() {
                        TaskContainer taskContainer = this.$project.getTasks();
                        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                        TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
                        boolean $i$f$withType = false;
                        TaskCollection taskCollection = $this$withType$iv.withType(UsesBuildReportsService.class);
                        Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"withType(S::class.java)");
                        Function1 function1 = (Function1)new Function1<UsesBuildReportsService, Unit>(this.$serviceProvider){
                            final /* synthetic */ Provider<BuildReportsService> $serviceProvider;
                            {
                                this.$serviceProvider = $serviceProvider;
                                super(1);
                            }

                            public final void invoke(UsesBuildReportsService task2) {
                                task2.usesService(this.$serviceProvider);
                            }
                        };
                        taskCollection.configureEach(new /* invalid duplicate definition of identical inner class */);
                    }
                }));
                provider = provider3;
            } else {
                provider = null;
            }
            return provider;
        }

        private final ArrayList<StatTag> setupTags(Gradle gradle) {
            ArrayList<StatTag> additionalTags = new ArrayList<StatTag>();
            if (ConfigurationCacheKt.isConfigurationCacheAvailable(gradle)) {
                additionalTags.add(StatTag.CONFIGURATION_CACHE);
            }
            if (gradle.getStartParameter().isBuildCacheEnabled()) {
                additionalTags.add(StatTag.BUILD_CACHE);
            }
            return additionalTags;
        }

        @Nullable
        public final String getHostName() {
            return hostName;
        }

        public static final /* synthetic */ ArrayList access$setupTags(Companion $this, Gradle gradle) {
            return $this.setupTags(gradle);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

