/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.maven.K2JSCompilerMojo;

@Mojo(name="test-js", defaultPhase=LifecyclePhase.TEST_COMPILE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class KotlinTestJSCompilerMojo
extends K2JSCompilerMojo {
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project.testCompileSourceRoots}", required=true)
    private List<String> defaultSourceDirs;
    @Parameter
    private List<String> sourceDirs;
    @Parameter(defaultValue="${project.build.directory}/test-js/${project.artifactId}-tests.js", required=true)
    private String outputFile;
    @Parameter(defaultValue="true")
    private boolean metaInfo;

    @Override
    public List<String> getSourceFilePaths() {
        if (this.sourceDirs != null && !this.sourceDirs.isEmpty()) {
            return this.sourceDirs;
        }
        return this.defaultSourceDirs;
    }

    @Override
    protected void configureSpecificCompilerArguments(@NotNull K2JSCompilerArguments arguments) throws MojoExecutionException {
        List friends = this.getOutputDirectoriesCollector().getOrDefault(this.project.getArtifactId(), Collections.emptyList());
        arguments.friendModules = StringUtil.join(friends, (String)File.pathSeparator);
        this.output = this.testOutput;
        super.configureSpecificCompilerArguments(arguments);
        arguments.outputFile = this.outputFile;
        arguments.metaInfo = this.metaInfo;
    }

    @Override
    protected List<String> getClassPathElements() throws DependencyResolutionRequiredException {
        return this.project.getTestClasspathElements();
    }

    @Override
    protected List<String> getRelatedSourceRoots(MavenProject project) {
        return project.getTestCompileSourceRoots();
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Test compilation is skipped");
        } else {
            super.execute();
        }
    }
}

