/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.plugin.spring.config;

import java.util.Map;
import java.util.function.Consumer;
import org.jfaster.mango.plugin.spring.config.MangoConfig;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.bind.handler.IgnoreErrorsBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySources;

public class MangoConfigFactory {
    public static MangoConfig getMangoConfig(DefaultListableBeanFactory beanFactory, String prefix) {
        MangoConfig config = new MangoConfig();
        Bindable target = Bindable.ofInstance((Object)config);
        PropertySources propertySources = MangoConfigFactory.getPropertySources(beanFactory);
        BindHandler bindHandler = MangoConfigFactory.getBindHandler();
        BindResult configBindResult = MangoConfigFactory.getBinder(propertySources, beanFactory).bind(prefix, target, bindHandler);
        return (MangoConfig)configBindResult.get();
    }

    private static Binder getBinder(PropertySources propertySources, DefaultListableBeanFactory beanFactory) {
        return new Binder(MangoConfigFactory.getConfigurationPropertySources(propertySources), (PlaceholdersResolver)MangoConfigFactory.getPropertySourcesPlaceholdersResolver(propertySources), MangoConfigFactory.getConversionService(), MangoConfigFactory.getPropertyEditorInitializer(beanFactory));
    }

    private static Consumer<PropertyEditorRegistry> getPropertyEditorInitializer(DefaultListableBeanFactory beanFactory) {
        return arg_0 -> ((DefaultListableBeanFactory)beanFactory).copyRegisteredEditorsTo(arg_0);
    }

    private static ConversionService getConversionService() {
        return new DefaultConversionService();
    }

    private static Iterable<ConfigurationPropertySource> getConfigurationPropertySources(PropertySources propertySources) {
        return ConfigurationPropertySources.from((Iterable)propertySources);
    }

    private static PropertySourcesPlaceholdersResolver getPropertySourcesPlaceholdersResolver(PropertySources propertySources) {
        return new PropertySourcesPlaceholdersResolver((Iterable)propertySources);
    }

    private static BindHandler getBindHandler() {
        IgnoreErrorsBindHandler handler = new IgnoreErrorsBindHandler();
        return handler;
    }

    public static PropertySources getPropertySources(DefaultListableBeanFactory beanFactory) {
        PropertySourcesPlaceholderConfigurer configurer = MangoConfigFactory.getSinglePropertySourcesPlaceholderConfigurer(beanFactory);
        if (configurer != null) {
            return configurer.getAppliedPropertySources();
        }
        MutablePropertySources sources = MangoConfigFactory.extractEnvironmentPropertySources(beanFactory);
        if (sources != null) {
            return sources;
        }
        throw new IllegalStateException("Unable to obtain PropertySources from PropertySourcesPlaceholderConfigurer or Environment");
    }

    private static MutablePropertySources extractEnvironmentPropertySources(DefaultListableBeanFactory beanFactory) {
        Environment environment = (Environment)beanFactory.getBean(Environment.class);
        if (environment instanceof ConfigurableEnvironment) {
            return ((ConfigurableEnvironment)environment).getPropertySources();
        }
        return null;
    }

    private static PropertySourcesPlaceholderConfigurer getSinglePropertySourcesPlaceholderConfigurer(DefaultListableBeanFactory beanFactory) {
        Map beans = beanFactory.getBeansOfType(PropertySourcesPlaceholderConfigurer.class, false, false);
        if (beans.size() == 1) {
            return (PropertySourcesPlaceholderConfigurer)beans.values().iterator().next();
        }
        return null;
    }
}

