/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.plugin.spring.starter;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.jfaster.mango.annotation.DB;
import org.jfaster.mango.datasource.DataSourceFactory;
import org.jfaster.mango.datasource.MasterSlaveDataSourceFactory;
import org.jfaster.mango.datasource.SimpleDataSourceFactory;
import org.jfaster.mango.interceptor.Interceptor;
import org.jfaster.mango.operator.Mango;
import org.jfaster.mango.operator.cache.CacheHandler;
import org.jfaster.mango.plugin.spring.DefaultMangoFactoryBean;
import org.jfaster.mango.plugin.spring.config.MangoConfig;
import org.jfaster.mango.plugin.spring.config.MangoConfigFactory;
import org.jfaster.mango.plugin.spring.config.MangoDataSourceConfig;
import org.jfaster.mango.plugin.spring.config.MangoHikaricpConfig;
import org.jfaster.mango.plugin.spring.exception.MangoAutoConfigException;
import org.jfaster.mango.plugin.spring.starter.MangoAutoConfiguration;
import org.jfaster.mango.util.Strings;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;
import org.jfaster.mango.util.reflect.Reflection;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

public class MangoDaoAutoCreator
implements BeanFactoryPostProcessor,
BeanPostProcessor,
ApplicationContextAware {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MangoDaoAutoCreator.class);
    private static final String PREFIX = "mango";
    private static final List<String> DAO_ENDS = Arrays.asList("Dao", "DAO");
    Class<?> factoryBeanClass = DefaultMangoFactoryBean.class;
    private ApplicationContext context;
    private MangoConfig config;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)configurableListableBeanFactory;
        this.config = MangoConfigFactory.getMangoConfig(beanFactory, PREFIX);
        if (this.config == null) {
            throw new MangoAutoConfigException("Mango config file does not exist!");
        }
        String mangoDaoPackage = this.config.getScanPackage();
        if (Strings.isEmpty((String)mangoDaoPackage)) {
            throw new MangoAutoConfigException("mango.scan-package is not configured");
        }
        if (!Strings.isEmpty((String)this.config.getFactoryClass())) {
            try {
                this.factoryBeanClass = ClassUtils.forName((String)this.config.getFactoryClass(), (ClassLoader)MangoAutoConfiguration.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new MangoAutoConfigException(e);
            }
        }
        if (this.factoryBeanClass.equals(DefaultMangoFactoryBean.class)) {
            List<MangoDataSourceConfig> datasources = this.config.getDatasources();
            if (datasources == null || datasources.size() == 0) {
                throw new MangoAutoConfigException("mango.datasources is not configured");
            }
            this.registryMangoInstance(beanFactory);
        }
        this.registryMangoDao(beanFactory);
    }

    private void registryMangoInstance(DefaultListableBeanFactory beanFactory) {
        BeanDefinitionBuilder mangoBuilder = BeanDefinitionBuilder.rootBeanDefinition(Mango.class);
        mangoBuilder.setFactoryMethod("newInstance");
        mangoBuilder.addPropertyValue("checkColumn", (Object)this.config.isCheckColumn());
        mangoBuilder.addPropertyValue("compatibleWithEmptyList", (Object)this.config.isCompatibleWithEmptyList());
        mangoBuilder.addPropertyValue("lazyInit", (Object)this.config.isLazyInit());
        mangoBuilder.addPropertyValue("useActualParamName", (Object)this.config.isUseActualParamName());
        mangoBuilder.addPropertyValue("useTransactionForBatchUpdate", (Object)this.config.isUseTransactionForBatchUpdate());
        this.configCacheHandler(mangoBuilder);
        beanFactory.registerBeanDefinition(Mango.class.getName(), (BeanDefinition)mangoBuilder.getBeanDefinition());
    }

    private void configCacheHandler(BeanDefinitionBuilder mangoBuilder) {
        String cacheHandlerClassPath = this.config.getCacheHandler();
        if (!Strings.isEmpty((String)cacheHandlerClassPath)) {
            try {
                Class<?> cachHandlerClz = Class.forName(cacheHandlerClassPath);
                CacheHandler cacheHandler = (CacheHandler)Reflection.instantiateClass(cachHandlerClz);
                mangoBuilder.addPropertyValue("cacheHandler", (Object)cacheHandler);
            }
            catch (Throwable e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    private void configMangoDatasourceFactory(Mango mango) {
        for (MangoDataSourceConfig dataSourceConfig : this.config.getDatasources()) {
            SimpleDataSourceFactory dataSourceFactory;
            String name = dataSourceConfig.getName();
            MangoHikaricpConfig masterConfig = dataSourceConfig.getMaster();
            List<MangoHikaricpConfig> slaveConfigs = dataSourceConfig.getSlaves();
            if (masterConfig == null) {
                throw new MangoAutoConfigException("Does not exist master datasource");
            }
            if (Strings.isEmpty((String)name)) {
                name = "DEFAULT";
            }
            DataSource masterDataSource = this.getDataSource(masterConfig);
            if (slaveConfigs == null || slaveConfigs.isEmpty()) {
                dataSourceFactory = new SimpleDataSourceFactory(name, masterDataSource);
            } else {
                ArrayList<DataSource> slaves = new ArrayList<DataSource>(slaveConfigs.size());
                for (MangoHikaricpConfig hikaricpConfig : slaveConfigs) {
                    slaves.add(this.getDataSource(hikaricpConfig));
                }
                dataSourceFactory = new MasterSlaveDataSourceFactory(name, masterDataSource, slaves);
            }
            mango.addDataSourceFactory((DataSourceFactory)dataSourceFactory);
        }
    }

    private DataSource getDataSource(MangoHikaricpConfig dataSourceConfig) {
        if (!Strings.isEmpty((String)dataSourceConfig.getRef())) {
            DataSource dataSource = (DataSource)this.context.getBean(dataSourceConfig.getRef(), DataSource.class);
            if (dataSource == null) {
                throw new MangoAutoConfigException("'%s' not exist in spring context", dataSourceConfig.getRef());
            }
            return dataSource;
        }
        return new HikariDataSource((HikariConfig)dataSourceConfig);
    }

    private void registryMangoDao(DefaultListableBeanFactory beanFactory) {
        for (Class<?> daoClass : this.findMangoDaoClasses(this.config.getScanPackage())) {
            GenericBeanDefinition bf = new GenericBeanDefinition();
            bf.setBeanClassName(daoClass.getName());
            MutablePropertyValues pvs = bf.getPropertyValues();
            pvs.addPropertyValue("daoClass", daoClass);
            bf.setBeanClass(this.factoryBeanClass);
            bf.setPropertyValues(pvs);
            bf.setLazyInit(false);
            beanFactory.registerBeanDefinition(daoClass.getName(), (BeanDefinition)bf);
        }
    }

    private List<Class<?>> findMangoDaoClasses(String packages) {
        try {
            ArrayList daos = new ArrayList();
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
            CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
            for (String locationPattern : this.getLocationPattern(packages)) {
                Resource[] rs;
                for (Resource r : rs = resourcePatternResolver.getResources(locationPattern)) {
                    MetadataReader reader = metadataReaderFactory.getMetadataReader(r);
                    AnnotationMetadata annotationMD = reader.getAnnotationMetadata();
                    if (!annotationMD.hasAnnotation(DB.class.getName())) continue;
                    ClassMetadata clazzMD = reader.getClassMetadata();
                    daos.add(Class.forName(clazzMD.getClassName()));
                }
            }
            return daos;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private List<String> getLocationPattern(String packages) {
        String[] locationPackages;
        ArrayList<String> locationPatterns = new ArrayList<String>();
        for (String p : locationPackages = packages.split("\\s*[,;]+\\s*")) {
            for (String daoEnd : DAO_ENDS) {
                String locationPattern = "classpath*:" + p.replaceAll("\\.", "/") + "/**/*" + daoEnd + ".class";
                logger.info("trnas package[" + p + "] to locationPattern[" + locationPattern + "]");
                locationPatterns.add(locationPattern);
            }
        }
        return locationPatterns;
    }

    public Object postProcessBeforeInitialization(Object bean, String s) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String s) throws BeansException {
        if (bean instanceof Mango) {
            Mango mango = (Mango)bean;
            List<String> interceptorClassPaths = this.config.getInterceptors();
            if (interceptorClassPaths != null && interceptorClassPaths.size() != 0) {
                for (String interceptorClassPath : interceptorClassPaths) {
                    try {
                        Class<?> interceptorClz = Class.forName(interceptorClassPath);
                        Interceptor interceptor = (Interceptor)Reflection.instantiateClass(interceptorClz);
                        mango.addInterceptor(interceptor);
                    }
                    catch (Throwable e) {
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                }
            }
            if (this.factoryBeanClass.equals(DefaultMangoFactoryBean.class)) {
                this.configMangoDatasourceFactory(mango);
            }
        }
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

