/*
 * Decompiled with CFR 0.152.
 */
package jodd.http.net;

import java.io.IOException;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import jodd.http.HttpConnection;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.ProxyInfo;
import jodd.http.net.HTTPProxySocketFactory;
import jodd.http.net.SocketHttpConnection;
import jodd.http.net.Socks4ProxySocketFactory;
import jodd.http.net.Socks5ProxySocketFactory;

public class SocketHttpConnectionProvider
implements HttpConnectionProvider {
    protected ProxyInfo proxy = ProxyInfo.directProxy();

    public void useProxy(ProxyInfo proxyInfo) {
        this.proxy = proxyInfo;
    }

    public HttpConnection createHttpConnection(HttpRequest httpRequest) throws IOException {
        Socket socket;
        if (httpRequest.protocol().equalsIgnoreCase("https")) {
            SSLSocket sslSocket = (SSLSocket)this.createSocket(SSLSocketFactory.getDefault(), httpRequest.host(), httpRequest.port());
            sslSocket.startHandshake();
            socket = sslSocket;
        } else {
            SocketFactory socketFactory = this.getSocketFactory(this.proxy);
            socket = this.createSocket(socketFactory, httpRequest.host(), httpRequest.port());
        }
        return new SocketHttpConnection(socket);
    }

    protected Socket createSocket(SocketFactory socketFactory, String host, int port) throws IOException {
        return socketFactory.createSocket(host, port);
    }

    public SocketFactory getSocketFactory(ProxyInfo proxy) {
        switch (proxy.getProxyType()) {
            case NONE: {
                return SocketFactory.getDefault();
            }
            case HTTP: {
                return new HTTPProxySocketFactory(proxy);
            }
            case SOCKS4: {
                return new Socks4ProxySocketFactory(proxy);
            }
            case SOCKS5: {
                return new Socks5ProxySocketFactory(proxy);
            }
        }
        return null;
    }
}

