/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.Functions;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.functions.AbstractFunction;
import org.jpmml.evaluator.functions.BinaryFunction;

public class FunctionRegistry {
    private static final Map<String, Function> pmmlFunctions;
    private static final Map<String, Function> userDefinedFunctions;
    private static final Map<String, Class<?>> userDefinedFunctionClazzes;

    private FunctionRegistry() {
    }

    public static Function getFunction(String name) {
        Class<?> functionClazz;
        if (name == null) {
            return null;
        }
        if (pmmlFunctions.containsKey(name)) {
            Function function = pmmlFunctions.get(name);
            return function;
        }
        if (userDefinedFunctions.containsKey(name)) {
            Function function = userDefinedFunctions.get(name);
            return function;
        }
        if (userDefinedFunctionClazzes.containsKey(name)) {
            functionClazz = userDefinedFunctionClazzes.get(name);
        } else {
            functionClazz = FunctionRegistry.loadFunctionClass(name);
            userDefinedFunctionClazzes.put(name, functionClazz);
        }
        if (functionClazz != null) {
            Function function;
            try {
                Constructor<?> constructor = functionClazz.getDeclaredConstructor(new Class[0]);
                function = (Function)constructor.newInstance(new Object[0]);
            }
            catch (ExceptionInInitializerError | ReflectiveOperationException e) {
                throw new EvaluationException("Function class " + EvaluationException.formatName(functionClazz.getName()) + " could not be instantiated").initCause(e);
            }
            return function;
        }
        return null;
    }

    public static void putFunction(Function function) {
        FunctionRegistry.putFunction(function.getName(), function);
    }

    public static void putFunction(String name, Function function) {
        name = Objects.requireNonNull(name);
        function = Objects.requireNonNull(function);
        userDefinedFunctions.put(name, function);
    }

    public static void putFunction(String name, Class<? extends Function> functionClazz) {
        name = Objects.requireNonNull(name);
        functionClazz = FunctionRegistry.checkClass(Objects.requireNonNull(functionClazz));
        userDefinedFunctionClazzes.put(name, functionClazz);
    }

    public static void removeFunction(String name) {
        userDefinedFunctions.remove(name);
        userDefinedFunctionClazzes.remove(name);
    }

    private static Class<?> loadFunctionClass(String name) {
        Class<?> clazz;
        try {
            ClassLoader clazzLoader = FunctionRegistry.class.getClassLoader();
            clazz = clazzLoader.loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        return FunctionRegistry.checkClass(clazz);
    }

    private static <E> Class<E> checkClass(Class<E> clazz) {
        if (!Function.class.isAssignableFrom(clazz)) {
            throw new TypeCheckException(Function.class, clazz);
        }
        return clazz;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        List<AbstractFunction> functions = Arrays.asList(Functions.ADD, Functions.SUBTRACT, Functions.MULTIPLY, Functions.DIVIDE, Functions.MIN, Functions.MAX, Functions.AVG, Functions.SUM, Functions.PRODUCT, Functions.LOG10, Functions.LN, Functions.EXP, Functions.SQRT, Functions.ABS, Functions.POW, Functions.THRESHOLD, Functions.FLOOR, Functions.CEIL, Functions.ROUND, Functions.MODULO, Functions.IS_MISSING, Functions.IS_NOT_MISSING, Functions.IS_VALID, Functions.IS_NOT_VALID, Functions.EQUAL, Functions.NOT_EQUAL, Functions.LESS_THAN, Functions.LESS_OR_EQUAL, Functions.GREATER_THAN, Functions.GREATER_OR_EQUAL, Functions.AND, Functions.OR, Functions.NOT, Functions.IS_IN, Functions.IS_NOT_IN, Functions.IF, Functions.UPPERCASE, Functions.LOWERCASE, Functions.STRING_LENGTH, Functions.SUBSTRING, Functions.TRIM_BLANKS, Functions.CONCAT, Functions.REPLACE, Functions.MATCHES, Functions.FORMAT_NUMBER, Functions.FORMAT_DATETIME, Functions.DATE_DAYS_SINCE_YEAR, Functions.DATE_SECONDS_SINCE_MIDNIGHT, Functions.DATE_SECONDS_SINCE_YEAR, Functions.EXPM1, Functions.HYPOT, Functions.LN1P, Functions.RINT, Functions.SIN, Functions.ASIN, Functions.SINH, Functions.COS, Functions.ACOS, Functions.COSH, Functions.TAN, Functions.ATAN, Functions.TANH);
        for (Function function : functions) {
            builder.put((Object)function.getName(), (Object)function);
        }
        List<BinaryFunction> extensionFunctions = Arrays.asList(Functions.ATAN2);
        for (Function function : extensionFunctions) {
            builder.put((Object)function.getName(), (Object)function);
        }
        pmmlFunctions = builder.build();
        userDefinedFunctions = new LinkedHashMap<String, Function>();
        userDefinedFunctionClazzes = new LinkedHashMap();
    }
}

