/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.CollectionValue;
import org.jpmml.evaluator.DiscreteValue;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.model.ToStringHelper;

public class OrdinalValue
extends DiscreteValue {
    private List<?> ordering = null;

    OrdinalValue() {
    }

    OrdinalValue(DataType dataType, List<?> ordering, Object value) {
        super(dataType, value);
        this.setOrdering(ordering);
    }

    @Override
    public OpType getOpType() {
        return OpType.ORDINAL;
    }

    @Override
    public int compareToValue(Object value) {
        List<?> ordering = this.getOrdering();
        if (ordering == null) {
            return super.compareToValue(value);
        }
        return OrdinalValue.compare(ordering, this.getValue(), TypeUtil.parseOrCast(this.getDataType(), value));
    }

    @Override
    public int compareToValue(FieldValue value) {
        List<?> ordering = this.getOrdering();
        if (ordering == null) {
            return super.compareToValue(value);
        }
        return OrdinalValue.compare(ordering, this.getValue(), value.getValue(this.getDataType()));
    }

    @Override
    public int hashCode() {
        List<?> ordering = this.getOrdering();
        if (ordering == null) {
            return super.hashCode();
        }
        return 31 * super.hashCode() + ordering.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OrdinalValue) {
            OrdinalValue that = (OrdinalValue)object;
            return super.equals(object) && Objects.equals(this.getOrdering(), that.getOrdering());
        }
        return false;
    }

    @Override
    protected ToStringHelper toStringHelper() {
        ToStringHelper helper = super.toStringHelper().add("ordering", this.getOrdering());
        return helper;
    }

    @Override
    public List<?> getOrdering() {
        return this.ordering;
    }

    private void setOrdering(List<?> ordering) {
        this.ordering = ordering;
    }

    public static FieldValue create(DataType dataType, List<?> ordering, Object value) {
        if (ordering != null && ordering.isEmpty()) {
            ordering = null;
        }
        if (value instanceof Collection) {
            return new CollectionValue(OpType.ORDINAL, dataType, ordering, (Collection)value);
        }
        switch (dataType) {
            case STRING: {
                return new OrdinalString(ordering, value);
            }
        }
        return new OrdinalValue(dataType, ordering, value);
    }

    private static int compare(List<?> ordering, Object left, Object right) {
        int rightIndex;
        int leftIndex = ordering.indexOf(left);
        if ((leftIndex | (rightIndex = ordering.indexOf(right))) < 0) {
            throw new EvaluationException("Values " + EvaluationException.formatValue(left) + " and " + EvaluationException.formatValue(right) + " cannot be ordered");
        }
        return leftIndex - rightIndex;
    }

    private static class OrdinalString
    extends OrdinalValue {
        private OrdinalString() {
        }

        OrdinalString(List<?> ordering, Object value) {
            super(DataType.STRING, ordering, value);
        }

        @Override
        public boolean equalsValue(Object value) {
            if (value instanceof String) {
                return this.asString().equals(value);
            }
            return super.equalsValue(value);
        }

        @Override
        public String asString() {
            return (String)this.getValue();
        }
    }
}

