/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.association;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.association.AssociationRule;
import org.jpmml.evaluator.AbstractComputable;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.HasRuleValues;
import org.jpmml.model.ToStringHelper;

public abstract class Association
extends AbstractComputable
implements HasEntityRegistry<AssociationRule>,
HasRuleValues {
    private List<AssociationRule> associationRules = null;
    private BitSet antecedentFlags = null;
    private BitSet consequentFlags = null;

    protected Association(List<AssociationRule> associationRules, BitSet antecedentFlags, BitSet consequentFlags) {
        this.setAssociationRules(associationRules);
        this.setAntecedentFlags(antecedentFlags);
        this.setConsequentFlags(consequentFlags);
    }

    @Override
    public Object getResult() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ToStringHelper toStringHelper() {
        ToStringHelper helper = super.toStringHelper().add("antecedentFlags", (Object)this.getAntecedentFlags()).add("consequentFlags", (Object)this.getConsequentFlags());
        return helper;
    }

    @Override
    public List<AssociationRule> getRuleValues(OutputField.Algorithm algorithm) {
        BitSet flags;
        List<AssociationRule> associationRules = this.getAssociationRules();
        switch (algorithm) {
            case RECOMMENDATION: {
                flags = this.getAntecedentFlags();
                break;
            }
            case EXCLUSIVE_RECOMMENDATION: {
                flags = (BitSet)this.getAntecedentFlags().clone();
                flags.andNot(this.getConsequentFlags());
                break;
            }
            case RULE_ASSOCIATION: {
                flags = (BitSet)this.getAntecedentFlags().clone();
                flags.and(this.getConsequentFlags());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int cardinality = flags.cardinality();
        if (cardinality == 0) {
            return Collections.emptyList();
        }
        ArrayList<AssociationRule> result = new ArrayList<AssociationRule>(cardinality);
        int i = flags.nextSetBit(0);
        while (i > -1) {
            AssociationRule associationRule = associationRules.get(i);
            result.add(associationRule);
            i = flags.nextSetBit(i + 1);
        }
        return result;
    }

    public List<AssociationRule> getAssociationRules() {
        return this.associationRules;
    }

    private void setAssociationRules(List<AssociationRule> associationRules) {
        this.associationRules = Objects.requireNonNull(associationRules);
    }

    public BitSet getAntecedentFlags() {
        return this.antecedentFlags;
    }

    private void setAntecedentFlags(BitSet antecedentFlags) {
        this.antecedentFlags = Objects.requireNonNull(antecedentFlags);
    }

    public BitSet getConsequentFlags() {
        return this.consequentFlags;
    }

    private void setConsequentFlags(BitSet consequentFlags) {
        this.consequentFlags = Objects.requireNonNull(consequentFlags);
    }
}

